/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.utils.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvExportRelatedFastaRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private File fastaFile;
    private File outputFile;
    private static final char FASTA_START_CHAR = '>';
    private int[] csvColumnIndices;
    private String glue;
    private boolean trim = false;
    private int trimStartColIndex = -1;
    private int trimEndColIndex = -1;
    private int[] fastaColumnIndices;
    private String fastaSeparator;
    private List<String> listMatchingNames;

    public CsvExportRelatedFastaRunnable(CSVEditor csvEditor, File fastaFile, int[] csvColumnIndices, String glue, int[] fastaColumnIndices, String fastaSeparator, List<String> listMatchingNames, File outputFile) {
        this.csvEditor = csvEditor;
        this.fastaFile = fastaFile;
        this.outputFile = outputFile;
        this.csvColumnIndices = csvColumnIndices;
        this.glue = glue;
        this.fastaColumnIndices = fastaColumnIndices;
        this.fastaSeparator = fastaSeparator;
        this.listMatchingNames = listMatchingNames;
    }

    public CsvExportRelatedFastaRunnable(CSVEditor csvEditor, File fastaFile, int[] csvColumnIndices, String glue, int[] fastaColumnIndices, String fastaSeparator, File outputFile) {
        this.csvEditor = csvEditor;
        this.fastaFile = fastaFile;
        this.outputFile = outputFile;
        this.csvColumnIndices = csvColumnIndices;
        this.glue = glue;
        this.fastaColumnIndices = fastaColumnIndices;
        this.fastaSeparator = fastaSeparator;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.doParseMethod2();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void trimSequences(int startColIndex, int endColIndex) {
        this.trim = true;
        this.trimStartColIndex = startColIndex;
        this.trimEndColIndex = endColIndex;
    }

    private void doParseMethod2() throws IOException {
        TreeMap<String, CsvAnnotation> mapCSVNames = new TreeMap<String, CsvAnnotation>();
        for (List row : (List)this.csvEditor.getModel()) {
            if (!((String)row.get(0)).equals("1")) continue;
            String sequenceName = this.buildSequenceName(row);
            if (this.listMatchingNames != null && (this.listMatchingNames == null || this.listMatchingNames.size() <= 0) || this.listMatchingNames != null && Collections.binarySearch(this.listMatchingNames, sequenceName) < 0) continue;
            String annotation = this.getAnnotation(row);
            int startPosition = -1;
            int endPosition = -1;
            try {
                startPosition = Integer.parseInt((String)row.get(this.trimStartColIndex));
                endPosition = Integer.parseInt((String)row.get(this.trimEndColIndex)) - 1;
            }
            catch (Exception ex) {
                startPosition = -1;
                endPosition = -1;
            }
            CsvAnnotation csvAnnotation = new CsvAnnotation(annotation, startPosition, endPosition);
            mapCSVNames.put(sequenceName, csvAnnotation);
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.fastaFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFile));
        try {
            String line;
            StringBuilder builderSequence = null;
            String lastSequenceName = null;
            boolean writeSequence = false;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                if (line.charAt(0) == '>') {
                    String lineName = line.substring(1);
                    if (mapCSVNames.containsKey(lineName)) {
                        writeSequence = true;
                        if (lastSequenceName != null) {
                            this.writeSequenceToFile(writer, (CsvAnnotation)mapCSVNames.get(lastSequenceName), builderSequence);
                        }
                        lastSequenceName = lineName;
                        builderSequence = new StringBuilder();
                        continue;
                    }
                    writeSequence = false;
                    continue;
                }
                if (!writeSequence) continue;
                builderSequence.append(line);
                builderSequence.append("\n");
            }
            if (lastSequenceName != null) {
                this.writeSequenceToFile(writer, (CsvAnnotation)mapCSVNames.get(lastSequenceName), builderSequence);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private void writeSequenceToFile(BufferedWriter writer, CsvAnnotation csvAnnotation, StringBuilder builderSequence) throws IOException {
        writer.append(">" + csvAnnotation.getAnnotation());
        writer.append("\n");
        if (this.trim) {
            if (csvAnnotation.getStart() != -1 && csvAnnotation.getEnd() != -1) {
                writer.append(this.trimSequence(builderSequence.toString(), csvAnnotation.getStart(), csvAnnotation.getEnd(), 100));
                writer.append("\n");
            }
        } else {
            writer.append(builderSequence.toString());
        }
    }

    private String buildSequenceName(List<String> row) {
        ArrayList<String> listParts = new ArrayList<String>();
        listParts.add(row.get(this.fastaColumnIndices[0] + 2));
        int i = 1;
        while (i < this.fastaColumnIndices.length) {
            listParts.add(row.get(this.fastaColumnIndices[i]));
            ++i;
        }
        return StringUtils.join(listParts, (String)this.fastaSeparator);
    }

    private String getAnnotation(List<String> row) {
        ArrayList<String> buffer = new ArrayList<String>();
        int[] nArray = this.csvColumnIndices;
        int n = this.csvColumnIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int c = nArray[n2];
            buffer.add(row.get(c));
            ++n2;
        }
        return StringUtils.join(buffer, (String)this.glue);
    }

    private String trimSequence(String sequence, int start, int end, int blockSize) {
        sequence = sequence.replace("\r", "");
        if (end > (sequence = sequence.replace("\n", "")).length()) {
            end = sequence.length();
        }
        if (blockSize != -1) {
            return this.blockSequence(sequence.substring(start - 1, end), blockSize);
        }
        return sequence.substring(start - 1, end);
    }

    private String blockSequence(String sequence, int blockSize) {
        StringBuilder builder = new StringBuilder();
        int lineCounter = 0;
        int originalSeqLen = sequence.length();
        int i = 0;
        while (i < originalSeqLen) {
            char c = sequence.charAt(i);
            if (c != '\n' && c != '\r' && c != ' ') {
                if (lineCounter > 0 && lineCounter % blockSize == 0) {
                    builder.append("\n");
                }
                builder.append(c);
                ++lineCounter;
            }
            ++i;
        }
        return builder.toString();
    }

    protected class CsvAnnotation {
        private String annotation;
        private int start = 0;
        private int end = 0;

        public CsvAnnotation(String annotation, int start, int end) {
            this.annotation = annotation;
            this.start = start;
            this.end = end;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

