/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvExportModelRunnable
implements IRunnableWithProgress {
    private List<List<String>> model;
    private List<Integer> rowIndices;
    private List<String> columnNames;
    private List<Integer> columnIndices;
    private File outputFile;
    private String comments;
    private String separator = ";";
    private String delimiter = "\"";
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private int taskUnit = 1;
    private List<String> listMatchingNames;
    private int[] listAssociationIndices;
    private String associationSeparator;

    public CsvExportModelRunnable(List<List<String>> model, List<Integer> rowIndices, List<String> columnNames, List<Integer> columnIndices, File outputFile, String comments, String separator, String delimiter) {
        this.model = model;
        this.rowIndices = rowIndices;
        this.columnNames = columnNames;
        this.columnIndices = columnIndices;
        this.outputFile = outputFile;
        this.comments = comments;
        this.separator = separator;
        this.delimiter = delimiter;
    }

    public CsvExportModelRunnable(List<List<String>> model, List<Integer> rowIndices, List<String> columnNames, List<Integer> columnIndices, File outputFile, String comments) {
        this.model = model;
        this.rowIndices = rowIndices;
        this.columnNames = columnNames;
        this.columnIndices = columnIndices;
        this.outputFile = outputFile;
        this.comments = comments;
    }

    public CsvExportModelRunnable(List<List<String>> model, List<Integer> rowIndices, List<String> columnNames, List<Integer> columnIndices, int[] listAssociationIndices, String associationSeparator, List<String> listMatchingNames, File outputFile, String comments) {
        this.model = model;
        this.rowIndices = rowIndices;
        this.columnNames = columnNames;
        this.columnIndices = columnIndices;
        this.listAssociationIndices = listAssociationIndices;
        this.associationSeparator = associationSeparator;
        this.listMatchingNames = listMatchingNames;
        this.outputFile = outputFile;
        this.comments = comments;
    }

    public CsvExportModelRunnable(List<List<String>> model, List<Integer> rowIndices, List<String> columnNames, List<Integer> columnIndices, File outputFile) {
        this(model, rowIndices, columnNames, columnIndices, outputFile, null);
    }

    public CsvExportModelRunnable(List<List<String>> model, List<Integer> rowIndices, List<String> columnNames, List<Integer> columnIndices, int[] listAssociationIndices, String associationSeparator, List<String> listMatchingNames, File outputFile) {
        this(model, rowIndices, columnNames, columnIndices, listAssociationIndices, associationSeparator, listMatchingNames, outputFile, null);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.exportModel(monitor);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void exportModel(IProgressMonitor monitor) throws InterruptedException, IOException {
        if (this.rowIndices.size() > 100) {
            this.taskUnit = this.rowIndices.size() / 100;
        }
        monitor.beginTask("Export worksheet selection", this.rowIndices.size());
        BufferedWriter bwriter = new BufferedWriter(new FileWriter(this.outputFile));
        try {
            if (this.comments != null && this.comments.length() > 0) {
                bwriter.append(this.comments);
                bwriter.newLine();
            }
            for (String cn : this.columnNames) {
                bwriter.append(this.delimiter + cn + this.delimiter + this.separator);
            }
            bwriter.newLine();
            int i = 0;
            while (i < this.rowIndices.size()) {
                int rowIndex = this.rowIndices.get(i);
                List<String> row = this.model.get(rowIndex);
                boolean doWrite = false;
                if (this.listMatchingNames != null && this.listMatchingNames.size() > 0) {
                    String csvSequenceName = this.buildSequenceName(row);
                    if (Collections.binarySearch(this.listMatchingNames, csvSequenceName) >= 0) {
                        doWrite = true;
                    }
                } else {
                    doWrite = true;
                }
                if (doWrite) {
                    for (int co : this.columnIndices) {
                        bwriter.append(this.delimiter + row.get(co) + this.delimiter + this.separator);
                    }
                    bwriter.newLine();
                }
                if (i % this.taskUnit == 0) {
                    monitor.worked(this.taskUnit);
                    monitor.subTask("Exported " + this.decimalFormat.format(i) + " rows of " + this.decimalFormat.format(this.rowIndices.size()));
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            bwriter.close();
            monitor.done();
        }
    }

    private String buildSequenceName(List<String> row) {
        ArrayList<String> cols = new ArrayList<String>();
        int[] nArray = this.listAssociationIndices;
        int n = this.listAssociationIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            cols.add(row.get(i).trim());
            ++n2;
        }
        return StringUtils.join(cols, (String)this.associationSeparator);
    }
}

