/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.JoinedExportColumns;
import com.biotechvana.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvExportAnnotationRunnable
implements IRunnableWithProgress {
    private final String TITLE = "Export annotation";
    private CSVEditor csvEditor;
    private String[] headerNames;
    private String[] exportNames;
    private String separator;
    private String outputFolder;
    private List<JoinedExportColumns> listJoinedColumns;
    private List<Integer> listRowIndices;
    private final String REFERENCE_TAG = "Reference=";

    public CsvExportAnnotationRunnable(CSVEditor csvEditor, String[] headerNames, String[] exportNames, String separator, String outputFolder, List<JoinedExportColumns> listJoinedColumns, List<Integer> listRowIndices) {
        this.csvEditor = csvEditor;
        this.headerNames = headerNames;
        this.exportNames = exportNames;
        this.separator = separator;
        this.outputFolder = outputFolder;
        this.listJoinedColumns = listJoinedColumns;
        this.listRowIndices = listRowIndices;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.exportAnnotation(monitor);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void exportAnnotation(IProgressMonitor monitor) throws InterruptedException, IOException {
        File outputFile = new File(this.outputFolder + File.separator + "annotation.txt");
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
        try {
            monitor.beginTask("Export annotation", this.listRowIndices.size());
            List model = (List)this.csvEditor.getModel();
            String lastHeader = null;
            ArrayList<String> currentChildren = new ArrayList<String>();
            writer.append(this.buildHeader());
            writer.append("\r\n");
            writer.append("\r\n");
            for (int rowIndex : this.listRowIndices) {
                List row = (List)model.get(rowIndex);
                String currentHeader = this.buildHeader(row);
                currentChildren.add(this.buildBody(row));
                if (lastHeader != null && !currentHeader.equals(lastHeader)) {
                    writer.append(lastHeader);
                    writer.append("\r\n");
                    for (String c : currentChildren) {
                        writer.append(c);
                        writer.append("\r\n");
                    }
                    writer.append("\r\n");
                    currentChildren = new ArrayList();
                }
                lastHeader = currentHeader;
                monitor.worked(1);
            }
            writer.append(lastHeader);
            writer.append("\r\n");
            for (String c : currentChildren) {
                writer.append(c);
                writer.append("\r\n");
            }
        }
        finally {
            writer.close();
            monitor.done();
        }
    }

    private String buildBody(List<String> row) {
        ArrayList<String> child = new ArrayList<String>();
        String[] stringArray = this.exportNames;
        int n = this.exportNames.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            JoinedExportColumns jec = this.getJoined(this.listJoinedColumns, e);
            if (jec != null) {
                child.add(this.sanitizeCol(jec.getJoinName()));
            } else {
                child.add(this.sanitizeCol(row.get(this.csvEditor.getColumnIndexForName(e))));
            }
            ++n2;
        }
        return StringUtils.join(child, (String)this.separator);
    }

    private String buildHeader() {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> listHeaderNames = new ArrayList<String>();
        ArrayList<String> listData = new ArrayList<String>();
        String[] stringArray = this.headerNames;
        int n = this.headerNames.length;
        int n2 = 0;
        while (n2 < n) {
            String h = stringArray[n2];
            listHeaderNames.add(this.sanitizeCol(h));
            ++n2;
        }
        builder.append("Reference=" + StringUtils.join(listHeaderNames, (String)this.separator));
        builder.append("\r\n");
        stringArray = this.exportNames;
        n = this.exportNames.length;
        n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            JoinedExportColumns jec = this.getJoined(this.listJoinedColumns, e);
            if (jec != null) {
                listData.add(this.sanitizeCol(jec.getJoinName()));
            } else {
                listData.add(this.sanitizeCol(e));
            }
            ++n2;
        }
        builder.append(StringUtils.join(listData, (String)this.separator));
        return builder.toString();
    }

    private String buildHeader(List<String> row) {
        ArrayList<String> listHeaderNames = new ArrayList<String>();
        listHeaderNames = new ArrayList();
        String[] stringArray = this.headerNames;
        int n = this.headerNames.length;
        int n2 = 0;
        while (n2 < n) {
            String h = stringArray[n2];
            if (!h.isEmpty()) {
                listHeaderNames.add(this.sanitizeCol(row.get(this.csvEditor.getColumnIndexForName(h))));
            }
            ++n2;
        }
        return "Reference=" + StringUtils.join(listHeaderNames, (String)this.separator);
    }

    private JoinedExportColumns getJoined(List<JoinedExportColumns> listJoined, String name) {
        int length = listJoined.size();
        int i = 0;
        while (i < length) {
            if (listJoined.get(i).getJoinName().equals(name)) {
                return listJoined.get(i);
            }
            ++i;
        }
        return null;
    }

    private String sanitizeCol(String col) {
        if ((col = col.trim()).charAt(col.length() - 1) == this.separator.charAt(0)) {
            col = col.substring(0, col.length() - 1);
        }
        return col.replace(this.separator, "..");
    }
}

