/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowCheck;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvCheckRowsRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private boolean check;
    private long timestamp;
    private List<List<String>> model;
    private List<String> row;
    private List<Integer> listIndices;
    private NumberFormat decimalFormat = NumberFormat.getInstance();
    private boolean debug = false;
    private int stepSize = 1;

    public CsvCheckRowsRunnable(CSVEditor csvEditor, List<Integer> listIndices, boolean check, long timestamp) {
        this.csvEditor = csvEditor;
        this.listIndices = listIndices;
        this.check = check;
        this.timestamp = timestamp;
    }

    public CsvCheckRowsRunnable(CSVEditor csvEditor, List<Integer> listIndices, boolean check) {
        this(csvEditor, listIndices, check, System.currentTimeMillis());
    }

    public CsvCheckRowsRunnable(CSVEditor csvEditor, int[] arrayIndices, boolean check, long timestamp) {
        this.listIndices = new ArrayList<Integer>();
        int[] nArray = arrayIndices;
        int n = arrayIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.listIndices.add(i);
            ++n2;
        }
        this.csvEditor = csvEditor;
        this.check = check;
        this.timestamp = timestamp;
    }

    public CsvCheckRowsRunnable(CSVEditor csvEditor, int[] arrayIndices, boolean check) {
        this.listIndices = new ArrayList<Integer>();
        int[] nArray = arrayIndices;
        int n = arrayIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.listIndices.add(i);
            ++n2;
        }
        this.csvEditor = csvEditor;
        this.check = check;
        this.timestamp = System.currentTimeMillis();
    }

    public CsvCheckRowsRunnable(CSVEditor csvEditor, boolean check) {
        this.csvEditor = csvEditor;
        this.check = check;
        this.listIndices = null;
        this.timestamp = System.currentTimeMillis();
    }

    public CsvCheckRowsRunnable(CSVEditor csvEditor, boolean check, long timestamp) {
        this.csvEditor = csvEditor;
        this.check = check;
        this.listIndices = null;
        this.timestamp = timestamp;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.model = (List)this.csvEditor.getModel();
        this.debug = this.csvEditor.getDebug();
        if (this.model.size() > 10) {
            this.stepSize = this.model.size() / 10;
        }
        long timeStart = System.currentTimeMillis();
        if (this.listIndices == null) {
            this.checkAllRows(monitor);
            long timeEnd = System.currentTimeMillis();
            if (this.debug) {
                System.out.println("Checked " + this.decimalFormat.format(this.model.size()) + " rows time(ms): " + this.decimalFormat.format(timeEnd - timeStart));
            }
        } else {
            this.checkSelectedRows(monitor);
            long timeEnd = System.currentTimeMillis();
            if (this.debug) {
                System.out.println("Checked " + this.decimalFormat.format(this.listIndices.size()) + " rows time(ms): " + this.decimalFormat.format(timeEnd - timeStart));
            }
        }
        this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CsvCheckRowsRunnable.this.csvEditor.updateRows(CsvCheckRowsRunnable.this.csvEditor.getTable().getTopIndex(), 50);
                CsvCheckRowsRunnable.this.csvEditor.updateRows(CsvCheckRowsRunnable.this.csvEditor.getTable().getTopIndex(), -50);
            }
        });
    }

    private void checkAllRows(IProgressMonitor monitor) throws InterruptedException {
        try {
            int modelSize = this.model.size();
            monitor.beginTask("Check rows", modelSize);
            if (this.csvEditor.isAllSelected()) {
                this.csvEditor.setAllSelected(false);
            } else {
                this.csvEditor.setAllSelected(true);
            }
            int value = 0;
            if (this.csvEditor.isAllSelected()) {
                value = 1;
            }
            int i = 0;
            while (i < this.model.size()) {
                this.row = this.model.get(i);
                this.row.set(0, String.valueOf(value));
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                    monitor.subTask("Reading row " + this.decimalFormat.format(i) + " of " + this.decimalFormat.format(modelSize) + " total rows");
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void checkSelectedRows(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Check rows", this.model.size());
            int value = 0;
            if (this.check) {
                value = 1;
            }
            int i = 0;
            while (i < this.listIndices.size()) {
                final int fi = i;
                this.row = (ArrayList)this.model.get(this.listIndices.get(i));
                this.row.set(0, String.valueOf(value));
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvCheckRowsRunnable.this.csvEditor.getListActions().add(new CsvActionRowCheck(fi, CsvCheckRowsRunnable.this.check, CsvCheckRowsRunnable.this.timestamp));
                    }
                });
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                    monitor.subTask("Reading row " + this.decimalFormat.format(i) + " of " + this.decimalFormat.format(this.listIndices.size()) + " total rows");
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }
}

