/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowCheck;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvCheckRowsMultipleRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private String[] taskList;
    private boolean[] checkList;
    private long timestamp;
    private int stepSize = 1;
    private List<List<Integer>> listIndices;
    private List<List<String>> model;
    private List<String> row;

    public CsvCheckRowsMultipleRunnable(CSVEditor csvEditor, List<List<Integer>> listIndices, String[] taskNames, boolean[] checkList, long timestamp) {
        this.csvEditor = csvEditor;
        this.listIndices = listIndices;
        this.taskList = taskNames;
        this.checkList = checkList;
        this.timestamp = timestamp;
        this.model = (List)csvEditor.getModel();
    }

    public CsvCheckRowsMultipleRunnable(CSVEditor csvEditor, List<List<Integer>> listIndices, String[] taskNames, boolean check, long timestamp) {
        boolean[] arrayCheck = new boolean[listIndices.size()];
        int i = 0;
        while (i < arrayCheck.length) {
            arrayCheck[i] = check;
            ++i;
        }
        this.csvEditor = csvEditor;
        this.listIndices = listIndices;
        this.taskList = taskNames;
        this.checkList = arrayCheck;
        this.timestamp = timestamp;
        this.model = (List)csvEditor.getModel();
    }

    public CsvCheckRowsMultipleRunnable(CSVEditor csvEditor, List<List<Integer>> listIndices, String[] taskNames, boolean[] checkList) {
        this(csvEditor, listIndices, taskNames, checkList, System.currentTimeMillis());
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            long timeStart = System.currentTimeMillis();
            int totalWorkUnits = 0;
            for (List<Integer> listSingle : this.listIndices) {
                totalWorkUnits += listSingle.size();
            }
            if (totalWorkUnits > 100) {
                this.stepSize = totalWorkUnits / 100;
            }
            monitor.beginTask("Check rows", totalWorkUnits);
            int i = 0;
            while (i < this.listIndices.size()) {
                monitor.subTask(this.taskList[i]);
                this.checkSingle(this.listIndices.get(i), this.checkList[i], (IProgressMonitor)new SubProgressMonitor(monitor, this.listIndices.get(i).size()));
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
            long timeEnd = System.currentTimeMillis();
            if (this.csvEditor.getDebug()) {
                System.out.println("Checked " + new DecimalFormat("###,###").format(totalWorkUnits) + " rows in " + new DecimalFormat("###,###").format(timeEnd - timeStart) + "ms");
            }
            this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CsvCheckRowsMultipleRunnable.this.csvEditor.updateRows(CsvCheckRowsMultipleRunnable.this.csvEditor.getTable().getTopIndex(), 50);
                    CsvCheckRowsMultipleRunnable.this.csvEditor.updateRows(CsvCheckRowsMultipleRunnable.this.csvEditor.getTable().getTopIndex(), -50);
                }
            });
        }
        finally {
            monitor.done();
        }
    }

    private void checkSingle(List<Integer> listMatchingIndices, final boolean checkSingle, IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Check rows", this.model.size());
            int value = 0;
            if (checkSingle) {
                value = 1;
            }
            int i = 0;
            while (i < listMatchingIndices.size()) {
                final int fi = listMatchingIndices.get(i);
                this.row = (ArrayList)this.model.get(fi);
                this.row.set(0, String.valueOf(value));
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvCheckRowsMultipleRunnable.this.csvEditor.getListActions().add(new CsvActionRowCheck(fi, checkSingle, CsvCheckRowsMultipleRunnable.this.timestamp));
                    }
                });
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }
}

