/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csvUtils.CsvBufferedReader;
import com.biotechvana.csvUtils.CsvWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvAppendWorksheetMultifileRunnable
implements IRunnableWithProgress {
    private final String TITLE = "Append worksheets";
    private File fileMaster;
    private File[] filesRelated;
    private File fileOutput;
    private char separator = (char)59;
    private char quotes = (char)34;

    public CsvAppendWorksheetMultifileRunnable(File fileMaster, File[] filesRelated, File fileOutput, char separator, char quotes) {
        this.fileMaster = fileMaster;
        this.filesRelated = filesRelated;
        this.fileOutput = fileOutput;
        this.separator = separator;
        this.quotes = quotes;
    }

    public CsvAppendWorksheetMultifileRunnable(File fileMaster, File[] filesRelated, File fileOutput) {
        this.fileMaster = fileMaster;
        this.filesRelated = filesRelated;
        this.fileOutput = fileOutput;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Append worksheets", 1 + this.filesRelated.length);
        try {
            try {
                this.appendWorksheets(monitor);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void appendWorksheets(IProgressMonitor monitor) throws IOException, InterruptedException {
        List row;
        CsvWriter writer = new CsvWriter(this.fileOutput, this.separator, this.quotes);
        monitor.subTask("Reading master file: " + this.fileMaster.getName());
        CsvBufferedReader reader = new CsvBufferedReader(this.fileMaster, this.separator, this.quotes);
        while ((row = reader.readLine()) != null) {
            writer.write(row);
        }
        reader.close();
        monitor.worked(1);
        File[] fileArray = this.filesRelated;
        int n = this.filesRelated.length;
        int n2 = 0;
        while (n2 < n) {
            File fr = fileArray[n2];
            monitor.subTask("Reading append file: " + fr.getName());
            reader = new CsvBufferedReader(fr, this.separator, this.quotes);
            reader.readLine();
            while ((row = reader.readLine()) != null) {
                writer.write(row);
            }
            reader.close();
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ++n2;
        }
        writer.close();
    }
}

