/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.CsvEditorUtils2;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowColor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Shell;

public class CsvAnnotationColorsRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private List<List<String>> model;
    private Map<String, Color> mapColors;
    private Map<String, Integer> mapIndex;
    private Shell shell;
    private Color colorNoHit;
    private Color colorHit;
    private Color colorFunction;
    private Color colorMapped;
    private Color colorMappedPlus;
    private Color oldColor;
    private long timestamp = System.currentTimeMillis();
    private double evalueThreshold;
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private int stepSize = 1;

    public CsvAnnotationColorsRunnable(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.model = (List)csvEditor.getModel();
        this.shell = csvEditor.getSite().getShell();
        this.evalueThreshold = csvEditor.evalueThreshold;
        this.mapColors = csvEditor.getMapAnnotationColors();
        this.mapIndex = csvEditor.getMapAnnotationIndices();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long timeStart = System.currentTimeMillis();
        this.initAnnotationColors(monitor);
        long timeEnd = System.currentTimeMillis();
        if (this.csvEditor.getDebug()) {
            System.out.println("Annotation colors applied to " + this.decimalFormat.format(this.model.size()) + " rows in " + this.decimalFormat.format(timeEnd - timeStart) + "ms");
        }
    }

    public void initAnnotationColors(IProgressMonitor monitor) throws InterruptedException {
        try {
            int modelSize;
            DecimalFormat decimalFormat = new DecimalFormat("###,###");
            this.colorNoHit = this.mapColors.get(CSVEditor.Annotation.ANNOTATION_NOHIT.getKey());
            this.colorHit = this.mapColors.get(CSVEditor.Annotation.ANNOTATION_HIT.getKey());
            this.colorFunction = this.mapColors.get(CSVEditor.Annotation.ANNOTATION_FUNCTION.getKey());
            this.colorMapped = this.mapColors.get(CSVEditor.Annotation.ANNOTATION_MAPPED.getKey());
            this.colorMappedPlus = this.mapColors.get(CSVEditor.Annotation.ANNOTATION_MAPPED_PLUS.getKey());
            int indexEvalue = this.mapIndex.get(CSVEditor.Annotation.ANNOTATION_NOHIT.getKey());
            int indexFunction = -1;
            int indexMapped = -1;
            int indexMappedPlus = -1;
            if (this.mapIndex.containsKey(CSVEditor.Annotation.ANNOTATION_FUNCTION.getKey())) {
                indexFunction = this.mapIndex.get(CSVEditor.Annotation.ANNOTATION_FUNCTION.getKey());
            }
            if (this.mapIndex.containsKey(CSVEditor.Annotation.ANNOTATION_MAPPED.getKey())) {
                indexMapped = this.mapIndex.get(CSVEditor.Annotation.ANNOTATION_MAPPED.getKey());
            }
            if (this.mapIndex.containsKey(CSVEditor.Annotation.ANNOTATION_MAPPED_PLUS.getKey())) {
                indexMappedPlus = this.mapIndex.get(CSVEditor.Annotation.ANNOTATION_MAPPED_PLUS.getKey());
            }
            if ((modelSize = this.model.size()) > 100) {
                this.stepSize = modelSize / 100;
            }
            monitor.beginTask("Apply annotation colors", modelSize);
            monitor.subTask("Running...");
            int i = 0;
            while (i < this.model.size()) {
                List<String> row = this.model.get(i);
                String evalue = null;
                if (this.mapIndex.get(CSVEditor.Annotation.ANNOTATION_NOHIT.getKey()) != null) {
                    evalue = row.get(indexEvalue);
                }
                String function = null;
                if (indexFunction != -1) {
                    function = row.get(indexFunction);
                }
                String mapped = null;
                if (indexMapped != -1) {
                    mapped = row.get(indexMapped);
                }
                String mappedPlus = null;
                if (indexMappedPlus != -1) {
                    mappedPlus = row.get(indexMappedPlus);
                }
                final int fi = i;
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvAnnotationColorsRunnable.this.oldColor = CsvAnnotationColorsRunnable.this.csvEditor.getTable().getItem(fi).getBackground();
                    }
                });
                if (evalue == null || evalue.equals("--UD--") || evalue.isEmpty()) {
                    this.shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CsvAnnotationColorsRunnable.this.csvEditor.getTable().getItem(fi).setBackground(CsvAnnotationColorsRunnable.this.colorNoHit);
                            CsvAnnotationColorsRunnable.this.csvEditor.getListActions().add(new CsvActionRowColor(fi, CsvAnnotationColorsRunnable.this.oldColor, CsvAnnotationColorsRunnable.this.colorNoHit, CsvAnnotationColorsRunnable.this.timestamp));
                        }
                    });
                } else if (Double.parseDouble(CsvEditorUtils2.formatDoubleValue(evalue)) > this.evalueThreshold) {
                    this.shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CsvAnnotationColorsRunnable.this.csvEditor.getTable().getItem(fi).setBackground(CsvAnnotationColorsRunnable.this.colorNoHit);
                            CsvAnnotationColorsRunnable.this.csvEditor.getListActions().add(new CsvActionRowColor(fi, CsvAnnotationColorsRunnable.this.oldColor, CsvAnnotationColorsRunnable.this.colorNoHit, CsvAnnotationColorsRunnable.this.timestamp));
                        }
                    });
                } else if (function == null || function.isEmpty() || function.equals("--UD--")) {
                    this.shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CsvAnnotationColorsRunnable.this.csvEditor.getTable().getItem(fi).setBackground(CsvAnnotationColorsRunnable.this.colorHit);
                            CsvAnnotationColorsRunnable.this.csvEditor.getListActions().add(new CsvActionRowColor(fi, CsvAnnotationColorsRunnable.this.oldColor, CsvAnnotationColorsRunnable.this.colorHit, CsvAnnotationColorsRunnable.this.timestamp));
                        }
                    });
                } else if (mapped == null || mapped.isEmpty() || mapped.equals("--UD--")) {
                    this.shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CsvAnnotationColorsRunnable.this.csvEditor.getTable().getItem(fi).setBackground(CsvAnnotationColorsRunnable.this.colorFunction);
                            CsvAnnotationColorsRunnable.this.csvEditor.getListActions().add(new CsvActionRowColor(fi, CsvAnnotationColorsRunnable.this.oldColor, CsvAnnotationColorsRunnable.this.colorFunction, CsvAnnotationColorsRunnable.this.timestamp));
                        }
                    });
                } else if (mappedPlus == null || mappedPlus.isEmpty() || mappedPlus.equals("--UD--")) {
                    this.shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CsvAnnotationColorsRunnable.this.csvEditor.getTable().getItem(fi).setBackground(CsvAnnotationColorsRunnable.this.colorMapped);
                            CsvAnnotationColorsRunnable.this.csvEditor.getListActions().add(new CsvActionRowColor(fi, CsvAnnotationColorsRunnable.this.oldColor, CsvAnnotationColorsRunnable.this.colorMapped, CsvAnnotationColorsRunnable.this.timestamp));
                        }
                    });
                } else {
                    this.shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CsvAnnotationColorsRunnable.this.csvEditor.getTable().getItem(fi).setBackground(CsvAnnotationColorsRunnable.this.colorMappedPlus);
                            CsvAnnotationColorsRunnable.this.csvEditor.getListActions().add(new CsvActionRowColor(fi, CsvAnnotationColorsRunnable.this.oldColor, CsvAnnotationColorsRunnable.this.colorMappedPlus, CsvAnnotationColorsRunnable.this.timestamp));
                        }
                    });
                }
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                    monitor.subTask("Reading row " + decimalFormat.format(i + 1) + " of " + decimalFormat.format(modelSize) + " total rows.");
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }
}

