/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs;

import com.biotechvana.csveditor.model.GenbankDownloader;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class CsvEditorGenbankDownloadJob
extends Job {
    private int columnIndex;
    private String rettype;
    private String outputFolder;
    private String[] termsNotFound;
    private List<Integer> listSelectedRows;
    private List<List<String>> model;

    public CsvEditorGenbankDownloadJob(String name, List<List<String>> model, int columnIndex, List<Integer> listSelectedRows, String rettype, String outputFolder) {
        super(name);
        this.columnIndex = columnIndex;
        this.rettype = rettype;
        this.outputFolder = outputFolder;
        this.model = model;
        this.listSelectedRows = listSelectedRows;
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvEditorGenbankDownloadJob.this.refreshExplorer();
                        GenbankResumeDialog dialog = new GenbankResumeDialog(WorkspaceUtils.getShell());
                        dialog.open();
                        dialog.close();
                    }
                });
            }
        });
    }

    protected IStatus run(IProgressMonitor monitor) {
        GenbankDownloader gbDownloader = new GenbankDownloader();
        try {
            this.termsNotFound = gbDownloader.download(this.model, this.columnIndex, this.listSelectedRows, this.outputFolder, this.rettype, monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    private void refreshExplorer() {
        IViewPart viewPart = WorkspaceUtils.findView((String)FileExplorerBasic.ID);
        if (viewPart != null) {
            FileExplorerBasic fileExplorer = (FileExplorerBasic)viewPart;
            fileExplorer.getFileViewer().refresh((Object)new File(this.outputFolder).getParentFile());
        }
    }

    class GenbankResumeDialog
    extends Dialog {
        private Text textNotFound;

        protected GenbankResumeDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite compositeParent = (Composite)super.createDialogArea(parent);
            compositeParent.setLayout((Layout)new GridLayout());
            parent.getShell().setText("GenBank downloader");
            Composite composite = new Composite(compositeParent, 0);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            composite.setLayout((Layout)layout);
            if (CsvEditorGenbankDownloadJob.this.termsNotFound != null && CsvEditorGenbankDownloadJob.this.termsNotFound.length > 0) {
                Label label = new Label(composite, 0);
                label.setText("The following terms were not found:");
                FormData layoutData = new FormData();
                layoutData.top = new FormAttachment(0, 0);
                layoutData.left = new FormAttachment(0, 0);
                label.setLayoutData((Object)layoutData);
                this.textNotFound = new Text(composite, 2826);
                layoutData = new FormData();
                layoutData.top = new FormAttachment((Control)label, 10);
                layoutData.left = new FormAttachment((Control)label, 0, 16384);
                layoutData.height = 200;
                layoutData.right = new FormAttachment(100, 0);
                this.textNotFound.setLayoutData((Object)layoutData);
                StringBuilder builder = new StringBuilder();
                String[] stringArray = CsvEditorGenbankDownloadJob.this.termsNotFound;
                int n = CsvEditorGenbankDownloadJob.this.termsNotFound.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    builder.append(s + "\r\n");
                    ++n2;
                }
                this.textNotFound.setText(builder.toString());
            } else {
                Label label = new Label(composite, 0);
                label.setText("GenBank accessions downloaded successfully");
            }
            return compositeParent;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            Button closeButton = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
            closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GenbankResumeDialog.this.close();
                }
            });
        }
    }
}

