/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.goAnnotation;

import com.biotechvana.pipelineCommander.PipelineCommanderQueryUtils;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GOTerm
implements Comparable<GOTerm> {
    public static int MAX_DEPTH;
    public static final String multipleTermSeparator = ";";
    public static final String accessionRegexTemplate = "GO\\s*:\\s*(\\d+)\\s*";
    public static final String nameRegexTemplate = "\\s*([^;]+)\\s*";
    private static final Pattern accessionPattern;
    static String termNameRegex;
    private static Pattern termNamePattern;
    private int dbId;
    private String name;
    private GODomain termType;
    private String accession;
    private boolean obsolete;
    private int depth;
    private Set<GOTerm> parentsSet;
    private Set<GOTerm> childrenSet;
    private Set<GOTerm> ancestorsSet;
    private Set<GOTerm> descendantsSet;
    private int sequenceCount;
    private int cumulativeSequenceCount;
    private double nodeScore;
    private final String DB_ANNOTATION = PreferenceManager.getInstance().get("DB_PIPELINE", "");

    static {
        String maxDepthQuery = "SELECT MAX(distance) FROM `go_depth` WHERE 1";
        List maxDepthResultSetAsList = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)PreferenceManager.getInstance().get("ssh_user", ""), (String)PreferenceManager.getInstance().get("ssh_password", ""), (String)PreferenceManager.getInstance().get("DB_PIPELINE", ""), (String)maxDepthQuery);
        try {
            MAX_DEPTH = Integer.parseInt((String)((List)maxDepthResultSetAsList.get(1)).get(0));
        }
        catch (NumberFormatException exception) {
            MAX_DEPTH = 15;
        }
        accessionPattern = Pattern.compile(accessionRegexTemplate);
        termNameRegex = "([^;]+)\\s*";
        termNamePattern = Pattern.compile(termNameRegex);
    }

    @Override
    public int compareTo(GOTerm o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.accession);
        sb.append(" (" + this.depth + ")");
        if (this.obsolete) {
            sb.append(" [OBS]");
        }
        sb.append(":" + this.name);
        return sb.toString();
    }

    public GOTerm(int dbId, String name, GODomain termType, String accession, boolean obsolete, int depth, Set<GOTerm> parentsSet, Set<GOTerm> childrenSet, Set<GOTerm> ancestorsSet, Set<GOTerm> descendantsSet, int sequenceCount, int cumulativeSequenceCount, double nodeScore) {
        this.dbId = dbId;
        this.name = name;
        this.termType = termType;
        this.accession = accession;
        this.obsolete = obsolete;
        this.depth = depth;
        this.parentsSet = parentsSet;
        this.childrenSet = childrenSet;
        this.ancestorsSet = ancestorsSet;
        this.descendantsSet = descendantsSet;
        this.sequenceCount = sequenceCount;
        this.cumulativeSequenceCount = cumulativeSequenceCount;
        this.nodeScore = nodeScore;
    }

    public GOTerm(int dbId, String name, GODomain termType, String accession, boolean obsolete, int depth) {
        this.dbId = dbId;
        this.name = name;
        this.termType = termType;
        this.accession = accession;
        this.obsolete = obsolete;
        this.depth = depth;
        this.parentsSet = new HashSet<GOTerm>();
        this.childrenSet = new HashSet<GOTerm>();
        this.ancestorsSet = new HashSet<GOTerm>();
        this.descendantsSet = new HashSet<GOTerm>();
        this.sequenceCount = 0;
        this.cumulativeSequenceCount = 0;
        this.nodeScore = 0.0;
    }

    public GOTerm(int dbId, String name, GODomain termType, String accession, boolean obsolete) {
        this.dbId = dbId;
        this.name = name;
        this.termType = termType;
        this.accession = accession;
        this.obsolete = obsolete;
        this.parentsSet = new HashSet<GOTerm>();
        this.childrenSet = new HashSet<GOTerm>();
        this.ancestorsSet = new HashSet<GOTerm>();
        this.descendantsSet = new HashSet<GOTerm>();
        this.sequenceCount = 0;
        this.cumulativeSequenceCount = 0;
        this.nodeScore = 0.0;
    }

    public GOTerm(String nameOrAccessionString) {
        this.dbId = -1;
        this.childrenSet = new HashSet<GOTerm>();
        this.parentsSet = new HashSet<GOTerm>();
        this.ancestorsSet = new HashSet<GOTerm>();
        this.descendantsSet = new HashSet<GOTerm>();
        this.sequenceCount = 0;
        this.cumulativeSequenceCount = 0;
        this.nodeScore = 0.0;
        String accessionQuery = "SELECT t.id, t.name, t.term_type, t.acc, t.is_obsolete, d.distance FROM " + this.DB_ANNOTATION + ".`term` AS t LEFT JOIN " + this.DB_ANNOTATION + ".`go_depth` AS d ON t.acc=d.acc WHERE t.acc = ?";
        String nameQuery = "SELECT t.id, t.name, t.term_type, t.acc, t.is_obsolete, d.distance FROM " + this.DB_ANNOTATION + ".`term` AS t LEFT JOIN " + this.DB_ANNOTATION + ".`go_depth` AS d ON t.acc=d.acc WHERE t.name = ?";
        Matcher accessionMatcher = accessionPattern.matcher(nameOrAccessionString);
        Matcher termNameMatcher = termNamePattern.matcher(nameOrAccessionString);
        List resultSetAsList = null;
        if (accessionMatcher.matches()) {
            preparedQuery = PipelineCommanderQueryUtils.prepareQuery((String)accessionQuery, (String[])new String[]{nameOrAccessionString}, (String[])new String[]{"s"});
            resultSetAsList = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)PreferenceManager.getInstance().get("ssh_user", ""), (String)PreferenceManager.getInstance().get("ssh_password", ""), (String)PreferenceManager.getInstance().get("DB_PIPELINE", ""), (String)preparedQuery);
        } else if (termNameMatcher.matches()) {
            preparedQuery = PipelineCommanderQueryUtils.prepareQuery((String)nameQuery, (String[])new String[]{nameOrAccessionString}, (String[])new String[]{"s"});
            resultSetAsList = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)PreferenceManager.getInstance().get("DB_USER", ""), (String)PreferenceManager.getInstance().get("DB_PASS", ""), (String)PreferenceManager.getInstance().get("DB_PIPELINE", ""), (String)preparedQuery);
        }
        ArrayList<Integer> idsList = new ArrayList<Integer>(3);
        ArrayList<String> namesList = new ArrayList<String>(3);
        ArrayList<GODomain> typesList = new ArrayList<GODomain>(3);
        ArrayList<String> accessionsList = new ArrayList<String>(3);
        ArrayList<Boolean> obsoletesList = new ArrayList<Boolean>(3);
        ArrayList<Integer> depthsList = new ArrayList<Integer>(3);
        int idIndex = ((List)resultSetAsList.get(0)).indexOf("id");
        int nameIndex = ((List)resultSetAsList.get(0)).indexOf("name");
        int termTypeIndex = ((List)resultSetAsList.get(0)).indexOf("term_type");
        int accIndex = ((List)resultSetAsList.get(0)).indexOf("acc");
        int isObsoleteIndex = ((List)resultSetAsList.get(0)).indexOf("is_obsolete");
        int depthIndex = ((List)resultSetAsList.get(0)).indexOf("distance");
        for (List resultRow : resultSetAsList.subList(1, resultSetAsList.size())) {
            idsList.add(Integer.parseInt((String)resultRow.get(idIndex)));
            namesList.add((String)resultRow.get(nameIndex));
            typesList.add(GODomain.getInstance((String)resultRow.get(termTypeIndex)));
            accessionsList.add((String)resultRow.get(accIndex));
            obsoletesList.add(Integer.parseInt((String)resultRow.get(isObsoleteIndex)) == 1);
            depthsList.add(Integer.parseInt((String)resultRow.get(depthIndex)));
        }
        if (idsList.size() == 1) {
            this.dbId = (Integer)idsList.get(0);
            this.name = (String)namesList.get(0);
            this.termType = (GODomain)((Object)typesList.get(0));
            this.accession = (String)accessionsList.get(0);
            this.obsolete = (Boolean)obsoletesList.get(0);
            this.depth = (Integer)depthsList.get(0);
        } else if (idsList.size() > 1) {
            int nonObsoletesCount = 0;
            for (Boolean b : obsoletesList) {
                if (b.booleanValue()) continue;
                ++nonObsoletesCount;
            }
            if (nonObsoletesCount != 1) {
                throw new RuntimeException("More than one non-obsolete GO term '" + nameOrAccessionString + "'");
            }
            int i = 0;
            while (i < obsoletesList.size()) {
                if (!((Boolean)obsoletesList.get(i)).booleanValue()) {
                    this.dbId = (Integer)idsList.get(i);
                    this.name = (String)namesList.get(i);
                    this.termType = (GODomain)((Object)typesList.get(i));
                    this.accession = (String)accessionsList.get(i);
                    this.obsolete = (Boolean)obsoletesList.get(i);
                    this.depth = (Integer)depthsList.get(i);
                    break;
                }
                ++i;
            }
        } else {
            throw new RuntimeException("Term '" + nameOrAccessionString + "' not found");
        }
    }

    public GOTerm(int id) {
        this.dbId = -1;
        this.childrenSet = new HashSet<GOTerm>();
        this.parentsSet = new HashSet<GOTerm>();
        this.ancestorsSet = new HashSet<GOTerm>();
        this.descendantsSet = new HashSet<GOTerm>();
        this.sequenceCount = 0;
        this.cumulativeSequenceCount = 0;
        this.nodeScore = 0.0;
        String idQuery = "SELECT t.id, t.name, t.term_type, t.acc, t.is_obsolete, d.distance FROM " + this.DB_ANNOTATION + ".`term` AS t LEFT JOIN " + this.DB_ANNOTATION + ".`go_depth` AS d ON t.acc = d.acc WHERE t.id = ?";
        String preparedQuery = PipelineCommanderQueryUtils.prepareQuery((String)idQuery, (String[])new String[]{Integer.toString(id)}, (String[])new String[]{"i"});
        List resultSetAsList = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)PreferenceManager.getInstance().get("ssh_user", ""), (String)PreferenceManager.getInstance().get("ssh_password", ""), (String)PreferenceManager.getInstance().get("DB_PIPELINE", ""), (String)preparedQuery);
        int idIndex = ((List)resultSetAsList.get(0)).indexOf("id");
        int nameIndex = ((List)resultSetAsList.get(0)).indexOf("name");
        int termTypeIndex = ((List)resultSetAsList.get(0)).indexOf("term_type");
        int accIndex = ((List)resultSetAsList.get(0)).indexOf("acc");
        int isObsoleteIndex = ((List)resultSetAsList.get(0)).indexOf("is_obsolete");
        int depthIndex = ((List)resultSetAsList.get(0)).indexOf("distance");
        if (resultSetAsList.size() != 2) {
            throw new RuntimeException("Id " + id + " not found");
        }
        this.dbId = Integer.parseInt((String)((List)resultSetAsList.get(1)).get(idIndex));
        this.name = (String)((List)resultSetAsList.get(1)).get(nameIndex);
        this.termType = GODomain.getInstance((String)((List)resultSetAsList.get(1)).get(termTypeIndex));
        this.accession = (String)((List)resultSetAsList.get(1)).get(accIndex);
        this.obsolete = Integer.parseInt((String)((List)resultSetAsList.get(1)).get(isObsoleteIndex)) == 1;
        this.depth = Integer.parseInt((String)((List)resultSetAsList.get(1)).get(depthIndex));
    }

    public GODomain getTermType() {
        return this.termType;
    }

    public String getAccession() {
        return this.accession;
    }

    public String getName() {
        return this.name;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getDBId() {
        return this.dbId;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void addChild(GOTerm term) {
        this.childrenSet.add(term);
    }

    public void addParent(GOTerm term) {
        this.parentsSet.add(term);
    }

    public Set<GOTerm> getChildrenSet() {
        return this.childrenSet;
    }

    public Set<GOTerm> getParentsSet() {
        return this.parentsSet;
    }

    public void addDescendant(GOTerm term) {
        this.descendantsSet.add(term);
    }

    public void addAncestor(GOTerm term) {
        this.ancestorsSet.add(term);
    }

    public Set<GOTerm> getAncestorsSet() {
        return this.ancestorsSet;
    }

    public Set<GOTerm> getDescendantsSet() {
        return this.descendantsSet;
    }

    public void setNodeScore(double nodeScore) {
        this.nodeScore = nodeScore;
    }

    public void setSequenceCount(int sequenceCount) {
        this.sequenceCount = sequenceCount;
    }

    public void setCumulativeSequenceCount(int cumulativeSequenceCount) {
        this.cumulativeSequenceCount = cumulativeSequenceCount;
    }

    public int getCumulativeSequenceCount() {
        return this.cumulativeSequenceCount;
    }

    public double getNodeScore() {
        return this.nodeScore;
    }

    public int getSequenceCount() {
        return this.sequenceCount;
    }

    public static enum GODomain {
        C("Cellular component", "cellular_component", 'C', "\\s*\\[?C\\]?\\s*:?GO\\s*:\\s*(\\d+)\\s*", "\\s*\\[?C\\]?\\s*:\\s*([^;]+)\\s*"),
        M("Molecular function", "molecular_function", 'F', "\\s*\\[?F\\]?\\s*:?GO\\s*:\\s*(\\d+)\\s*", "\\s*\\[?F\\]?\\s*:\\s*([^;]+)\\s*"),
        P("Biological process", "biological_process", 'P', "\\s*\\[?P\\]?\\s*:?GO\\s*:\\s*(\\d+)\\s*", "\\s*\\[?P\\]?\\s*:\\s*([^;]+)\\s*");

        private String prettyName;
        private String name;
        private char code;
        private String accessionRegex;
        private String nameRegex;

        private GODomain(String prettyName, String name, char code, String accessionRegex, String nameRegex) {
            this.prettyName = prettyName;
            this.name = name;
            this.code = code;
            this.accessionRegex = accessionRegex;
            this.nameRegex = nameRegex;
        }

        public static GODomain getInstance(char code) {
            GODomain[] gODomainArray = GODomain.values();
            int n = gODomainArray.length;
            int n2 = 0;
            while (n2 < n) {
                GODomain value = gODomainArray[n2];
                if (value.code == code) {
                    return value;
                }
                ++n2;
            }
            return null;
        }

        public static GODomain getInstance(String name) {
            GODomain[] gODomainArray = GODomain.values();
            int n = gODomainArray.length;
            int n2 = 0;
            while (n2 < n) {
                GODomain value = gODomainArray[n2];
                if (value.name.equalsIgnoreCase(name) || value.prettyName.equalsIgnoreCase(name)) {
                    return value;
                }
                ++n2;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public char getCode() {
            return this.code;
        }

        public String getPrettyName() {
            return this.prettyName;
        }

        public String getAccessionRegex() {
            return this.accessionRegex;
        }

        public String getNameRegex() {
            return this.nameRegex;
        }
    }
}

