/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.goAnnotation;

import com.biotechvana.csveditor.goAnnotation.GOTerm;
import com.biotechvana.pipelineCommander.PipelineCommanderQueryUtils;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import java.lang.invoke.CallSite;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;

public class GOGraphModel {
    public static final int MONITOR_WORK_STEPS = 9;
    private static final NumberFormat numberFormat = NumberFormat.getInstance();
    private static final int maxRows = 10000;
    private List<List<String>> worksheetModel;
    private GOTerm.GODomain termType;
    private int goColumnIndex;
    private double alpha;
    private final String DB_ANNOTATION = PreferenceManager.getInstance().get("DB_PIPELINE", "");
    Set<GOTerm> csvTermsSet;
    Set<GOTerm> auxTermsSet;
    Map<Integer, Set<GOTerm>> csvRowToTermsMap;
    Map<Integer, GOTerm> allIdToTermMap;
    Map<String, GOTerm> allAccessionToTermMap;

    public GOGraphModel(List<List<String>> worksheetModel, int goColumnIndex, GOTerm.GODomain termType, double alpha) {
        this.worksheetModel = worksheetModel;
        this.termType = termType;
        this.goColumnIndex = goColumnIndex;
        this.alpha = alpha;
        this.csvTermsSet = new HashSet<GOTerm>();
        this.auxTermsSet = new HashSet<GOTerm>();
        this.csvRowToTermsMap = new HashMap<Integer, Set<GOTerm>>();
        this.allIdToTermMap = new HashMap<Integer, GOTerm>();
        this.allAccessionToTermMap = new HashMap<String, GOTerm>();
    }

    public void buildGraphModel(IProgressMonitor monitor) throws InterruptedException {
        HashMap<Integer, Set<String>> csvRowToAccessionSetMap = new HashMap<Integer, Set<String>>();
        HashMap<Integer, Set<String>> csvRowToNameSetMap = new HashMap<Integer, Set<String>>();
        String accessionPrefix = "GO:";
        Pattern termTypeAccessionPattern = Pattern.compile(this.termType.getAccessionRegex());
        Pattern termTypeNamePattern = Pattern.compile(this.termType.getNameRegex());
        int i = 0;
        for (List<String> line : this.worksheetModel) {
            HashSet<CallSite> thisRowAccessionSet = new HashSet<CallSite>();
            HashSet<String> thisRowNameSet = new HashSet<String>();
            String goField = line.get(this.goColumnIndex);
            Matcher termTypeAccessionMatcher = termTypeAccessionPattern.matcher(goField);
            Matcher termTypeNameMatcher = termTypeNamePattern.matcher(goField);
            while (termTypeAccessionMatcher.find()) {
                thisRowAccessionSet.add((CallSite)((Object)(accessionPrefix + termTypeAccessionMatcher.group(1))));
            }
            while (termTypeNameMatcher.find()) {
                thisRowNameSet.add(termTypeNameMatcher.group(1));
            }
            csvRowToAccessionSetMap.put(i, thisRowAccessionSet);
            csvRowToNameSetMap.put(i, thisRowNameSet);
            ++i;
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.worked(1);
        }
        this.retrieveTermsFromDB(this.termType, csvRowToAccessionSetMap, csvRowToNameSetMap, monitor);
        this.mapRowToTerms(csvRowToAccessionSetMap, csvRowToNameSetMap, monitor);
        this.auxTermsSet = new HashSet<GOTerm>(this.allIdToTermMap.size() - this.csvTermsSet.size());
        for (GOTerm term : this.allIdToTermMap.values()) {
            if (this.csvTermsSet.contains(term)) continue;
            this.auxTermsSet.add(term);
        }
        Iterator<Object> iterator = this.csvRowToTermsMap.keySet().iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            System.out.println("Row " + index + " -> " + String.valueOf(this.csvRowToTermsMap.get(index)));
        }
        System.out.println(this.csvTermsSet.size() + " terms of type " + this.termType.getPrettyName() + " in the CSV");
        System.out.println(this.allIdToTermMap.values().size() + " total terms");
        System.out.println(this.auxTermsSet.size() + " auxiliary terms");
        this.fillParents(this.auxTermsSet);
        this.doSequenceCount();
        for (GOTerm term : this.allIdToTermMap.values()) {
            term.setNodeScore(this.computeNodeScores(term, -1));
        }
    }

    private void retrieveTermsFromDB(GOTerm.GODomain termType, Map<Integer, Set<String>> indexToAccessionMap, Map<Integer, Set<String>> indexTonameMap, IProgressMonitor monitor) {
        String accession;
        monitor.subTask("Filtering repeated worksheet terms.");
        HashSet<String> uniqueAccessionSet = new HashSet<String>(indexToAccessionMap.values().size());
        for (Set<String> accessionSet : indexToAccessionMap.values()) {
            for (String string : accessionSet) {
                uniqueAccessionSet.add(string);
            }
        }
        HashSet<String> uniqueNameSet = new HashSet<String>(indexTonameMap.values().size());
        for (Set<String> set : indexTonameMap.values()) {
            for (Iterator name : set) {
                uniqueNameSet.add((String)((Object)name));
            }
        }
        monitor.worked(1);
        monitor.subTask("Determining graph size. This operation requires a remote database\nconnection and can take a few minutes.");
        StringBuilder stringBuilder = new StringBuilder("SELECT t.id, t.name, t.term_type, t.acc, t.is_obsolete, p.relationship_type_id, p.distance, p.relation_distance, p.term1_id AS p_id, t2.name AS p_name, t2.term_type AS p_term_type, t2.acc AS p_acc, t2.is_obsolete AS p_is_obsolete FROM " + this.DB_ANNOTATION + ".`term` AS t LEFT JOIN " + this.DB_ANNOTATION + ".`graph_path` AS p ON p.term2_id=t.id LEFT JOIN " + this.DB_ANNOTATION + ".`term` AS t2 ON t2.id=p.term1_id WHERE t2.term_type='" + termType.getName() + "' AND p.distance > 0 AND (");
        monitor.worked(1);
        if (uniqueAccessionSet.size() > 0) {
            stringBuilder.append("t.acc IN (");
            for (String string : uniqueAccessionSet) {
                stringBuilder.append("\"" + string + "\", ");
            }
            stringBuilder.delete(stringBuilder.length() - ", ".length(), stringBuilder.length());
            stringBuilder.append(")");
            if (uniqueNameSet.size() > 0) {
                stringBuilder.append(" OR ");
            }
        }
        if (uniqueNameSet.size() > 0) {
            stringBuilder.append("t.name IN (");
            for (String string : uniqueNameSet) {
                stringBuilder.append("\"" + string + "\", ");
            }
            stringBuilder.delete(stringBuilder.length() - ", ".length(), stringBuilder.length());
            stringBuilder.append(")");
        }
        stringBuilder.append(") ORDER BY t.id ASC");
        if (uniqueAccessionSet.size() + uniqueNameSet.size() == 0) {
            return;
        }
        monitor.worked(1);
        StringBuilder stringBuilder2 = new StringBuilder("SELECT COUNT(*) FROM (" + stringBuilder.toString() + ") AS `blah`");
        System.out.println(stringBuilder2.toString());
        List countResultSetAsList = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)PreferenceManager.getInstance().get("ssh_user", ""), (String)PreferenceManager.getInstance().get("ssh_password", ""), (String)PreferenceManager.getInstance().get("DB_PIPELINE", ""), (String)stringBuilder2.toString());
        int rowCount = Integer.parseInt((String)((List)countResultSetAsList.get(1)).get(0));
        monitor.worked(1);
        monitor.subTask("Building graph (" + numberFormat.format(uniqueAccessionSet.size() + uniqueNameSet.size()) + " terms in worksheet).");
        this.csvTermsSet = new HashSet<GOTerm>(uniqueAccessionSet.size() + uniqueNameSet.size());
        this.allIdToTermMap = new HashMap<Integer, GOTerm>(rowCount);
        this.allAccessionToTermMap = new HashMap<String, GOTerm>(rowCount);
        stringBuilder.append(" LIMIT ? , ?");
        List resultSetAsList = new ArrayList(rowCount + 1);
        int j = 0;
        while (j < rowCount) {
            String preparedQuery = PipelineCommanderQueryUtils.prepareQuery((String)stringBuilder.toString(), (String[])new String[]{Integer.toString(j), Integer.toString(10000)}, (String[])new String[]{"i", "i"});
            System.out.println(preparedQuery);
            List tempResultSetAsList = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)PreferenceManager.getInstance().get("DB_USER", ""), (String)PreferenceManager.getInstance().get("DB_PASS", ""), (String)PreferenceManager.getInstance().get("DB_PIPELINE", ""), (String)preparedQuery);
            resultSetAsList.addAll(tempResultSetAsList.subList(j == 0 ? 0 : 1, tempResultSetAsList.size()));
            j += 10000;
        }
        monitor.worked(1);
        int idIndex = ((List)resultSetAsList.get(0)).indexOf("id");
        int nameIndex = ((List)resultSetAsList.get(0)).indexOf("name");
        int accIndex = ((List)resultSetAsList.get(0)).indexOf("acc");
        int isObsoleteIndex = ((List)resultSetAsList.get(0)).indexOf("is_obsolete");
        int parentIdIndex = ((List)resultSetAsList.get(0)).indexOf("p_id");
        int parentNameIndex = ((List)resultSetAsList.get(0)).indexOf("p_name");
        int parentAccIndex = ((List)resultSetAsList.get(0)).indexOf("p_acc");
        int parentIsObsoleteIndex = ((List)resultSetAsList.get(0)).indexOf("p_is_obsolete");
        int distanceIndex = ((List)resultSetAsList.get(0)).indexOf("distance");
        for (List resultRow : resultSetAsList.subList(1, resultSetAsList.size())) {
            int dbId = Integer.parseInt((String)resultRow.get(idIndex));
            String name = (String)resultRow.get(nameIndex);
            accession = (String)resultRow.get(accIndex);
            boolean isObsolete = Integer.parseInt((String)resultRow.get(isObsoleteIndex)) == 1;
            int parentDBId = Integer.parseInt((String)resultRow.get(parentIdIndex));
            String parentName = (String)resultRow.get(parentNameIndex);
            String parentAccession = (String)resultRow.get(parentAccIndex);
            boolean parentIsObsolete = Integer.parseInt((String)resultRow.get(parentIsObsoleteIndex)) == 1;
            int distance = Integer.parseInt((String)resultRow.get(distanceIndex));
            GOTerm term = this.allIdToTermMap.get(dbId);
            if (term == null) {
                term = new GOTerm(dbId, name, termType, accession, isObsolete);
                this.allIdToTermMap.put(dbId, term);
                this.allAccessionToTermMap.put(accession, term);
            }
            this.csvTermsSet.add(term);
            GOTerm parentTerm = this.allIdToTermMap.get(parentDBId);
            if (parentTerm == null) {
                parentTerm = new GOTerm(parentDBId, parentName, termType, parentAccession, parentIsObsolete);
                this.allIdToTermMap.put(parentDBId, parentTerm);
                this.allAccessionToTermMap.put(parentAccession, parentTerm);
            }
            if (distance > 0) {
                term.addAncestor(parentTerm);
                parentTerm.addDescendant(term);
            }
            if (distance != 1) continue;
            term.addParent(parentTerm);
            parentTerm.addChild(term);
        }
        monitor.worked(1);
        StringBuilder depthQuerySB = new StringBuilder("SELECT d.acc, d.distance FROM " + this.DB_ANNOTATION + ".`go_depth` AS d WHERE d.acc IN (");
        for (String accession3 : this.allAccessionToTermMap.keySet()) {
            depthQuerySB.append("\"" + accession3 + "\", ");
        }
        depthQuerySB.delete(depthQuerySB.length() - ", ".length(), depthQuerySB.length());
        depthQuerySB.append(")");
        monitor.worked(1);
        resultSetAsList = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)PreferenceManager.getInstance().get("DB_USER", ""), (String)PreferenceManager.getInstance().get("DB_PASS", ""), (String)PreferenceManager.getInstance().get("DB_PIPELINE", ""), (String)depthQuerySB.toString());
        monitor.worked(1);
        accIndex = ((List)resultSetAsList.get(0)).indexOf("acc");
        int depthIndex = ((List)resultSetAsList.get(0)).indexOf("distance");
        for (List resultRow : resultSetAsList.subList(1, resultSetAsList.size())) {
            accession = (String)resultRow.get(accIndex);
            int depth = Integer.parseInt((String)resultRow.get(depthIndex));
            this.allAccessionToTermMap.get(accession).setDepth(depth);
        }
        monitor.worked(1);
    }

    private void mapRowToTerms(Map<Integer, Set<String>> indexToAccessionSetMap, Map<Integer, Set<String>> indexToNameSetMap, IProgressMonitor monitor) throws InterruptedException {
        this.csvRowToTermsMap = new HashMap<Integer, Set<GOTerm>>(indexToAccessionSetMap.size());
        for (Integer index : indexToAccessionSetMap.keySet()) {
            HashSet<GOTerm> thisIndexTermSet = new HashSet<GOTerm>(indexToAccessionSetMap.get(index).size() + indexToNameSetMap.get(index).size());
            for (String accession : indexToAccessionSetMap.get(index)) {
                for (GOTerm term : this.csvTermsSet) {
                    if (!term.getAccession().equalsIgnoreCase(accession)) continue;
                    thisIndexTermSet.add(term);
                }
            }
            for (String name : indexToNameSetMap.get(index)) {
                for (GOTerm term : this.csvTermsSet) {
                    if (!term.getName().equalsIgnoreCase(name)) continue;
                    thisIndexTermSet.add(term);
                }
            }
            this.csvRowToTermsMap.put(index, thisIndexTermSet);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.worked(1);
        }
    }

    private void fillParents(Set<GOTerm> termsSet) {
        StringBuilder parentsQuerySB = new StringBuilder("SELECT term1_id, term2_id, relationship_type_id, distance, relation_distance FROM " + this.DB_ANNOTATION + ".`graph_path` AS p LEFT JOIN " + this.DB_ANNOTATION + ".`term` AS t ON t.id=p.term1_id WHERE term_type='" + this.termType.getName() + "' AND term2_id IN (");
        for (GOTerm term : termsSet) {
            parentsQuerySB.append(term.getDBId() + ", ");
        }
        parentsQuerySB.delete(parentsQuerySB.length() - ", ".length(), parentsQuerySB.length());
        parentsQuerySB.append(") ORDER BY term1_id ASC");
        List resultSetAsList = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)PreferenceManager.getInstance().get("ssh_user", ""), (String)PreferenceManager.getInstance().get("ssh_password", ""), (String)PreferenceManager.getInstance().get("DB_PIPELINE", ""), (String)parentsQuerySB.toString());
        int term1IdIndex = ((List)resultSetAsList.get(0)).indexOf("term1_id");
        int term2IdIndex = ((List)resultSetAsList.get(0)).indexOf("term2_id");
        int distanceIndex = ((List)resultSetAsList.get(0)).indexOf("distance");
        for (List resultRow : resultSetAsList.subList(1, resultSetAsList.size())) {
            int term1Id = Integer.parseInt((String)resultRow.get(term1IdIndex));
            int term2Id = Integer.parseInt((String)resultRow.get(term2IdIndex));
            int distance = Integer.parseInt((String)resultRow.get(distanceIndex));
            if (this.allIdToTermMap.get(term1Id) != null && this.allIdToTermMap.get(term2Id) != null) {
                if (distance > 0) {
                    this.allIdToTermMap.get(term2Id).addAncestor(this.allIdToTermMap.get(term1Id));
                    this.allIdToTermMap.get(term1Id).addDescendant(this.allIdToTermMap.get(term2Id));
                }
                if (distance != 1) continue;
                this.allIdToTermMap.get(term2Id).addParent(this.allIdToTermMap.get(term1Id));
                this.allIdToTermMap.get(term1Id).addChild(this.allIdToTermMap.get(term2Id));
                continue;
            }
            System.err.println("No edge from " + term2Id + " to " + term1Id + "!");
        }
    }

    private double computeNodeScores(GOTerm term, int distance) {
        ++distance;
        double nodeScore = 0.0;
        for (GOTerm childTerm : term.getChildrenSet()) {
            nodeScore += this.computeNodeScores(childTerm, distance);
        }
        return nodeScore += (double)term.getSequenceCount() * Math.pow(this.alpha, distance);
    }

    private void doSequenceCount() {
        for (int row : this.csvRowToTermsMap.keySet()) {
            for (GOTerm term : this.csvRowToTermsMap.get(row)) {
                term.setSequenceCount(term.getSequenceCount() + 1);
                term.setCumulativeSequenceCount(term.getCumulativeSequenceCount() + 1);
                for (GOTerm ancestorTerm : term.getAncestorsSet()) {
                    ancestorTerm.setCumulativeSequenceCount(ancestorTerm.getCumulativeSequenceCount() + 1);
                    if (!ancestorTerm.getName().equalsIgnoreCase("cellular_component")) continue;
                    System.out.println("added one FTW!");
                }
            }
        }
    }

    public Collection<GOTerm> getAllTerms() {
        return this.allIdToTermMap.values();
    }

    public Collection<GOTerm> getCsvTerms() {
        return this.csvTermsSet;
    }

    public Collection<GOTerm> getAuxiliaryTerms() {
        return this.auxTermsSet;
    }
}

