/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.editors;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class CSVEditorInput
implements IEditorInput {
    private File inputFile;
    private File multiHitFile;
    private char fieldSeparator;
    private char fieldDelimiter;
    private boolean headersOn;
    public static final char DEFAULT_FIELD_SEPARATOR = ';';
    public static final char DEFAULT_FIELD_DELIMITER = '\"';
    public static final int DEFAULT_ROW_COUNT = 100;
    private boolean temporary = true;
    private boolean multiHit = true;
    private Formats fileFormat = Formats.CSV;
    public static final String[] DEFAULT_FIELDS = new String[]{"Sequence", "Subject mapping", "Accession", "Species", "Score", "e-value", "Query-from", "Query-to", "Subject-from", "Subject-to", "Query frame", "Subject frame", "Identities", "Positives", "Query length", "Hit length", "Align length", "Similarity", "Hsp/Query", "Hsp/Hit", "Comments"};
    private static final boolean DEBUG = true;

    public CSVEditorInput(File inputFile, char fieldSeparator, char fieldDelimiter, boolean headersOn, boolean temporary) {
        this.inputFile = inputFile;
        this.fieldSeparator = fieldSeparator;
        this.fieldDelimiter = fieldDelimiter;
        this.headersOn = headersOn;
        this.temporary = temporary;
        if (fieldSeparator == 'T' || fieldSeparator == 't') {
            this.fieldSeparator = (char)9;
        }
        if (FilenameUtils.getExtension((String)inputFile.getName()).equalsIgnoreCase("gff")) {
            this.fileFormat = Formats.GFF;
            this.headersOn = true;
        }
    }

    public CSVEditorInput(String inputFile, char fieldSeparator, char fieldDelimiter, boolean headersOn, boolean temporary) {
        File newFile = new File(inputFile);
        if (!newFile.exists()) {
            try {
                this.createTemplate(newFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.inputFile = newFile;
        this.fieldSeparator = fieldSeparator;
        this.fieldDelimiter = fieldDelimiter;
        this.headersOn = headersOn;
        this.temporary = temporary;
        if (fieldSeparator == 'T' || fieldSeparator == 't') {
            this.fieldSeparator = (char)9;
        }
        if (FilenameUtils.getExtension((String)inputFile).equalsIgnoreCase("gff")) {
            this.fileFormat = Formats.GFF;
            this.headersOn = true;
        }
    }

    public void createTemplate(File template) throws IOException {
        boolean res = template.createNewFile();
        if (!res) {
            System.err.println("Error creating blank template: io");
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(template, false));){
            String[] stringArray = DEFAULT_FIELDS;
            int n = DEFAULT_FIELDS.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                bw.append("\"" + field + "\";");
                ++n2;
            }
            bw.newLine();
            int i = 0;
            while (i < 100) {
                int j = 0;
                while (j < DEFAULT_FIELDS.length) {
                    bw.append("\"\";");
                    ++j;
                }
                bw.newLine();
                ++i;
            }
        }
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.inputFile.getAbsolutePath();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.inputFile.getAbsolutePath();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof File) {
            return this.inputFile.getAbsolutePath().equals(((File)obj).getAbsolutePath());
        }
        return false;
    }

    public int hashCode() {
        return this.inputFile.getAbsoluteFile().hashCode();
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public boolean isHeadersOn() {
        return this.headersOn;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean isMultiHit() {
        return this.multiHit;
    }

    public void setMultiHit(boolean multiHit) {
        this.multiHit = multiHit;
    }

    public File getMultiHitFile() {
        return this.multiHitFile;
    }

    public void setMultiHitFile(File multiHitFile) {
        if (multiHitFile != null) {
            this.setMultiHit(true);
        }
        this.multiHitFile = multiHitFile;
    }

    public Formats getFileFormat() {
        return this.fileFormat;
    }

    public static enum Formats {
        CSV,
        GFF;

    }
}

