/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.editors;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.csvUtils.CSVUtils2;
import com.biotechvana.csveditor.actions.csvEditor.CsvAddColumnAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvAddRowsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvCheckSelectedRowsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvCopyCheckedRowsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvCutCheckedRowsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvDeleteCheckedRowsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvDeleteColumnAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvFitToContentAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvJoinColumnsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvPasteCheckedRowsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvRenameColumnsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSelectAllColumnsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSelectMultiHitAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSequenceDetailAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvShowHideColumnsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSplitColumnAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvUncheckSelectedRowsAction;
import com.biotechvana.csveditor.dialogs.csvEditor.CsvSelectIsoformMultiDialog;
import com.biotechvana.csveditor.dialogs.csvEditor.CsvSelectMultiHitDialog;
import com.biotechvana.csveditor.dialogs.csvEditor.CsvSelectTermDialog;
import com.biotechvana.csveditor.editors.CSVEditorInput;
import com.biotechvana.csveditor.editors.CSVEditorToolbar;
import com.biotechvana.csveditor.jobs.csvEditor.CSVEditorCreateNewColumnRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CSVEditorPostSaveRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CSVEditorSaveCSVDocumentRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CSVEditorSaveDocumentRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CSVEditorSaveGFFDocumentRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvAnnotationColorsRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvCheckRowsRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvColumnSelectionListener;
import com.biotechvana.csveditor.jobs.csvEditor.CsvDeleteRowsRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvExportCategoriesRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvFillColumnRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvGetCheckedRowsIndicesRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvJoinColumnsRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvReplaceAllRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvResetAnnotationColorsRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvResetModelIndicesRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvRowIndicesByColorRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvSearchTermRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvSelectByTermRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvSelectNotEmptyCellRowsRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvSortRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoColumnAddRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoColumnCheckRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoColumnDeleteRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoColumnEditRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoColumnHideRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoColumnJoinRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoColumnSortRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoColumnSplitRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoRowAddRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoRowCheckRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoRowColorRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoRowDeleteRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvUndoRowEditRunnable;
import com.biotechvana.csveditor.model.CsvEditor.AssociatedFastaSequence;
import com.biotechvana.csveditor.model.CsvEditor.CSVContentProvider;
import com.biotechvana.csveditor.model.CsvEditor.CSVLabelProvider;
import com.biotechvana.csveditor.model.CsvEditor.CsvEditorUtils2;
import com.biotechvana.csveditor.model.CsvEditor.CsvModifiedRecord;
import com.biotechvana.csveditor.model.CsvEditor.ScoreFilteringModel;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnDelete;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnSort;
import com.biotechvana.csveditor.model.CsvParser;
import com.biotechvana.csveditor.model.ParseAssemblyOut;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import com.biotechvana.utils.PreferenceManager;
import com.biotechvana.utils.SequenceFileInfo;
import com.biotechvana.utils.StringUtils;
import com.biotechvana.utils.TermMatcher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.xml.sax.SAXException;

public class CSVEditor
extends EditorPart {
    public static final String ID = "com.biotechvana.csveditor.editors.CSVEditor";
    public static final char FIELD_SEPARATOR = ';';
    public static final char FIELD_DELIMITER = '\"';
    public static final char NULL_DELIMITER = 'N';
    public static final char ESCAPE_CHAR = '\\';
    public static final int COLUMN_PADDING = 2;
    public static final int BUFFER_SIZE = 524288;
    public static final String[] DATA_TYPES = new String[]{"Text", "Numeric"};
    public static final char[] SEPARATOR_CHARS = new char[]{';', ':', ',', '|'};
    public static final String NULLSTRING = "--UD--";
    public static final String ISOFORM_FILE_COMMENT = "isoformFile";
    public static final String ISOFORM_COLUMN_COMMENT = "isoformColumns";
    public static final String ISOFORM_OVERLAPPING_COMMENT = "isoformFilterOverlapping";
    public static final String ISOFORM_HSP_QUERY_COLUMN_COMMENT = "isoformHspQueryColumn";
    public static final String ISOFORM_HSP_HIT_COLUMN_COMMENT = "isoformHspHitColumn";
    public static final String ISOFORM_SIMILARITY_COLUMN_COMMENT = "isoformSimilarityColumn";
    public static final String ISOFORM_EVALUE_COLUMN_COMMENT = "isoformEvalueColumn";
    public static final String ISOFORM_DEPTH_COLUMN_COMMENT = "isoformDepthColumn";
    public static final String WORKSHEET_EXTENSION = ".csv";
    public static final String MULTIHIT_FILE_COMMENT = "multihit";
    public static int COLUMN_TYPE_ALPHA = 0;
    public static int COLUMN_TYPE_NUMERIC = 1;
    public static int COLUMN_TYPE_ALPHANUMERIC = 2;
    private static Object[] copyRows;
    public static final Image CHECK_ENABLED;
    public static final Image CHECK_DISABLED;
    public static final String DELETED_COLUMN_PREFIX = "!@_";
    private CSVEditorInput editorInput;
    private Table table;
    private TableViewer tableViewer;
    private File csvFile;
    private File isoformFile;
    public double evalueThreshold;
    private boolean headersOn;
    private boolean modified = false;
    private boolean allSelected = false;
    private boolean showAnnotationColors = false;
    private boolean debug = true;
    private boolean isoformFilterOverlapping = false;
    private String[] headers;
    private SequenceFileInfo associatedSequenceFileInfo = null;
    private String separator = "|";
    private int columnCount = 0;
    private File associationFile = null;
    private int[] associationColumnIndices;
    private String associationSeparator = "";
    public static final int ASSOCIATION_REFERENCE_TYPE_CSV = 0;
    public static final int ASSOCIATION_REFERENCE_TYPE_FASTA = 1;
    private int associationReferenceType = 0;
    private int[] exportColumnIndices;
    private int[] hiddenColumns;
    private int[] columnOrder;
    private int lastTopIndex = 0;
    private int isoformHspQueryColumn = -1;
    private int isoformHspHitColumn = -1;
    private int isoformSimilarityColumn = -1;
    private int isoformEValueColumn = -1;
    private int isoformDepthColumn = -1;
    private Color colorRowSelected;
    private Color colorNotAssociated;
    private CsvEditorUtils2 editorUtils2;
    private CsvParser csvParser;
    private CSVUtils2 csvUtils2;
    private List<List<String>> model;
    private List<List<String>> modelMultihit;
    private List<List<String>> modelIsoform;
    private List<TableViewerColumn> listTableViewerColumns = new ArrayList<TableViewerColumn>();
    private List<CsvModifiedRecord> listModifiedRecords = new ArrayList<CsvModifiedRecord>();
    private List<Integer> selectedIndices = new ArrayList<Integer>();
    private List<Integer> isoformColumns = new ArrayList<Integer>();
    private List<AssociatedFastaSequence> listAssociated = null;
    private List<CsvAction> listActions = new ArrayList<CsvAction>();
    private List<CsvColumnSelectionListener> listColumnListeners = new ArrayList<CsvColumnSelectionListener>();
    private Map<String, Color> mapAnnotationColors = new HashMap<String, Color>();
    private Map<String, Integer> mapAnnotationIndices = new HashMap<String, Integer>();
    private CsvPasteCheckedRowsAction csvPasteCheckRows = new CsvPasteCheckedRowsAction(this);

    static {
        CHECK_ENABLED = SharedImages.CHECKENABLED;
        CHECK_DISABLED = SharedImages.CHECKDISABLED;
    }

    public void createPartControl(Composite parent) {
        long timeStart = System.currentTimeMillis();
        if (CSVEditor.getCopyRows() == null) {
            this.csvPasteCheckRows.setEnabled(false);
        }
        this.editorInput = (CSVEditorInput)this.getEditorInput();
        if (this.editorInput.getFileFormat() == CSVEditorInput.Formats.GFF) {
            this.csvUtils2 = CSVUtils2.createNewUtils((File)this.csvFile, (boolean)false, (boolean)true);
        } else {
            this.csvUtils2 = CSVUtils2.createNewUtils((File)this.csvFile, (boolean)true, (boolean)false);
            this.initCsvUtils();
        }
        if (FilenameUtils.getExtension((String)this.csvFile.getName()).equalsIgnoreCase("csv")) {
            if (this.editorInput.isMultiHit()) {
                this.csvParser = new CsvParser(this.editorInput.getMultiHitFile());
                this.csvParser.parse(this.editorInput.getFieldSeparator(), this.editorInput.getFieldDelimiter(), 0);
            } else {
                this.csvParser = new CsvParser(this.csvFile);
            }
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData layoutData = new GridData();
        composite.setLayout((Layout)layout);
        this.colorNotAssociated = Display.getDefault().getSystemColor(7);
        this.colorRowSelected = Display.getDefault().getSystemColor(15);
        ToolBar toolBar = new ToolBar(composite, 0x800040);
        CSVEditorToolbar csvEditorToolbar = new CSVEditorToolbar();
        csvEditorToolbar.createCsvEditorToolbar(toolBar, this);
        layoutData = new GridData();
        toolBar.setLayoutData((Object)layoutData);
        this.table = new Table(composite, 68354);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        layoutData = new GridData(1808);
        this.table.setLayoutData((Object)layoutData);
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CSVEditor.this.initDocument(monitor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Open worksheet file", (String)e1.getMessage());
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        this.addPartListener();
        this.createContextMenu();
        this.loadDefaultFont();
        long timeEnd = System.currentTimeMillis();
        if (this.debug) {
            System.out.println("Table created in " + new DecimalFormat("###,###").format(timeEnd - timeStart) + "ms");
        }
        this.columnOrder = this.getTable().getColumnOrder();
    }

    private void initCsvUtils() {
        this.csvUtils2.setSeparator(this.editorInput.getFieldSeparator());
        this.csvUtils2.setDelimiter(this.editorInput.getFieldDelimiter());
    }

    public static void createEmptyDocument(File outputFile) throws IOException {
        String[] colnamnes = new String[]{"Database", "Sequence", "Subject mapping", "GI", "Accession", "Species", "Score", "e-value", "Query-from", "Query-to", "Subject-from", "Subject-to", "Query frame", "Subject frame", "Identities", "Positives", "Query length", "Hit length", "Align length", "Similarity", "Hsp/Query", "Hsp/Hit", "GO#", "GO", "Evidence codes", "Enzyme codes", "InterProScan", "Comments"};
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            writer.append(StringUtils.join((String[])colnamnes, (String)";"));
            writer.append("\n");
            ArrayList<String> listEmptyRow = new ArrayList<String>();
            int i = 0;
            while (i < colnamnes.length) {
                listEmptyRow.add("\"\"");
                ++i;
            }
            String stringEmptyRow = StringUtils.join(listEmptyRow, (String)";");
            int i2 = 0;
            while (i2 < 1000) {
                writer.append(stringEmptyRow);
                writer.append("\n");
                ++i2;
            }
        }
    }

    private void initDocument(IProgressMonitor monitor) throws IOException, InterruptedException, InvocationTargetException, CSVUtils2.LineCountNotDoneException, CSVUtils2.ColumnCountNotDoneException, CSVUtils2.SeparatorNotParsedException, CSVUtils2.DelimiterNotParsedException, CSVUtils2.CannotOpenFileException, CSVUtils2.HeadersNotParsedException, CSVUtils2.ModelNotParsedException, CSVUtils2.CommentsNotParsedException {
        monitor.beginTask("Load worksheet", 6);
        monitor.subTask("Finding field delimiter");
        monitor.worked(1);
        if (this.editorInput.getFieldSeparator() == ' ' || this.editorInput.getFieldSeparator() == 'S') {
            ParseAssemblyOut pao = new ParseAssemblyOut(this.csvFile);
            pao.parse(true, null);
            this.columnCount = pao.getColumnCount();
            this.headers = pao.getHeaders();
            this.model = pao.getModel();
        } else {
            String inputExtension = FilenameUtils.getExtension((String)this.editorInput.getInputFile().getName());
            this.csvUtils2.parse(this.editorInput.getFieldSeparator(), this.editorInput.getFieldDelimiter());
            this.editorUtils2 = new CsvEditorUtils2(this);
            this.columnCount = this.csvUtils2.getColumnCount();
            this.headers = this.csvUtils2.getHeaders().toArray(new String[this.csvUtils2.getHeaders().size()]);
            if (this.debug) {
                System.out.println(Arrays.toString(this.headers));
            }
            monitor.subTask("Creating table columns");
            this.createColumns(new String[]{"Select", "#"}, 0, false, false);
            this.createColumns(this.headers, this.table.getColumnCount(), false, false);
            monitor.worked(1);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new CSVLabelProvider());
            this.tableViewer.setContentProvider((IContentProvider)new CSVContentProvider());
            monitor.subTask("Parsing data rows");
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CSVEditor.this.model = CSVEditor.this.csvUtils2.getModel(true, true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (CSVUtils2.ModelNotParsedException e) {
                        e.printStackTrace();
                    }
                }
            });
            if (this.headers.length != this.csvUtils2.getHeaders().size()) {
                List extraHearderList = this.csvUtils2.getHeaders().subList(this.headers.length, this.csvUtils2.getHeaders().size());
                String[] extraHeaders = extraHearderList.toArray(new String[extraHearderList.size()]);
                this.createColumns(extraHeaders, this.getColumnCount(), true, true);
                this.headers = this.csvUtils2.getHeaders().toArray(new String[this.csvUtils2.getHeaders().size()]);
            }
            this.parseIsoformComments();
        }
        monitor.worked(1);
        if (this.model != null) {
            this.tableViewer.setInput(this.model);
        }
        this.addListeners();
        monitor.subTask("Finished. Please, wait while refreshing table.");
        monitor.done();
    }

    private void parseIsoformComments() {
        Map<String, String> mapComments = this.getCommentsAsMap(false);
        if (mapComments != null) {
            String value;
            if (mapComments.containsKey(ISOFORM_FILE_COMMENT) && (value = mapComments.get(ISOFORM_FILE_COMMENT)) != null && value.length() > 0) {
                this.setIsoformFile(new File(value));
            }
            if (mapComments.containsKey(ISOFORM_COLUMN_COMMENT) && (value = mapComments.get(ISOFORM_COLUMN_COMMENT)) != null && value.length() > 0) {
                String[] tokens;
                ArrayList<Integer> listIndices = new ArrayList<Integer>();
                if (value.endsWith(",")) {
                    value.substring(0, value.length() - 1);
                }
                String[] stringArray = tokens = value.split(",");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String c = stringArray[n2];
                    if (c != null && c.length() > 0) {
                        try {
                            listIndices.add(Integer.parseInt(c.trim()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                this.setIsoformColumns(listIndices);
            }
            if (mapComments.containsKey(ISOFORM_OVERLAPPING_COMMENT) && (value = mapComments.get(ISOFORM_OVERLAPPING_COMMENT)) != null && value.length() > 0) {
                try {
                    this.setIsoformFilterOverlapping(Boolean.parseBoolean(value));
                }
                catch (Exception ex) {
                    this.setIsoformFilterOverlapping(false);
                }
            }
            if (mapComments.containsKey(ISOFORM_HSP_QUERY_COLUMN_COMMENT) && (value = mapComments.get(ISOFORM_HSP_QUERY_COLUMN_COMMENT)) != null && value.length() > 0) {
                try {
                    this.setIsoformHspQueryColumn(Integer.parseInt(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (mapComments.containsKey(ISOFORM_HSP_HIT_COLUMN_COMMENT) && (value = mapComments.get(ISOFORM_HSP_HIT_COLUMN_COMMENT)) != null && value.length() > 0) {
                try {
                    this.setIsoformHspHitColumn(Integer.parseInt(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (mapComments.containsKey(ISOFORM_SIMILARITY_COLUMN_COMMENT) && (value = mapComments.get(ISOFORM_SIMILARITY_COLUMN_COMMENT)) != null && value.length() > 0) {
                try {
                    this.setIsoformSimilarityColumn(Integer.parseInt(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (mapComments.containsKey(ISOFORM_EVALUE_COLUMN_COMMENT) && (value = mapComments.get(ISOFORM_EVALUE_COLUMN_COMMENT)) != null && value.length() > 0) {
                try {
                    this.setIsoformEValueColumn(Integer.parseInt(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (mapComments.containsKey(ISOFORM_DEPTH_COLUMN_COMMENT) && (value = mapComments.get(ISOFORM_DEPTH_COLUMN_COMMENT)) != null && value.length() > 0) {
                try {
                    this.setIsoformDepthColumn(Integer.parseInt(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.getIsoformFile() != null) {
                try {
                    new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            CSVUtils2 utilsIsoform = CSVUtils2.createNewUtils((File)CSVEditor.this.isoformFile, (boolean)true);
                            try {
                                utilsIsoform.parse();
                                CSVEditor.this.modelIsoform = utilsIsoform.getModel(false, false);
                                if (CSVEditor.this.debug) {
                                    System.out.println("Isoform file. Found " + CSVEditor.this.modelIsoform.size() + " records");
                                }
                            }
                            catch (Exception e) {
                                MessageDialog.openError((Shell)CSVEditor.this.getSite().getShell(), (String)"Parse Isoform file", (String)("Failed parsing isoform file: " + e.getMessage()));
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void undoByTimestamp() throws InvocationTargetException, InterruptedException {
        int countActions = this.listActions.size() - 1;
        if (countActions < 0) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Undo", (String)"There are not actions to undo");
            return;
        }
        CsvAction lastAction = this.listActions.get(countActions);
        long timestamp = lastAction.getTimestamp();
        int type = lastAction.getType();
        while (lastAction != null && lastAction.getTimestamp() == timestamp || lastAction.getType() == type) {
            switch (lastAction.getType()) {
                case 3: {
                    this.undoRowEdit(lastAction);
                    break;
                }
                case 2: {
                    this.undoRowDelete(lastAction);
                    break;
                }
                case 1: {
                    this.undoRowAdd(lastAction);
                    break;
                }
                case 8: {
                    this.undoRowColor(lastAction);
                    break;
                }
                case 9: {
                    this.undoRowCheck(lastAction);
                    break;
                }
                case 6: {
                    this.undoColumnEdit(lastAction);
                    break;
                }
                case 11: {
                    this.undoColumnCheck(lastAction);
                    break;
                }
                case 12: {
                    this.undoColumnJoin(lastAction);
                    break;
                }
                case 4: {
                    this.undoColumnAdd(lastAction);
                    break;
                }
                case 5: {
                    this.undoColumnDelete(lastAction);
                    break;
                }
                case 13: {
                    this.undoColumnSplit(lastAction);
                    break;
                }
                case 15: {
                    this.undoColumnHide(lastAction);
                    break;
                }
                case 16: {
                    this.undoColumnSort(lastAction);
                }
            }
            countActions = this.listActions.size() - 1;
            if (countActions == -1) {
                return;
            }
            lastAction = this.listActions.get(countActions);
        }
    }

    public void undoByTimestamp(long limitTimestamp) throws InvocationTargetException, InterruptedException {
        int countActions = this.listActions.size() - 1;
        if (countActions < 0) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Undo", (String)"There are not actions to undo");
            return;
        }
        CsvAction lastAction = this.listActions.get(countActions);
        long timestamp = lastAction.getTimestamp();
        int type = lastAction.getType();
        while (lastAction != null && lastAction.getTimestamp() == timestamp || lastAction.getType() == type) {
            switch (lastAction.getType()) {
                case 3: {
                    this.undoRowEdit(lastAction);
                    break;
                }
                case 2: {
                    this.undoRowDelete(lastAction);
                    break;
                }
                case 1: {
                    this.undoRowAdd(lastAction);
                    break;
                }
                case 8: {
                    this.undoRowColor(lastAction);
                    break;
                }
                case 9: {
                    this.undoRowCheck(lastAction);
                    break;
                }
                case 6: {
                    this.undoColumnEdit(lastAction);
                    break;
                }
                case 11: {
                    this.undoColumnCheck(lastAction);
                    break;
                }
                case 12: {
                    this.undoColumnJoin(lastAction);
                    break;
                }
                case 4: {
                    this.undoColumnAdd(lastAction);
                    break;
                }
                case 5: {
                    this.undoColumnDelete(lastAction);
                    break;
                }
                case 13: {
                    this.undoColumnSplit(lastAction);
                    break;
                }
                case 15: {
                    this.undoColumnHide(lastAction);
                    break;
                }
                case 16: {
                    this.undoColumnSort(lastAction);
                }
            }
            countActions = this.listActions.size() - 1;
            if (countActions == -1) {
                return;
            }
            lastAction = this.listActions.get(countActions);
        }
    }

    public void createColumns(List<String> headers, int insertionIndex, boolean fillColumn, boolean addAction) throws InvocationTargetException, InterruptedException {
        CSVEditorCreateNewColumnRunnable createColumnRunnable = new CSVEditorCreateNewColumnRunnable(this, headers, insertionIndex, fillColumn, addAction);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)createColumnRunnable);
    }

    public void createColumns(String[] headers, int insertionIndex, boolean fillColumn, boolean addAction) throws InvocationTargetException, InterruptedException {
        ArrayList<String> listHeaders = new ArrayList<String>();
        String[] stringArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            String h = stringArray[n2];
            listHeaders.add(h);
            ++n2;
        }
        CSVEditorCreateNewColumnRunnable createColumnRunnable = new CSVEditorCreateNewColumnRunnable(this, listHeaders, insertionIndex, fillColumn, addAction);
        new ProgressMonitorDialog(this.getSite().getShell()).run(false, true, (IRunnableWithProgress)createColumnRunnable);
    }

    private void undoRowEdit(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoRowEditRunnable undoEditRunnable = new CsvUndoRowEditRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)undoEditRunnable);
    }

    private void undoRowDelete(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoRowDeleteRunnable undoDeleteRunnable = new CsvUndoRowDeleteRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)undoDeleteRunnable);
        this.resetModelIndices(true, false);
    }

    private void undoRowAdd(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoRowAddRunnable undoAddRunnable = new CsvUndoRowAddRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)undoAddRunnable);
        this.resetModelIndices(true, false);
    }

    private void undoColumnSort(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoColumnSortRunnable runnable = new CsvUndoColumnSortRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)runnable);
    }

    private void undoRowColor(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoRowColorRunnable undoColorRunnable = new CsvUndoRowColorRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)undoColorRunnable);
    }

    private void undoRowCheck(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoRowCheckRunnable undoCheckRunnable = new CsvUndoRowCheckRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)undoCheckRunnable);
    }

    private void undoColumnEdit(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoColumnEditRunnable undoEditRunnable = new CsvUndoColumnEditRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)undoEditRunnable);
    }

    private void undoColumnCheck(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoColumnCheckRunnable undoCheckRunnable = new CsvUndoColumnCheckRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)undoCheckRunnable);
    }

    private void undoColumnJoin(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoColumnJoinRunnable undoJoinRunnable = new CsvUndoColumnJoinRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)undoJoinRunnable);
    }

    private void undoColumnAdd(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoColumnAddRunnable undoAddRunnable = new CsvUndoColumnAddRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)undoAddRunnable);
    }

    private void undoColumnDelete(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoColumnDeleteRunnable undoDeleteRunnable = new CsvUndoColumnDeleteRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)undoDeleteRunnable);
    }

    private void undoColumnSplit(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoColumnSplitRunnable undoSplitRunnable = new CsvUndoColumnSplitRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)undoSplitRunnable);
    }

    private void undoColumnHide(CsvAction action) throws InvocationTargetException, InterruptedException {
        CsvUndoColumnHideRunnable undoHideRunnable = new CsvUndoColumnHideRunnable(this, action);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)undoHideRunnable);
    }

    private void openSequenceDetails() {
        new CsvSequenceDetailAction(this).run();
    }

    public void loadDefaultFont() {
        String family = PreferenceManager.getInstance().get("worksheetFontFamily", "");
        String style = PreferenceManager.getInstance().get("worksheetFontStyle", "");
        String size = PreferenceManager.getInstance().get("worksheetFontSize", "");
        if (family.isEmpty() || style.isEmpty() || size.isEmpty()) {
            return;
        }
        size = size.replace("pt", "");
        FontData fontData = new FontData(family, Integer.parseInt(size), Integer.parseInt(style));
        this.updateFontAll(fontData);
    }

    public void loadAnnotationColors() throws InterruptedException, InvocationTargetException {
        CsvAnnotationColorsRunnable annotationRunnable = new CsvAnnotationColorsRunnable(this);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)annotationRunnable);
    }

    public void resetAnnotationColors() throws InterruptedException, InvocationTargetException {
        CsvResetAnnotationColorsRunnable resetAnnotationRunnable = new CsvResetAnnotationColorsRunnable(this);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)resetAnnotationRunnable);
    }

    public List<CsvColumnSelectionListener> getListColumnListeners() {
        return this.listColumnListeners;
    }

    public void changePartName(String newName) {
        this.setPartName(newName);
    }

    private void addPartListener() {
        IPartService ip = (IPartService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IPartService.class);
        ip.addPartListener(new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (WorkspaceUtils.getEditorReference((String)CSVEditor.ID) == null) {
                    WorkspaceUtils.hideView((String)"com.biotechvana.csveditor.views.SequenceView");
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        });
    }

    private void addListeners() {
        this.tableViewer.getTable().getColumn(0).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CSVEditor.this.checkAllRows(!CSVEditor.this.allSelected, true, true);
                    if (CSVEditor.this.allSelected) {
                        CSVEditor.this.table.getColumn(0).setImage(CHECK_ENABLED);
                    } else {
                        CSVEditor.this.table.getColumn(0).setImage(CHECK_DISABLED);
                    }
                }
                catch (InvocationTargetException e1) {
                    if (CSVEditor.this.debug) {
                        e1.printStackTrace();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFDF;
                if ((event.detail & 2) == 0) {
                    return;
                }
                int clientWidth = CSVEditor.this.getTableWidth();
                GC gc = event.gc;
                Color oldForeground = gc.getForeground();
                Color oldBackground = gc.getBackground();
                gc.setForeground(CSVEditor.this.colorRowSelected);
                gc.setBackground(CSVEditor.this.colorRowSelected);
                gc.fillRectangle(0, event.y, clientWidth, event.height);
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFFD;
            }
        });
        this.table.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Table t;
                int topIndex;
                if (CSVEditor.this.model != null && Math.abs(CSVEditor.this.lastTopIndex - (topIndex = (t = (Table)event.widget).getTopIndex())) > 10) {
                    CSVEditor.this.updateRows(topIndex, 50);
                    CSVEditor.this.updateRows(topIndex, -50);
                    CSVEditor.this.lastTopIndex = topIndex;
                }
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0) {
                    char c = (char)e.keyCode;
                    switch (c) {
                        case 's': {
                            CSVEditor.this.doSave(null);
                        }
                    }
                }
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CSVEditor.this.openSequenceDetails();
            }
        });
    }

    private int getTableWidth() {
        int totalWidth = 0;
        int i = 0;
        while (i < this.table.getColumnCount()) {
            totalWidth += this.table.getColumn(i).getWidth();
            ++i;
        }
        return totalWidth;
    }

    public List<TableViewerColumn> getTableViewerColumns() {
        return this.listTableViewerColumns;
    }

    public void doSave(IProgressMonitor monitor) {
        CSVEditorSaveDocumentRunnable saveRunnable = null;
        if (this.editorInput.getFileFormat() == CSVEditorInput.Formats.CSV) {
            saveRunnable = new CSVEditorSaveCSVDocumentRunnable(this, this.csvFile, ';', '\"');
        } else if (this.editorInput.getFileFormat() == CSVEditorInput.Formats.GFF) {
            saveRunnable = new CSVEditorSaveGFFDocumentRunnable(this, this.csvFile, ';', '\"');
        }
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)saveRunnable);
        }
        catch (InvocationTargetException e) {
            if (this.debug) {
                e.printStackTrace();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        CSVEditorPostSaveRunnable runnable2 = new CSVEditorPostSaveRunnable(this);
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)runnable2);
        }
        catch (InvocationTargetException e) {
            if (this.debug) {
                e.printStackTrace();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void doSaveAs() {
        this.editorUtils2.doSaveAs();
        try {
            IViewPart viewPart = WorkspaceUtils.findView((String)FileExplorerBasic.ID);
            if (viewPart == null) {
                return;
            }
            ((FileExplorerBasic)viewPart).updateInput();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.csvFile = ((CSVEditorInput)input).getInputFile();
        this.headersOn = ((CSVEditorInput)input).isHeadersOn();
        this.setPartName(this.csvFile.getName());
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    private void createContextMenu() {
        MenuManager popup = new MenuManager();
        Menu contextMenu = popup.createContextMenu(this.tableViewer.getControl());
        MenuManager menuColumn = new MenuManager("Column");
        MenuManager menuRow = new MenuManager("Rows");
        popup.add((IContributionItem)menuColumn);
        popup.add((IContributionItem)menuRow);
        menuColumn.add((IAction)new CsvSelectAllColumnsAction(this, true));
        menuColumn.add((IAction)new CsvSelectAllColumnsAction(this, false));
        menuColumn.add((IContributionItem)new Separator("additions"));
        menuColumn.add((IAction)new CsvAddColumnAction(this));
        menuColumn.add((IAction)new CsvDeleteColumnAction(this));
        menuColumn.add((IContributionItem)new Separator("additions"));
        menuColumn.add((IAction)new CsvRenameColumnsAction(this));
        menuColumn.add((IAction)new CsvFitToContentAction(this));
        menuColumn.add((IContributionItem)new Separator("additions"));
        menuColumn.add((IAction)new CsvJoinColumnsAction(this));
        menuColumn.add((IAction)new CsvSplitColumnAction(this));
        menuColumn.add((IAction)new CsvShowHideColumnsAction(this));
        menuRow.add((IAction)new CsvCheckSelectedRowsAction(this));
        menuRow.add((IAction)new CsvUncheckSelectedRowsAction(this));
        menuRow.add((IContributionItem)new Separator("additions"));
        menuRow.add((IAction)new CsvCopyCheckedRowsAction(this));
        menuRow.add((IAction)new CsvCutCheckedRowsAction(this));
        menuRow.add((IAction)this.csvPasteCheckRows);
        menuRow.add((IAction)new CsvDeleteCheckedRowsAction(this));
        menuRow.add((IContributionItem)new Separator("additions"));
        menuRow.add((IAction)new CsvAddRowsAction(this));
        menuRow.add((IContributionItem)new Separator("additions"));
        menuRow.add((IAction)new CsvSelectMultiHitAction(this));
        menuRow.add((IContributionItem)new Separator("additions"));
        menuRow.add((IAction)new CsvSequenceDetailAction(this));
        this.tableViewer.getControl().setMenu(contextMenu);
    }

    public void refreshTableViewerColumnListeners() {
        this.editorUtils2.refreshTableViewerColumnListeners();
    }

    public boolean toggleStateForColumn(TableViewerColumn col) {
        try {
            this.toggleStateForColumnName(col.getColumn().getText());
            return true;
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    public void toggleStateForColumnIndex(int index) {
        if (this.table.getColumn(index).getImage().equals((Object)CHECK_DISABLED)) {
            this.table.getColumn(index).setImage(CHECK_ENABLED);
        } else {
            this.table.getColumn(index).setImage(CHECK_DISABLED);
        }
    }

    public void toggleStateForColumnName(String columnName) {
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            if (tc.getText().equals(columnName)) {
                if (tc.getImage().equals((Object)CHECK_DISABLED)) {
                    tc.setImage(CHECK_ENABLED);
                } else {
                    tc.setImage(CHECK_DISABLED);
                }
            }
            ++n2;
        }
    }

    public void saveXmlAssociation(String csvPath, String fastaPath, int[] associationColumnIndices, String columnSeparator) throws ParserConfigurationException, SAXException, IOException {
        this.editorUtils2.saveXmlAssociation(csvPath, fastaPath, associationColumnIndices, columnSeparator);
    }

    public void saveAsDefaultWorksheet(String absolutePath) {
        String message = "Successfully saved as default worksheet";
        if (absolutePath == null || absolutePath == "") {
            absolutePath = "";
            message = "Successfully deleted as default worksheet";
        }
        PreferenceManager.getInstance().put("worksheet", absolutePath);
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Default worksheet", (String)message);
    }

    public void saveAsDefaultWorksheet() {
        this.saveAsDefaultWorksheet("");
    }

    public void showSelectMultiIsoform(int rowIndex, String[] subject, int[] columnIndex) {
        CsvSelectIsoformMultiDialog dialog;
        List<String> oldRow = this.model.get(rowIndex);
        if (this.getModelIsoform() == null) {
            try {
                new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        CSVUtils2 csvUtils = CSVUtils2.createNewUtils((File)CSVEditor.this.getIsoformFile(), (boolean)true);
                        try {
                            csvUtils.parse();
                            CSVEditor.this.setModelIsoform(csvUtils.getModel(false, false));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.getModelIsoform() == null) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"Select isoform", (String)"Cannot parse isoform file");
            return;
        }
        ArrayList<List<String>> listMatching = new ArrayList<List<String>>();
        List<List<String>> modelIso = this.getModelIsoform();
        if (modelIso == null || modelIso.size() == 0) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"Select isoform", (String)"No records found in isoform file");
            return;
        }
        int i = 0;
        while (i < modelIso.size()) {
            List<String> row = modelIso.get(i);
            int j = 0;
            while (j < columnIndex.length) {
                if (row.get(columnIndex[j]).equals(subject[j])) {
                    ArrayList<String> matchingRow = new ArrayList<String>();
                    matchingRow.add(0, String.valueOf(i + 1));
                    for (String field : row) {
                        matchingRow.add(field);
                    }
                    listMatching.add(matchingRow);
                }
                ++j;
            }
            ++i;
        }
        if (listMatching != null && listMatching.size() > 0) {
            ScoreFilteringModel scoreFilteringModel = new ScoreFilteringModel();
            scoreFilteringModel.parseScore(listMatching, this.getIsoformHspQueryColumn(), this.getIsoformHspHitColumn(), this.getIsoformSimilarityColumn(), this.getIsoformEValueColumn(), this.getIsoformDepthColumn());
            scoreFilteringModel.sortByScore(listMatching, ((List)listMatching.get(0)).size() - 1);
        }
        if ((dialog = new CsvSelectIsoformMultiDialog(this.getSite().getShell(), this.getEditorUtils2().getColumnNamesAsArray(true, false, false), listMatching)).open() == 0) {
            List<String> replaceRow = dialog.getSelectedRow();
            if (this.debug) {
                System.out.println("selected value:" + String.valueOf(replaceRow));
            }
            if (replaceRow == null) {
                return;
            }
            replaceRow.add(0, oldRow.get(0));
            replaceRow.set(1, oldRow.get(1));
            this.model.set(rowIndex, dialog.getSelectedRow());
            this.tableViewer.refresh();
            int fastaRowIndex = -1;
            int fastaColIndex = -1;
            this.getListModifiedRecords().add(new CsvModifiedRecord(rowIndex, columnIndex[0] + 2, fastaRowIndex, fastaColIndex, oldRow.get(columnIndex[0] + 2), replaceRow.get(columnIndex[0] + 2)));
            this.doSave(null);
        }
    }

    public void showSelectMultiHit(int rowIndex, String subject, int columnIndex) throws CsvParser.CSVParserDocumentNotParsed, IOException {
        List<String> oldRow = this.model.get(rowIndex);
        if (this.getModelMultihit() == null) {
            CSVUtils2 csvUtils = CSVUtils2.createNewUtils((File)this.getMultiHitFile(), (boolean)true);
            try {
                csvUtils.parse();
                this.setModelMultihit(csvUtils.getModel(false, false));
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)ID, (String)("Cannot read multihit file: " + e.getMessage()));
            }
        }
        ArrayList<List<String>> listMatching = new ArrayList<List<String>>();
        List modelMultihit = (List)this.getModelMultihit();
        int i = 0;
        while (i < modelMultihit.size()) {
            List row = (List)modelMultihit.get(i);
            if (((String)row.get(0)).equals(subject)) {
                ArrayList<String> matchingRow = new ArrayList<String>();
                matchingRow.add(0, String.valueOf(i + 1));
                for (String field : row) {
                    matchingRow.add(field);
                }
                listMatching.add(matchingRow);
            }
            ++i;
        }
        CsvSelectMultiHitDialog multiHitDialog = new CsvSelectMultiHitDialog(this.getSite().getShell(), this.getEditorUtils2().getColumnNamesAsArray(true, false, false), listMatching, 0);
        if (multiHitDialog.open() == 0) {
            List<String> replaceRow = multiHitDialog.getSelectedRow();
            if (this.debug) {
                System.out.println("selected value:" + String.valueOf(replaceRow));
            }
            if (replaceRow == null) {
                return;
            }
            replaceRow.add(0, oldRow.get(0));
            replaceRow.set(1, oldRow.get(1));
            this.model.set(rowIndex, multiHitDialog.getSelectedRow());
            this.tableViewer.refresh();
            int fastaRowIndex = -1;
            int fastaColIndex = -1;
            this.getListModifiedRecords().add(new CsvModifiedRecord(rowIndex, columnIndex + 2, fastaRowIndex, fastaColIndex, oldRow.get(columnIndex + 2), replaceRow.get(columnIndex + 2)));
            this.doSave(null);
        }
    }

    public boolean switchRows(File switchFile, int index1, int index2, boolean hasHeaders) {
        CSVUtils2 utils = CSVUtils2.createNewUtils((File)switchFile, (boolean)hasHeaders);
        return utils.switchRows(index1, index2, hasHeaders);
    }

    public void fillColumn(int columnIndex, String value) throws InterruptedException, InvocationTargetException {
        this.fillColumn(columnIndex, value, 0, this.model.size());
    }

    public void fillColumn(int columnIndex, int startIndex, String value) throws InterruptedException, InvocationTargetException {
        this.fillColumn(columnIndex, value, startIndex, this.model.size());
    }

    public void fillColumn(int columnIndex, String value, int startIndex, int endIndex) throws InterruptedException, InvocationTargetException {
        CsvFillColumnRunnable fillRunnable = new CsvFillColumnRunnable(this, columnIndex, value, startIndex, endIndex);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)fillRunnable);
    }

    private void updateFontAll(FontData fontData) {
        Font f = new Font((Device)this.getSite().getShell().getDisplay(), fontData);
        this.tableViewer.getTable().setFont(f);
    }

    public void selectNotEmptyCellRows(int columnIndex, boolean fork, boolean cancelable) throws InvocationTargetException, InterruptedException {
        CsvSelectNotEmptyCellRowsRunnable selectRunnable = new CsvSelectNotEmptyCellRowsRunnable(this, columnIndex);
        new ProgressMonitorDialog(this.getSite().getShell()).run(fork, cancelable, (IRunnableWithProgress)selectRunnable);
    }

    public File getAssociationFile() {
        return this.associationFile;
    }

    public int[] getAssociationColumnIndices() {
        return this.associationColumnIndices;
    }

    public String getAssociationSeparator() {
        return this.associationSeparator;
    }

    public int getAssociationReferenceType() {
        return this.associationReferenceType;
    }

    public void setFocus() {
    }

    public void setAsModified() {
        this.modified = true;
        this.firePropertyChange(257);
    }

    public void fitToContent() throws Exception {
        int[] columnIndices;
        int[] nArray = columnIndices = this.getEditorUtils2().getColumnIndicesAsArray(true, true, true);
        int n = columnIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int ci = nArray[n2];
            this.editorUtils2.fitToContent(ci);
            ++n2;
        }
    }

    public int getColumnCount() {
        return this.tableViewer.getTable().getColumnCount();
    }

    public int deleteColumn(List<String> deleteColumnNames, boolean registerAction) {
        TableColumn[] tableColumns;
        long timestamp = System.currentTimeMillis();
        Collections.sort(deleteColumnNames);
        int deleteCounter = 0;
        TableColumn[] tableColumnArray = tableColumns = this.table.getColumns();
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            String columnName = tc.getText();
            int res = Collections.binarySearch(deleteColumnNames, columnName);
            if (res >= 0) {
                tc.setText(DELETED_COLUMN_PREFIX + columnName);
                tc.setWidth(0);
                tc.setImage(CHECK_DISABLED);
                if (registerAction) {
                    this.getListActions().add(new CsvActionColumnDelete(this.getColumnIndexForName(columnName), columnName, timestamp));
                }
                ++deleteCounter;
            }
            ++n2;
        }
        return deleteCounter;
    }

    public int deleteColumn(String[] deleteColumnNames, boolean registerAction) {
        List<String> listNames = Arrays.asList(deleteColumnNames);
        return this.deleteColumn(listNames, registerAction);
    }

    public void testFunction() {
        this.printModel();
    }

    public void addEmptyColumnsToModel(int numColumns) {
        for (List<String> row : this.model) {
            int i = 0;
            while (i < numColumns) {
                row.add("");
                ++i;
            }
        }
    }

    public int splitCheckSeparator(int columnIndex, String separator) {
        int tokenCount = -1;
        int i = 0;
        while (i < this.model.size()) {
            List<String> row = this.model.get(i);
            String value = row.get(columnIndex);
            if (value != null && value.length() > 0) {
                String[] tokens = value.split(separator);
                if (tokenCount == -1 && tokens.length > 0) {
                    tokenCount = tokens.length;
                } else if (tokenCount != tokens.length) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private void printModel() {
        this.editorUtils2.printModel();
    }

    public void printAssociation() {
        for (AssociatedFastaSequence afs : this.listAssociated) {
            System.out.println(afs.toString());
        }
    }

    public void printAssociationInFile(File outputFile) throws Exception {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            for (AssociatedFastaSequence afs : this.listAssociated) {
                writer.append(afs.toString());
                writer.newLine();
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public void printAssociationResume() {
        DecimalFormat df = new DecimalFormat("###,###");
        int countOk = 0;
        int countNAFasta = 0;
        int countNACsv = 0;
        for (AssociatedFastaSequence afs : this.listAssociated) {
            if (afs.getIndexFasta() == -1) {
                ++countNAFasta;
                continue;
            }
            if (afs.getIndexWorksheet() == -1) {
                ++countNACsv;
                continue;
            }
            ++countOk;
        }
        if (countNACsv == 0 && countNAFasta == 0) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Database association", (String)(df.format(countOk) + " successfully associated sequences.\n\nAll sequences have been successfully associated.\n"));
        } else {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Database association", (String)(df.format(countOk) + " successfully associated sequences.\n\n" + df.format(countNACsv) + "/" + df.format(this.model.size()) + " worksheet sequences without association.\n" + df.format(countNAFasta) + " database sequences without association"));
        }
    }

    private boolean splitCheckSeparator(List<List<String>> input, int columnIndex, char separator) {
        int firstSeparatorCount = 0;
        String firstField = input.get(0).get(columnIndex + 2);
        int i = 0;
        while (i < firstField.length()) {
            if (firstField.charAt(i) == separator) {
                ++firstSeparatorCount;
            }
            ++i;
        }
        int separatorCount = 0;
        for (List<String> row : input) {
            separatorCount = 0;
            String field = row.get(columnIndex + 2);
            int i2 = 0;
            while (i2 < field.length()) {
                if (field.charAt(i2) == separator) {
                    ++separatorCount;
                }
                ++i2;
            }
            if (firstSeparatorCount == separatorCount) continue;
            return false;
        }
        return true;
    }

    public void deleteRows(List<Integer> listSelectedRows, long timestamp) throws InvocationTargetException, InterruptedException {
        CsvDeleteRowsRunnable deleteRunnable = new CsvDeleteRowsRunnable(this, listSelectedRows, timestamp);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)deleteRunnable);
    }

    public void copyRows(List<Integer> listSelectedRows) {
        if (listSelectedRows.size() == 0) {
            return;
        }
        Object[] copyRows = new Object[listSelectedRows.size()];
        int i = 0;
        while (i < listSelectedRows.size()) {
            copyRows[i] = this.model.get(listSelectedRows.get(i));
            ++i;
        }
        this.setCopyRows(copyRows);
        if (CSVEditor.getCopyRows().length != 0) {
            this.csvPasteCheckRows.setEnabled(true);
        }
    }

    public void cutRows(List<Integer> listSelectedRows) throws InvocationTargetException, InterruptedException {
        if (listSelectedRows.size() == 0) {
            return;
        }
        Object[] copyRows = new Object[listSelectedRows.size()];
        int i = 0;
        while (i < listSelectedRows.size()) {
            copyRows[i] = this.model.get(listSelectedRows.get(i));
            ++i;
        }
        this.setCopyRows(copyRows);
        this.deleteRows(listSelectedRows, System.currentTimeMillis());
        this.resetModelIndices(true, false);
        if (CSVEditor.getCopyRows().length != 0) {
            this.csvPasteCheckRows.setEnabled(true);
        }
    }

    public void pasteRows(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Paste rows", CSVEditor.getCopyRows().length);
            monitor.subTask("Pasting rows...");
            int count = this.table.getItemCount();
            int index = this.table.getSelectionIndex();
            if (count == 0) {
                if (index == -1) {
                    index = 0;
                }
            } else {
                index = index == -1 ? count : this.table.getSelectionIndex() + 1;
            }
            if (CSVEditor.getCopyRows() != null) {
                int i = CSVEditor.getCopyRows().length - 1;
                while (i >= 0) {
                    this.model.add(index, (ArrayList)((ArrayList)copyRows[i]).clone());
                    monitor.worked(1);
                    --i;
                }
                this.checkAllRows(false, true, true);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void openAddRowsDialog() {
        InputDialog dialog = new InputDialog(this.getSite().getShell(), "Insert rows", "How many rows?", "1", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.matches("(.+)?\\D+(.+)?")) {
                    return "Invalid number";
                }
                return null;
            }
        });
        if (dialog.open() == 1) {
            return;
        }
        int newRowCount = Integer.parseInt(dialog.getValue());
        dialog.close();
        int[] selIndices = this.tableViewer.getTable().getSelectionIndices();
        if (selIndices.length > 0) {
            int insertionIndex = selIndices[selIndices.length - 1];
            this.addRows(this.tableViewer, insertionIndex, newRowCount);
        }
    }

    private void addRows(TableViewer tViewer, int insertionIndex, int numRows) {
        this.editorUtils2.addRows(tViewer, insertionIndex, numRows);
    }

    public void checkSelectedRows(boolean check, boolean fork, boolean cancelable) throws InvocationTargetException, InterruptedException {
        CsvCheckRowsRunnable checkRunnable = new CsvCheckRowsRunnable(this, this.getTable().getSelectionIndices(), check);
        new ProgressMonitorDialog(this.getSite().getShell()).run(fork, cancelable, (IRunnableWithProgress)checkRunnable);
    }

    public void checkAllRows(boolean check, boolean fork, boolean cancelable) throws InvocationTargetException, InterruptedException {
        CsvCheckRowsRunnable checkRunnable = new CsvCheckRowsRunnable(this, check);
        new ProgressMonitorDialog(this.getSite().getShell()).run(fork, cancelable, (IRunnableWithProgress)checkRunnable);
    }

    public void checkAllColumns(boolean check, boolean ignoreInvisible) throws Exception {
        try {
            TableColumn[] tableColumns = this.table.getColumns();
            int i = 2;
            while (i < tableColumns.length) {
                String name = tableColumns[i].getText();
                int width = tableColumns[i].getWidth();
                boolean modify = true;
                if (name.startsWith(DELETED_COLUMN_PREFIX)) {
                    modify = false;
                }
                if (ignoreInvisible && width == 0) {
                    modify = false;
                }
                if (modify) {
                    if (check) {
                        tableColumns[i].setImage(CHECK_ENABLED);
                    } else {
                        tableColumns[i].setImage(CHECK_DISABLED);
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void checkColumnsByName(List<String> names, boolean ignoreInvisible, boolean check) {
        Collections.sort(names);
        Image checkImage = CHECK_ENABLED;
        if (!check) {
            checkImage = CHECK_DISABLED;
        }
        TableColumn[] tableColumns = this.getTable().getColumns();
        int i = 2;
        while (i < tableColumns.length) {
            int res = Collections.binarySearch(names, tableColumns[i].getText(), new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            if (res >= 0) {
                tableColumns[i].setImage(checkImage);
            }
            ++i;
        }
    }

    public void hideColumns(List<String> columnNames) {
        this.editorUtils2.hideColumns(columnNames);
    }

    public int[] getPreviousColumnOrder() {
        return this.columnOrder;
    }

    public void setPreviousColumnOrder(int[] columnOrder) {
        this.columnOrder = columnOrder;
    }

    public int getColumnIndexForName(String name) {
        int[] indices = this.getEditorUtils2().getColumnIndicesAsArray(new String[]{name});
        if (indices == null || indices.length == 0) {
            return -1;
        }
        return indices[0];
    }

    public int[] getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void setHiddenColumns(int[] hiddenColumns) {
        this.hiddenColumns = hiddenColumns;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.firePropertyChange(257);
    }

    public List<CsvAction> getListActions() {
        return this.listActions;
    }

    public void selectByColor(RGB rgbRow, boolean selection) throws InvocationTargetException, InterruptedException {
        CsvRowIndicesByColorRunnable colorRunnable = new CsvRowIndicesByColorRunnable(this, new Color[]{new Color((Device)this.getSite().getShell().getDisplay(), rgbRow)});
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)colorRunnable);
        CsvCheckRowsRunnable checkRowsRunnable = new CsvCheckRowsRunnable(this, colorRunnable.getIndices(), selection);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)checkRowsRunnable);
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Check by color", (String)(new DecimalFormat("###,###").format(colorRunnable.getIndices().size()) + " rows selected"));
    }

    public List<List<Integer>> selectByTerms(CsvSelectTermDialog.Term[] terms, int columnIndex, boolean exact, boolean ignoreCase, boolean regexp, boolean fork, boolean cancelable) throws InvocationTargetException, InterruptedException {
        CsvSelectByTermRunnable termRunnable = new CsvSelectByTermRunnable(this, columnIndex, terms, exact, ignoreCase, regexp);
        new ProgressMonitorDialog(this.getSite().getShell()).run(fork, cancelable, (IRunnableWithProgress)termRunnable);
        return termRunnable.getMatchingIndices();
    }

    public int[] searchTerm(String term, int columnIndex, boolean exactMatch, boolean caseSensitive, boolean regexp) throws InterruptedException, PatternSyntaxException, InvocationTargetException {
        CsvSearchTermRunnable termRunnable = new CsvSearchTermRunnable(this, columnIndex, term, exactMatch, caseSensitive, regexp);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)termRunnable);
        return termRunnable.getMatchingIndices();
    }

    public String escapeTerm(String term, boolean exact, boolean caseSensitive, boolean regexp) {
        return TermMatcher.escapeTerm((String)term, (boolean)exact, (boolean)caseSensitive, (boolean)regexp);
    }

    public List<Integer> getCheckedRowIndices(boolean fork, boolean cancelable) throws InvocationTargetException, InterruptedException {
        CsvGetCheckedRowsIndicesRunnable checkedRunnable = new CsvGetCheckedRowsIndicesRunnable((List)this.getModel());
        new ProgressMonitorDialog(this.getSite().getShell()).run(fork, cancelable, (IRunnableWithProgress)checkedRunnable);
        return checkedRunnable.getListIndices();
    }

    public void deselectAll() {
        this.tableViewer.getTable().deselectAll();
    }

    public void selectRows(int[] indices) {
        this.tableViewer.getTable().deselectAll();
        this.tableViewer.getTable().select(indices);
        this.tableViewer.getTable().showSelection();
    }

    public void selectRows(List<Integer> indices, IProgressMonitor monitor) throws InterruptedException {
        try {
            this.tableViewer.getTable().deselectAll();
            monitor.beginTask("Select rows", indices.size());
            for (int i : indices) {
                this.tableViewer.getTable().select(i);
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
            this.tableViewer.getTable().showSelection();
        }
        finally {
            monitor.done();
        }
    }

    public void replaceAll(String regexp, String replacement, int column, int[] rowIndices) throws PatternSyntaxException, InterruptedException, InvocationTargetException {
        CsvReplaceAllRunnable replaceAllRunnable = new CsvReplaceAllRunnable(this, regexp, replacement, column, rowIndices);
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)replaceAllRunnable);
        this.setModified(true);
    }

    public void replace(String regexp, String replacement, int column, int rowIndice) throws PatternSyntaxException {
        this.editorUtils2.replace(regexp, replacement, column, rowIndice);
    }

    public void selectColumn(int indice) {
        this.editorUtils2.selectColumn(indice);
    }

    public void sortAsAlphaNum(int columnIndex, boolean ascending, boolean registerAction) throws InvocationTargetException, InterruptedException {
        if (registerAction) {
            this.listActions.add(new CsvActionColumnSort(this.getTable().getColumn(columnIndex).getText(), (List)this.getModel()));
        }
        CsvSortRunnable sortRunnable = new CsvSortRunnable((List<List<String>>)((List)this.getModel()), columnIndex, 0, ascending);
        new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)sortRunnable);
    }

    public void sortAsScientific(int columnIndex, boolean ascending, boolean registerAction, String columnName) throws InvocationTargetException, InterruptedException {
        if (registerAction) {
            this.listActions.add(new CsvActionColumnSort(this.getTable().getColumn(columnIndex).getText(), (List)this.getModel()));
        }
        int sortType = 0;
        if (columnName.equalsIgnoreCase("E-value") || columnName.equals("Evalue")) {
            sortType = 2;
        } else if (columnName.equalsIgnoreCase("Score")) {
            sortType = 3;
        } else if (columnName.equalsIgnoreCase("identities")) {
            sortType = 6;
        } else if (columnName.equalsIgnoreCase("positives")) {
            sortType = 7;
        } else if (columnName.equalsIgnoreCase("align-length") || columnName.equalsIgnoreCase("align_length") || columnName.equals("align length") || columnName.equalsIgnoreCase("align-len") || columnName.equalsIgnoreCase("align_len") || columnName.equals("align len")) {
            sortType = 8;
        } else if (columnName.equalsIgnoreCase("hsp/query") || columnName.equalsIgnoreCase("hsp/hit")) {
            sortType = 10;
        } else if (columnName.equalsIgnoreCase("subject-from") || columnName.equalsIgnoreCase("hit-from") || columnName.equalsIgnoreCase("subject_from") || columnName.equalsIgnoreCase("hit_from") || columnName.equalsIgnoreCase("subject from") || columnName.equalsIgnoreCase("hit from") || columnName.equalsIgnoreCase("query-from") || columnName.equalsIgnoreCase("query from")) {
            sortType = 4;
        } else if (columnName.equalsIgnoreCase("subject-to") || columnName.equalsIgnoreCase("hit-to") || columnName.equalsIgnoreCase("subject_to") || columnName.equalsIgnoreCase("hit_to") || columnName.equalsIgnoreCase("subject to") || columnName.equalsIgnoreCase("hit to") || columnName.equalsIgnoreCase("query-to") || columnName.equalsIgnoreCase("query to")) {
            sortType = 5;
        }
        CsvSortRunnable sortRunnable = new CsvSortRunnable((List<List<String>>)((List)this.getModel()), columnIndex, sortType, ascending);
        new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)sortRunnable);
    }

    public void resetModelIndices(boolean fork, boolean cancelable) throws InvocationTargetException, InterruptedException {
        CsvResetModelIndicesRunnable resetRunnable = new CsvResetModelIndicesRunnable(this);
        new ProgressMonitorDialog(this.getSite().getShell()).run(fork, cancelable, (IRunnableWithProgress)resetRunnable);
    }

    public int detectDataTypeForColumn(int columnIndex) throws PatternSyntaxException, IndexOutOfBoundsException {
        return this.editorUtils2.detectDataType(columnIndex);
    }

    public void exportByCategory(int categoryColumnIndex, List<Integer> columnIndices, List<Integer> rowIndices, File outputFolder, boolean withFasta, List<String> columnNames, double range) throws InterruptedException, InvocationTargetException {
        CsvExportCategoriesRunnable categoryRunnable = this.associationFile != null ? new CsvExportCategoriesRunnable((List)this.getModel(), rowIndices, categoryColumnIndex, columnNames, columnIndices, outputFolder, this.associationFile, this.associationColumnIndices, this.associationSeparator) : new CsvExportCategoriesRunnable((List)this.getModel(), rowIndices, categoryColumnIndex, columnNames, columnIndices, outputFolder);
        if (range != 0.0) {
            categoryRunnable.setRange(range);
        }
        new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)categoryRunnable);
    }

    public Object getModel() {
        return this.model;
    }

    public Object getModelMultihit() {
        return this.modelMultihit;
    }

    public void setModelMultihit(List<List<String>> modelMultihit) {
        this.modelMultihit = modelMultihit;
    }

    public Table getTable() {
        return this.table;
    }

    public int getEvalueColumn() {
        return this.editorUtils2.getEvalueColumn();
    }

    public boolean isShowAnnotationColors() {
        return this.showAnnotationColors;
    }

    public void joinColumns(int[] columnIndices, char separator, String joinName, boolean fork, boolean cancelable) throws InterruptedException, InvocationTargetException {
        CsvJoinColumnsRunnable joinRunnable = new CsvJoinColumnsRunnable(this, columnIndices, separator, joinName, System.currentTimeMillis());
        new ProgressMonitorDialog(this.getSite().getShell()).run(fork, cancelable, (IRunnableWithProgress)joinRunnable);
    }

    public void setShowAnnotationColors(boolean showAnnotationColors) {
        this.showAnnotationColors = showAnnotationColors;
    }

    public void renameColumn(String oldName, String newName) {
        this.editorUtils2.renameColumn(oldName, newName);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public int[] getExportColumnIndices() {
        return this.exportColumnIndices;
    }

    public void setExportColumnIndices(int[] exportColumnIndices) {
        this.exportColumnIndices = exportColumnIndices;
    }

    public void setAssociationFile(File associationFile) {
        this.associationFile = associationFile;
    }

    public void setAssociationColumnIndices(int[] associationColumnIndices) {
        this.associationColumnIndices = associationColumnIndices;
    }

    public void setAssociationSeparator(String associationSeparator) {
        this.associationSeparator = associationSeparator;
    }

    public void setAssociationReference(int associationReferenceType) {
        this.associationReferenceType = associationReferenceType;
    }

    public File getCsvFile() {
        return this.csvFile;
    }

    public void setCsvFile(File csvFile) {
        this.csvFile = csvFile;
    }

    private static Object[] getCopyRows() {
        return copyRows;
    }

    public void setCopyRows(Object[] copyRows) {
        CSVEditor.copyRows = copyRows;
    }

    public List<TableViewerColumn> getListTableViewerColumns() {
        return this.listTableViewerColumns;
    }

    public void setListTableViewerColumns(List<TableViewerColumn> listTableViewerColumns) {
        this.listTableViewerColumns = listTableViewerColumns;
    }

    public boolean isHeadersOn() {
        return this.headersOn;
    }

    public void setHeadersOn(boolean headersOn) {
        this.headersOn = headersOn;
    }

    public boolean isAllSelected() {
        return this.allSelected;
    }

    public void setAllSelected(boolean allSelected) {
        this.allSelected = allSelected;
    }

    public Color getColorNotAssociated() {
        return this.colorNotAssociated;
    }

    public void setColorNotAssociated(Color colorNotAssociated) {
        this.colorNotAssociated = colorNotAssociated;
    }

    public List<CsvModifiedRecord> getListModifiedRecords() {
        return this.listModifiedRecords;
    }

    public void setListModifiedRecords(List<CsvModifiedRecord> listModifiedRecords) {
        this.listModifiedRecords = listModifiedRecords;
    }

    public boolean isMultiHit() {
        return this.editorInput.isMultiHit();
    }

    public File getMultiHitFile() {
        return this.editorInput.getMultiHitFile();
    }

    public CsvParser getCsvParser() {
        return this.csvParser;
    }

    public Map<String, Color> getMapAnnotationColors() {
        return this.mapAnnotationColors;
    }

    public void setMapAnnotationColors(Map<String, Color> mapAnnotationColors) {
        this.mapAnnotationColors = mapAnnotationColors;
    }

    public Map<String, Integer> getMapAnnotationIndices() {
        return this.mapAnnotationIndices;
    }

    public void setMapAnnotationIndices(Map<String, Integer> mapAnnotationIndices) {
        this.mapAnnotationIndices = mapAnnotationIndices;
    }

    public CsvEditorUtils2 getEditorUtils2() {
        return this.editorUtils2;
    }

    public List<Integer> getSelectedIndices() {
        return this.selectedIndices;
    }

    public void setSelectedIndices(List<Integer> selectedIndices) {
        this.selectedIndices = selectedIndices;
    }

    public void updateRows(int start, int length) {
        block5: {
            block4: {
                if (length <= 0) break block4;
                int i = 0;
                while (i < length) {
                    int index = start + i;
                    if (index >= 0 && index < this.model.size()) {
                        List<String> row = this.model.get(index);
                        this.tableViewer.update(row, null);
                    }
                    ++i;
                }
                break block5;
            }
            if (length >= 0) break block5;
            int i = 0;
            while (i < -length) {
                int index = start - i;
                if (index >= 0 && index < this.model.size()) {
                    List<String> row = this.model.get(index);
                    this.tableViewer.update(row, null);
                }
                ++i;
            }
        }
    }

    public String getComments(boolean force) {
        if (this.csvUtils2 != null) {
            try {
                return this.csvUtils2.getComments(force);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public Map<String, String> getCommentsAsMap(boolean force) {
        if (this.csvUtils2 != null) {
            try {
                return this.csvUtils2.getCommentsAsMap(force);
            }
            catch (IOException e) {
                return new HashMap<String, String>();
            }
        }
        return new HashMap<String, String>();
    }

    public List<Integer> getIsoformColumns() {
        return this.isoformColumns;
    }

    public void setIsoformColumns(List<Integer> isoformColumns) {
        this.isoformColumns = isoformColumns;
    }

    public File getIsoformFile() {
        return this.isoformFile;
    }

    public void setIsoformFile(File isoformFile) {
        this.isoformFile = isoformFile;
    }

    public boolean isIsoformFilterOverlapping() {
        return this.isoformFilterOverlapping;
    }

    public void setIsoformFilterOverlapping(boolean isoformFilterOverlapping) {
        this.isoformFilterOverlapping = isoformFilterOverlapping;
    }

    public List<List<String>> getModelIsoform() {
        return this.modelIsoform;
    }

    public void setModelIsoform(List<List<String>> modelIsoform) {
        this.modelIsoform = modelIsoform;
    }

    public int getIsoformHspQueryColumn() {
        return this.isoformHspQueryColumn;
    }

    public void setIsoformHspQueryColumn(int isoformHspQueryColumn) {
        this.isoformHspQueryColumn = isoformHspQueryColumn;
    }

    public int getIsoformHspHitColumn() {
        return this.isoformHspHitColumn;
    }

    public void setIsoformHspHitColumn(int isoformHspHitColumn) {
        this.isoformHspHitColumn = isoformHspHitColumn;
    }

    public int getIsoformSimilarityColumn() {
        return this.isoformSimilarityColumn;
    }

    public void setIsoformSimilarityColumn(int isoformSimilarityColumn) {
        this.isoformSimilarityColumn = isoformSimilarityColumn;
    }

    public int getIsoformEValueColumn() {
        return this.isoformEValueColumn;
    }

    public void setIsoformEValueColumn(int isoformEValueColumn) {
        this.isoformEValueColumn = isoformEValueColumn;
    }

    public int getIsoformDepthColumn() {
        return this.isoformDepthColumn;
    }

    public void setIsoformDepthColumn(int isoformDepthColumn) {
        this.isoformDepthColumn = isoformDepthColumn;
    }

    public void setAssociatedSequenceFileInfo(SequenceFileInfo sequenceFileInfo) {
        this.associatedSequenceFileInfo = sequenceFileInfo;
    }

    public SequenceFileInfo getAssociatedSequenceFileInfo() {
        return this.associatedSequenceFileInfo;
    }

    public static void ErrorNoActiveEditor() {
    }

    public int getRowCount() {
        try {
            return this.csvUtils2.getLineCount();
        }
        catch (CSVUtils2.LineCountNotDoneException e) {
            return 0;
        }
    }

    public static enum Annotation {
        ANNOTATION_NOHIT("No hit", "Non significant hit", "colorNohit"),
        ANNOTATION_HIT("Significant hit", "Significant hit", "colorHit"),
        ANNOTATION_FUNCTION("Mapped", "Mapped (Significant with function)", "colorMapped"),
        ANNOTATION_MAPPED("Annotated", "Annotated", "colorAnnotated"),
        ANNOTATION_MAPPED_PLUS("Annotated plus", "Annotated plus (Enzyme code)", "colorAnnotatedPlus");

        private final String key;
        private final String value;
        private final String preferenceKey;

        private Annotation(String key, String value, String preferenceKey) {
            this.key = key;
            this.value = value;
            this.preferenceKey = preferenceKey;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getPreferenceKey() {
            return this.preferenceKey;
        }
    }
}

