/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.preferences;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.utils.PreferenceManager;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;

public class PreferencesWorksheetDialog
extends TitleAreaDialog {
    private Combo comboFamily;
    private Combo comboSize;
    private Combo comboStyle;
    private Button buttonRestore;

    public PreferencesWorksheetDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData layoutData = new GridData();
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        composite.setLayout((Layout)layout);
        Group groupFont = this.createGroupFont(composite, 0);
        this.buttonRestore = new Button(composite, 0);
        this.buttonRestore.setText("Restore default settings");
        layoutData = new GridData();
        layoutData.verticalIndent = 20;
        this.buttonRestore.setLayoutData((Object)layoutData);
        this.initDialog();
        this.addListeners();
        return compositeParent;
    }

    private void initDialog() {
        this.setTitle("Worksheet preferences");
        this.setMessage("Set preferences for worksheets");
        this.getShell().setText("Worksheet preferences");
    }

    private void addListeners() {
        this.buttonRestore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesWorksheetDialog.this.restoreDefaultSettings();
            }
        });
    }

    private Group createGroupFont(Composite parent, int style) {
        Group composite = new Group(parent, style);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setText("Font");
        Label labelFamily = new Label((Composite)composite, 0);
        labelFamily.setText("Font family:");
        this.comboFamily = new Combo((Composite)composite, 12);
        FontData[] fontList = this.getShell().getDisplay().getFontList(null, true);
        HashSet<String> fontSet = new HashSet<String>();
        FontData[] fontDataArray = fontList;
        int n = fontList.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fontSet.add(fd.getName());
            ++n2;
        }
        Object[] fontNames = fontSet.toArray(new String[fontSet.size()]);
        Arrays.sort(fontNames);
        this.comboFamily.setItems((String[])fontNames);
        Label labelStyle = new Label((Composite)composite, 0);
        labelStyle.setText("Font style:");
        this.comboStyle = new Combo((Composite)composite, 12);
        this.comboStyle.setItems(new String[]{"Regular", "Bold", "Italics"});
        Label labelSize = new Label((Composite)composite, 0);
        labelSize.setText("Font size:");
        this.comboSize = new Combo((Composite)composite, 12);
        this.comboSize.setItems(new String[]{"8pt", "10pt", "12pt", "14pt", "18pt", "24pt", "30pt"});
        String fontFamily = PreferenceManager.getInstance().get("worksheetFontFamily", "");
        String fontStyle = PreferenceManager.getInstance().get("worksheetFontStyle", "");
        String fontSize = PreferenceManager.getInstance().get("worksheetFontSize", "");
        this.initializeFontValues(fontFamily, fontStyle, fontSize);
        return composite;
    }

    private void initializeFontValues(String fontName, String style, String size) {
        if (fontName.isEmpty()) {
            fontName = Display.getDefault().getSystemFont().getFontData()[0].getName();
        }
        if (!fontName.isEmpty()) {
            int i = 0;
            while (!this.comboFamily.getItem(i).equalsIgnoreCase(fontName)) {
                ++i;
            }
            this.comboFamily.select(i);
        }
        if (style.isEmpty()) {
            style = "0";
        }
        this.comboStyle.select(Integer.parseInt(style));
        if (size.isEmpty()) {
            size = "10pt";
        }
        boolean found = false;
        int i = 0;
        while (i < this.comboSize.getItemCount() && !found) {
            if (this.comboSize.getItem(i).equalsIgnoreCase(String.valueOf(size))) {
                found = true;
                this.comboSize.select(i);
            }
            ++i;
        }
        if (!found) {
            this.comboSize.select(0);
        }
    }

    private void restoreDefaultSettings() {
        PreferenceManager.getInstance().put("worksheetFontFamily", Display.getDefault().getSystemFont().getFontData()[0].getName());
        PreferenceManager.getInstance().put("worksheetFontStyle", "0");
        PreferenceManager.getInstance().put("worksheetFontSize", "10");
        this.initializeFontValues(Display.getDefault().getSystemFont().getFontData()[0].getName(), "0", "10");
    }

    protected void okPressed() {
        this.saveFont();
        this.applySelectionToWorksheets();
        super.okPressed();
    }

    private void saveFont() {
        if (this.comboFamily.getSelectionIndex() == -1 || this.comboStyle.getSelectionIndex() == -1 || this.comboSize.getSelectionIndex() == -1) {
            return;
        }
        String family = this.comboFamily.getItem(this.comboFamily.getSelectionIndex());
        int style = this.comboStyle.getSelectionIndex();
        String size = this.comboSize.getItem(this.comboSize.getSelectionIndex());
        PreferenceManager.getInstance().put("worksheetFontFamily", family);
        PreferenceManager.getInstance().put("worksheetFontStyle", String.valueOf(style));
        PreferenceManager.getInstance().put("worksheetFontSize", size);
    }

    private void applySelectionToWorksheets() {
        IEditorReference[] editorReferences = WorkspaceUtils.getEditorReference((String)"com.biotechvana.csveditor.editors.CSVEditor");
        if (editorReferences != null) {
            IEditorReference[] iEditorReferenceArray = editorReferences;
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                CSVEditor editor = (CSVEditor)ref.getEditor(false);
                editor.loadDefaultFont();
                ++n2;
            }
        }
    }
}

