/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.goAnnotation;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.goAnnotation.GOTerm;
import com.biotechvana.csveditor.model.StatisticsModel;
import com.biotechvana.csveditor.views.StatsView;
import com.biotechvana.e3utils.WorkspaceUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;

public class StatisticsByDepthDialog
extends TitleAreaDialog {
    private static final String TITLE = "Gene Ontology distributions";
    private static final int TEXT_LIMIT = 20;
    private static final String OUTPUT_TYPE_COUNT = "count";
    private static final String OUTPUT_TYPE_TERMS = "terms";
    private boolean pieLegend = false;
    private Label columnLabel;
    private Combo goColumnCombo;
    private Group goFilterParametersGroup;
    private Label domainLabel;
    private Combo domainCombo;
    private Label sequenceMinimumFilterLabel;
    private Text sequenceMinimumFilterText;
    private Label alphaLabel;
    private Spinner alphaSpinner;
    private Label nodeScoreThresholdLabel;
    private Text nodeScoreThresholdText;
    private Label depthLabel;
    private Spinner depthSpinner;
    private Group chartTypeGroup;
    private Button barChartRadio;
    private Button pieChartRadio;
    private Group barChartOptionsGroup;
    private Button buttonOrientationHorizontal;
    private Button buttonOrientationVertical;
    private Group graphicTypeGroup;
    private Button type2DButton;
    private Button type3DButton;
    private Group graphColorGroup;
    private Label labelColor;
    private Button buttonColor;
    private RGB rgbRow;
    private Group outputGroup;
    private Button buttonOutputCount;
    private Button buttonOutputTerms;
    private Composite levelSelectionGroup;
    private Button buttonLevelAll;
    private Button buttonLevelSelect;
    private Button buttonLevelUpTo;
    private Button buttonLevelThis;
    private CSVEditor csvEditor;
    private PlotOrientation plotOrientation = PlotOrientation.HORIZONTAL;
    private StatsView statsView;

    public StatisticsByDepthDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    public void create() {
        super.create();
        this.setTitle(TITLE);
        this.setMessage("Generate a depth chart from worksheet GO annotations.");
        this.getButton(0).setEnabled(true);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout compositeLayout = new GridLayout(3, false);
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        parent.setLayout((Layout)compositeLayout);
        Composite innerTopComposite = new Composite(parent, 0);
        GridLayout innerTopCompositeLayout = new GridLayout(2, false);
        innerTopComposite.setLayout((Layout)innerTopCompositeLayout);
        GridData innerTopCompositeData = new GridData(16384, 0x1000000, false, false, 2, 1);
        innerTopComposite.setLayoutData((Object)innerTopCompositeData);
        this.columnLabel = new Label(innerTopComposite, 0);
        this.columnLabel.setText("Gene Ontology terms column: ");
        GridData columnLabelData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.columnLabel.setLayoutData((Object)columnLabelData);
        this.goColumnCombo = new Combo(innerTopComposite, 2060);
        this.goColumnCombo.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true));
        this.goColumnCombo.setText(this.goColumnCombo.getItem(0));
        String[] stringArray = this.goColumnCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String comboItemString = stringArray[n2];
            if (comboItemString.startsWith("GO") && !comboItemString.endsWith("#")) {
                this.goColumnCombo.setText(comboItemString);
                break;
            }
            ++n2;
        }
        GridData goColumnComboData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.goColumnCombo.setLayoutData((Object)goColumnComboData);
        this.createGOFilterParametersGroup(parent, 0);
        GridData goFilterParametersGroupData = new GridData(4, 0x1000000, true, false, 3, 1);
        this.goFilterParametersGroup.setLayoutData((Object)goFilterParametersGroupData);
        this.createChartTypeGroup(parent, 0);
        GridData chartTypeGroupData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.chartTypeGroup.setLayoutData((Object)chartTypeGroupData);
        this.createBarChartOptionsGroup(parent, 0);
        GridData barChartOptionsGroupData = new GridData(4, 0x1000000, false, false, 2, 1);
        this.barChartOptionsGroup.setLayoutData((Object)barChartOptionsGroupData);
        this.createGraphicTypeGroup(parent, 0);
        GridData graphicTypeGroupData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.graphicTypeGroup.setLayoutData((Object)graphicTypeGroupData);
        this.createGraphColorGroup(parent, 0);
        GridData graphColorGroupData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.graphColorGroup.setLayoutData((Object)graphColorGroupData);
        this.createOutputTypeGroup(parent, 0);
        GridData outputGroupData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.outputGroup.setLayoutData((Object)outputGroupData);
        this.addListeners();
        parent.setSize(parent.computeSize(-1, -1));
        return parent;
    }

    private void createGOFilterParametersGroup(Composite parent, int style) {
        this.goFilterParametersGroup = new Group(parent, style);
        this.goFilterParametersGroup.setText("GO term filtering parameters");
        FormLayout goFilterParametersGroupLayout = new FormLayout();
        goFilterParametersGroupLayout.marginHeight = 10;
        goFilterParametersGroupLayout.marginWidth = 10;
        this.goFilterParametersGroup.setLayout((Layout)goFilterParametersGroupLayout);
        int defaultHorizontalIndent = 10;
        Composite innerFilterTopComposite = new Composite((Composite)this.goFilterParametersGroup, 0);
        GridLayout innerFilterTopCompositeLayout = new GridLayout(5, false);
        innerFilterTopComposite.setLayout((Layout)innerFilterTopCompositeLayout);
        FormData innerFilterTopCompositeData = new FormData();
        innerFilterTopCompositeData.top = new FormAttachment(0, 0);
        innerFilterTopCompositeData.left = new FormAttachment(0, 0);
        innerFilterTopComposite.setLayoutData((Object)innerFilterTopCompositeData);
        this.domainLabel = new Label(innerFilterTopComposite, 0);
        this.domainLabel.setText("Gene Ontology domain: ");
        GridData domainLabelData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.domainLabel.setLayoutData((Object)domainLabelData);
        this.domainCombo = new Combo(innerFilterTopComposite, 12);
        GOTerm.GODomain[] gODomainArray = GOTerm.GODomain.values();
        int n = gODomainArray.length;
        int n2 = 0;
        while (n2 < n) {
            GOTerm.GODomain termType = gODomainArray[n2];
            this.domainCombo.add(termType.getPrettyName());
            ++n2;
        }
        this.domainCombo.setText(this.domainCombo.getItem(0));
        GridData domainComboData = new GridData(16384, 0x1000000, false, false, 2, 1);
        this.domainCombo.setLayoutData((Object)domainComboData);
        Label domainExplanationLabel = new Label(innerFilterTopComposite, 0);
        domainExplanationLabel.setText("");
        GridData domainExplanationLabelData = new GridData(16384, 0x1000000, true, false, 2, 1);
        domainExplanationLabelData.horizontalIndent = defaultHorizontalIndent;
        domainExplanationLabel.setLayoutData((Object)domainExplanationLabelData);
        this.sequenceMinimumFilterLabel = new Label(innerFilterTopComposite, 0);
        this.sequenceMinimumFilterLabel.setText("Sequence filter: ");
        GridData sequenceMinimumFilterLabelData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.sequenceMinimumFilterLabel.setLayoutData((Object)sequenceMinimumFilterLabelData);
        this.sequenceMinimumFilterText = new Text(innerFilterTopComposite, 2048);
        this.sequenceMinimumFilterText.setTextLimit(20);
        this.sequenceMinimumFilterText.setText("");
        GridData sequenceMinimumFilterTextData = new GridData(4, 0x1000000, false, false, 2, 1);
        this.sequenceMinimumFilterText.setLayoutData((Object)sequenceMinimumFilterTextData);
        Label sequenceMinimumFilterExplanationLabel = new Label(innerFilterTopComposite, 0);
        sequenceMinimumFilterExplanationLabel.setText("Terms that do not appear in at least this many sequences\nwill be ignored.");
        GridData sequenceMinimumFilterExplanationLabelData = new GridData(16384, 0x1000000, true, false, 2, 1);
        sequenceMinimumFilterExplanationLabelData.horizontalIndent = defaultHorizontalIndent;
        sequenceMinimumFilterExplanationLabel.setLayoutData((Object)sequenceMinimumFilterExplanationLabelData);
        this.alphaLabel = new Label(innerFilterTopComposite, 0);
        this.alphaLabel.setText("Distance decay value (\u03b1): ");
        GridData alphaLabelData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.alphaLabel.setLayoutData((Object)alphaLabelData);
        this.alphaSpinner = new Spinner(innerFilterTopComposite, 2048);
        this.alphaSpinner.setDigits(4);
        this.alphaSpinner.setMinimum(1);
        this.alphaSpinner.setMaximum(10000);
        this.alphaSpinner.setIncrement(1);
        this.alphaSpinner.setSelection(6000);
        GridData alphaSpinnerData = new GridData(16384, 0x1000000, false, false, 2, 1);
        this.alphaSpinner.setLayoutData((Object)alphaSpinnerData);
        Label alphaExplanationLabel = new Label(innerFilterTopComposite, 0);
        alphaExplanationLabel.setText("A low value will make nodes with many distant leaves have\na lower score than a node with fewer, closer leaves");
        GridData alphaExplanationLabelData = new GridData(16384, 0x1000000, true, false, 2, 1);
        alphaExplanationLabelData.horizontalIndent = defaultHorizontalIndent;
        alphaExplanationLabel.setLayoutData((Object)alphaExplanationLabelData);
        this.nodeScoreThresholdLabel = new Label(innerFilterTopComposite, 0);
        this.nodeScoreThresholdLabel.setText("Node score threshold: ");
        GridData nodeScoreThresholdLabelData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.nodeScoreThresholdLabel.setLayoutData((Object)nodeScoreThresholdLabelData);
        this.nodeScoreThresholdText = new Text(innerFilterTopComposite, 2048);
        this.nodeScoreThresholdText.setTextLimit(20);
        this.nodeScoreThresholdText.setText("");
        GridData nodeScoreThresholdTextData = new GridData(4, 0x1000000, false, false, 2, 1);
        this.nodeScoreThresholdText.setLayoutData((Object)nodeScoreThresholdTextData);
        Label nodeScoreExplanationLabel = new Label(innerFilterTopComposite, 0);
        nodeScoreExplanationLabel.setText("Minimum score a node needs to be displayed on the graph.");
        GridData nodeScoreExplanationLabelData = new GridData(16384, 0x1000000, true, false, 2, 1);
        nodeScoreExplanationLabelData.horizontalIndent = defaultHorizontalIndent;
        nodeScoreExplanationLabel.setLayoutData((Object)nodeScoreExplanationLabelData);
        this.depthLabel = new Label(innerFilterTopComposite, 0);
        this.depthLabel.setText("Level: ");
        GridData depthLabelData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.depthLabel.setLayoutData((Object)depthLabelData);
        this.createLevelSelectionGroup(innerFilterTopComposite, 0);
        GridData selectionData = new GridData(16384, 0x1000000, true, false, 1, 1);
        this.levelSelectionGroup.setLayoutData((Object)selectionData);
        Label labelLevelHelp = new Label(innerFilterTopComposite, 0);
        labelLevelHelp.setText("Filter by level:\n    - All levels: print all levels.\n    - Select level: specify restriction by GO depth.\n        - Up to this level: print data from level 1 up to selected level.\n        - Only this level: print data only from this level.");
        labelLevelHelp.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
    }

    private void createChartTypeGroup(Composite parent, int style) {
        this.chartTypeGroup = new Group(parent, style);
        this.chartTypeGroup.setText("Chart type");
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        this.chartTypeGroup.setLayout((Layout)layout);
        this.barChartRadio = new Button((Composite)this.chartTypeGroup, 16);
        this.barChartRadio.setText("Bar chart");
        this.barChartRadio.setSelection(true);
        this.pieChartRadio = new Button((Composite)this.chartTypeGroup, 16);
        this.pieChartRadio.setText("Pie chart");
    }

    private void createBarChartOptionsGroup(Composite parent, int style) {
        this.barChartOptionsGroup = new Group(parent, style);
        this.barChartOptionsGroup.setText("Bar chart options");
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        this.barChartOptionsGroup.setLayout((Layout)layout);
        this.buttonOrientationVertical = new Button((Composite)this.barChartOptionsGroup, 16);
        this.buttonOrientationVertical.setText("Vertical layout");
        this.buttonOrientationVertical.setSelection(true);
        this.buttonOrientationHorizontal = new Button((Composite)this.barChartOptionsGroup, 16);
        this.buttonOrientationHorizontal.setText("Horizontal layout");
        this.buttonOrientationHorizontal.setSelection(false);
    }

    private void createGraphicTypeGroup(Composite parent, int style) {
        this.graphicTypeGroup = new Group(parent, style);
        this.graphicTypeGroup.setText("Graphic type");
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        this.graphicTypeGroup.setLayout((Layout)layout);
        this.type2DButton = new Button((Composite)this.graphicTypeGroup, 16);
        this.type2DButton.setText("2D graphic");
        this.type2DButton.setSelection(true);
        this.type3DButton = new Button((Composite)this.graphicTypeGroup, 16);
        this.type3DButton.setText("3D graphic");
    }

    private void createGraphColorGroup(Composite parent, int style) {
        this.graphColorGroup = new Group(parent, style);
        this.graphColorGroup.setText("Graph color");
        GridLayout layout = new GridLayout(2, true);
        layout.horizontalSpacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        this.graphColorGroup.setLayout((Layout)layout);
        this.buttonColor = new Button((Composite)this.graphColorGroup, 8);
        this.buttonColor.setText("Select");
        Color barColor = new Color((Device)this.graphColorGroup.getDisplay(), 255, 80, 80);
        this.labelColor = new Label((Composite)this.graphColorGroup, 0);
        this.labelColor.setBackground(barColor);
        GridData layoutData = new GridData();
        layoutData.heightHint = 20;
        layoutData.widthHint = 20;
        this.labelColor.setLayoutData((Object)layoutData);
        barColor.dispose();
        this.buttonColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(StatisticsByDepthDialog.this.graphColorGroup.getShell());
                dlg.setRGB(StatisticsByDepthDialog.this.labelColor.getBackground().getRGB());
                dlg.setText("Graph Color");
                RGB rgb = dlg.open();
                if (rgb != null) {
                    StatisticsByDepthDialog.this.rgbRow = rgb;
                    Color colorImage = new Color((Device)StatisticsByDepthDialog.this.graphColorGroup.getDisplay(), StatisticsByDepthDialog.this.rgbRow);
                    StatisticsByDepthDialog.this.labelColor.setBackground(colorImage);
                    colorImage.dispose();
                }
            }
        });
    }

    private void createOutputTypeGroup(Composite parent, int style) {
        this.outputGroup = new Group(parent, style);
        this.outputGroup.setText("Ouput type");
        GridLayout layout = new GridLayout(2, true);
        layout.horizontalSpacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        this.outputGroup.setLayout((Layout)layout);
        this.buttonOutputTerms = new Button((Composite)this.outputGroup, 16);
        this.buttonOutputTerms.setText("GO terms count");
        this.buttonOutputTerms.setSelection(true);
        this.buttonOutputCount = new Button((Composite)this.outputGroup, 16);
        this.buttonOutputCount.setText("Sequence count by level");
    }

    private void createLevelSelectionGroup(Composite parent, int style) {
        this.levelSelectionGroup = new Composite(parent, style);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        this.levelSelectionGroup.setLayout((Layout)layout);
        this.buttonLevelAll = new Button(this.levelSelectionGroup, 16);
        this.buttonLevelAll.setText("All levels");
        this.buttonLevelAll.setSelection(true);
        this.buttonLevelAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsByDepthDialog.this.activateLevelSelection(false);
            }
        });
        this.buttonLevelSelect = new Button(this.levelSelectionGroup, 16);
        this.buttonLevelSelect.setText("Select level");
        this.buttonLevelSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsByDepthDialog.this.activateLevelSelection(true);
            }
        });
        Composite groupLevelOptions = new Composite(this.levelSelectionGroup, 0);
        groupLevelOptions.setLayout((Layout)new GridLayout(1, true));
        GridData layoutData = new GridData();
        layoutData.horizontalIndent = 40;
        groupLevelOptions.setLayoutData((Object)layoutData);
        this.depthSpinner = new Spinner(groupLevelOptions, 2048);
        this.depthSpinner.setDigits(0);
        this.depthSpinner.setMinimum(1);
        this.depthSpinner.setMaximum(15);
        this.depthSpinner.setIncrement(1);
        this.depthSpinner.setSelection(0);
        layoutData = new GridData();
        layoutData.minimumWidth = 40;
        layoutData.widthHint = 40;
        this.depthSpinner.setLayoutData((Object)layoutData);
        this.buttonLevelUpTo = new Button(groupLevelOptions, 16);
        this.buttonLevelUpTo.setText("Up to this level");
        this.buttonLevelUpTo.setSelection(true);
        this.buttonLevelThis = new Button(groupLevelOptions, 16);
        this.buttonLevelThis.setText("Only this level");
        this.activateLevelSelection(this.buttonLevelSelect.getSelection());
    }

    private void activateLevelSelection(boolean activate) {
        this.depthSpinner.setEnabled(activate);
        this.buttonLevelThis.setEnabled(activate);
        this.buttonLevelUpTo.setEnabled(activate);
    }

    protected void okPressed() {
        GOTerm.GODomain termType = GOTerm.GODomain.getInstance(this.domainCombo.getText());
        String columnName = this.goColumnCombo.getText();
        boolean selectLevelChart = this.buttonLevelSelect.getSelection();
        int minimumSequences = 0;
        String outputType = OUTPUT_TYPE_COUNT;
        if (this.buttonOutputTerms.getSelection()) {
            outputType = OUTPUT_TYPE_TERMS;
        }
        boolean onlyThisLevel = false;
        if (selectLevelChart && this.buttonLevelThis.getSelection()) {
            onlyThisLevel = true;
        }
        try {
            minimumSequences = Integer.parseInt(this.sequenceMinimumFilterText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        double alpha = 0.6;
        try {
            alpha = Double.parseDouble(this.alphaSpinner.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        double nodeScoreThreshold = 0.0;
        try {
            nodeScoreThreshold = Double.parseDouble(this.nodeScoreThresholdText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int maximumDepth = GOTerm.MAX_DEPTH;
        try {
            if (selectLevelChart) {
                maximumDepth = Integer.parseInt(this.depthSpinner.getText());
            } else {
                selectLevelChart = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        IViewPart viewPart = null;
        try {
            viewPart = WorkspaceUtils.showView((String)"com.biotechvana.gydbpro.views.StatsView");
        }
        catch (PartInitException exception) {
            exception.printStackTrace();
            return;
        }
        if (viewPart == null) {
            return;
        }
        this.statsView = (StatsView)viewPart;
        try {
            if (outputType == OUTPUT_TYPE_COUNT) {
                this.generateDepthChart((List)this.csvEditor.getModel(), this.csvEditor.getColumnIndexForName(columnName), termType, minimumSequences, alpha, nodeScoreThreshold, maximumDepth);
            } else {
                this.generateTermsChart((List)this.csvEditor.getModel(), this.csvEditor.getColumnIndexForName(columnName), termType, minimumSequences, alpha, nodeScoreThreshold, maximumDepth, onlyThisLevel);
            }
        }
        catch (InvocationTargetException exception) {
            exception.printStackTrace();
        }
        catch (InterruptedException exception) {
            exception.printStackTrace();
        }
        super.okPressed();
    }

    private void generateDepthChart(final List<List<String>> model, final int columnIndex, final GOTerm.GODomain termType, final int minimumSequences, final double alpha, final double nodeScoreThreshold, final int maximumDepth) throws InvocationTargetException, InterruptedException {
        final StatisticsModel statsModel = new StatisticsModel();
        if (this.barChartRadio.getSelection()) {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CategoryDataset categoryDataset = statsModel.generateGODepthDataset(model, columnIndex, termType, minimumSequences, alpha, nodeScoreThreshold, maximumDepth, monitor);
                    if (categoryDataset.getColumnCount() > 1) {
                        StatisticsByDepthDialog.this.statsView.addBarGraph("Category", "Gene Ontology sequences per level (" + termType.getPrettyName() + ", max. level " + maximumDepth + ")", categoryDataset, "Level", "Sequences", StatisticsByDepthDialog.this.plotOrientation, false, true, false, StatisticsByDepthDialog.this.type3DButton.getSelection(), StatisticsByDepthDialog.this.rgbRow);
                    } else {
                        MessageDialog.openInformation((Shell)StatisticsByDepthDialog.this.getShell(), (String)"Statistics", (String)"No GO terms matching the specified criteria were found");
                    }
                }
            });
        } else if (this.pieChartRadio.getSelection()) {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    PieDataset pieDataset = statsModel.generateGODepthPieDataset(model, columnIndex, termType, minimumSequences, alpha, nodeScoreThreshold, maximumDepth, monitor);
                    if (pieDataset.getItemCount() > 1) {
                        StatisticsByDepthDialog.this.statsView.addPieGraph("Category", pieDataset, "Gene Ontology sequences per level (" + termType.getPrettyName() + ")", StatisticsByDepthDialog.this.pieLegend, true, false, StatisticsByDepthDialog.this.type3DButton.getSelection());
                    } else {
                        MessageDialog.openInformation((Shell)StatisticsByDepthDialog.this.getShell(), (String)"Statistics", (String)"No GO terms matching the specified criteria were found");
                    }
                }
            });
        }
    }

    private void generateTermsChart(final List<List<String>> model, final int columnIndex, final GOTerm.GODomain termType, final int minimumSequences, final double alpha, final double nodeScoreThreshold, final int maximumDepth, final boolean onlyThisLevel) throws InvocationTargetException, InterruptedException {
        final StatisticsModel statsModel = new StatisticsModel();
        if (this.barChartRadio.getSelection()) {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CategoryDataset categoryDataset = statsModel.generateGOTermsDataset(model, columnIndex, termType, minimumSequences, alpha, nodeScoreThreshold, maximumDepth, onlyThisLevel, monitor);
                    if (categoryDataset.getColumnCount() > 1) {
                        Object chartTitle = "";
                        chartTitle = onlyThisLevel ? "Gene Ontology terms distribution (" + termType.getPrettyName() + ", level " + maximumDepth + ")" : "Gene Ontology terms distribution (" + termType.getPrettyName() + ", max. level " + maximumDepth + ")";
                        StatisticsByDepthDialog.this.statsView.addBarGraph("Category", (String)chartTitle, categoryDataset, "Term name", "Sequences", StatisticsByDepthDialog.this.plotOrientation, false, true, false, StatisticsByDepthDialog.this.type3DButton.getSelection(), StatisticsByDepthDialog.this.rgbRow);
                    } else {
                        MessageDialog.openInformation((Shell)StatisticsByDepthDialog.this.getShell(), (String)"Statistics", (String)"No GO terms matching the specified criteria were found");
                    }
                }
            });
        } else if (this.pieChartRadio.getSelection()) {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    PieDataset pieDataset = statsModel.generateGOTermsPieDataset(model, columnIndex, termType, minimumSequences, alpha, nodeScoreThreshold, maximumDepth, onlyThisLevel, monitor);
                    if (pieDataset.getItemCount() > 1) {
                        StatisticsByDepthDialog.this.statsView.addPieGraph("Category", pieDataset, "Gene Ontology terms distribution (" + termType.getPrettyName() + ", level " + maximumDepth + ")", StatisticsByDepthDialog.this.pieLegend, true, false, StatisticsByDepthDialog.this.type3DButton.getSelection());
                    } else {
                        MessageDialog.openInformation((Shell)StatisticsByDepthDialog.this.getShell(), (String)"Statistics", (String)"No GO terms matching the specified criteria were found");
                    }
                }
            });
        }
    }

    private void addListeners() {
        this.buttonOrientationHorizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsByDepthDialog.this.switchOrientation();
            }
        });
        this.buttonOrientationVertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsByDepthDialog.this.switchOrientation();
            }
        });
        this.barChartRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsByDepthDialog.this.switchType();
            }
        });
        this.pieChartRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsByDepthDialog.this.switchType();
            }
        });
        VerifyListener positiveFloatingPointVerifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (StatisticsByDepthDialog.this.nodeScoreThresholdText.getText().indexOf(46) == -1) {
                    if (!event.text.matches("[0-9\\.]*")) {
                        event.doit = false;
                    }
                } else if (!event.text.matches("[0-9]*")) {
                    event.doit = false;
                }
            }
        };
        VerifyListener naturalPointVerifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (!event.text.matches("[0-9]*")) {
                    event.doit = false;
                }
            }
        };
        this.sequenceMinimumFilterText.addVerifyListener(naturalPointVerifyListener);
        this.nodeScoreThresholdText.addVerifyListener(positiveFloatingPointVerifyListener);
    }

    private void switchOrientation() {
        this.plotOrientation = PlotOrientation.VERTICAL;
        if (this.buttonOrientationHorizontal.getSelection()) {
            this.plotOrientation = PlotOrientation.HORIZONTAL;
        }
    }

    private void switchType() {
        this.buttonOrientationHorizontal.setEnabled(true);
        this.buttonOrientationVertical.setEnabled(true);
        this.buttonColor.setEnabled(true);
        if (this.pieChartRadio.getSelection()) {
            this.buttonOrientationHorizontal.setEnabled(false);
            this.buttonOrientationVertical.setEnabled(false);
            this.buttonColor.setEnabled(false);
            this.labelColor.setBackground(null);
        }
    }
}

