/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvSplitColumnsRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvSplitInvalidColumnCountException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CsvSplitColumnDialog
extends TitleAreaDialog {
    public static final String TITLE = "Split columns";
    public static final int CREATE_NEW = 0;
    public static final int UPDATE = 1;
    public static final int NONE = 2;
    private CSVEditor csvEditor;
    private Combo comboFields;
    private Text textSeparator;
    private int column;
    private char separator = (char)124;

    public CsvSplitColumnDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    public void create() {
        super.create();
        this.setTitle(TITLE);
        this.setMessage("Split selected column using a separator character.");
        this.getButton(0).setEnabled(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        parent.getShell().setText(TITLE);
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        composite.setLayout((Layout)layout);
        Label labelColumns = new Label(composite, 0);
        labelColumns.setText("Split column: ");
        this.comboFields = new Combo(composite, 12);
        this.comboFields.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false));
        GridData layoutData = new GridData();
        layoutData.widthHint = 200;
        this.comboFields.setLayoutData((Object)layoutData);
        Label labelSeparator = new Label(composite, 0);
        labelSeparator.setText("Separator character: ");
        this.textSeparator = new Text(composite, 133124);
        this.textSeparator.setText("|");
        this.textSeparator.setTextLimit(1);
        layoutData = new GridData();
        layoutData.widthHint = 50;
        this.textSeparator.setLayoutData((Object)layoutData);
        this.addListeners();
        return compositeParent;
    }

    protected void okPressed() {
        if (!this.validation()) {
            return;
        }
        try {
            this.run();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CsvSplitInvalidColumnCountException) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)((CsvSplitInvalidColumnCountException)e.getCause()).getMessage());
                try {
                    this.csvEditor.getTable().select(((CsvSplitInvalidColumnCountException)e.getCause()).getRowIndex() - 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.csvEditor.getDebug()) {
                e.printStackTrace();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.okPressed();
    }

    private void addListeners() {
        this.comboFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvSplitColumnDialog.this.column = CsvSplitColumnDialog.this.comboFields.getSelectionIndex();
            }
        });
        this.textSeparator.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CsvSplitColumnDialog.this.validation();
                CsvSplitColumnDialog.this.separator = CsvSplitColumnDialog.this.textSeparator.getText().charAt(0);
            }
        });
    }

    private boolean validation() {
        this.getButton(0).setEnabled(false);
        this.setErrorMessage(null);
        if (this.comboFields.getSelectionIndex() == -1) {
            this.setErrorMessage("Must select a column for splitting");
            return false;
        }
        if (this.textSeparator.getText().isEmpty()) {
            this.setErrorMessage("Must enter a separator character");
            return false;
        }
        this.getButton(0).setEnabled(true);
        return true;
    }

    private void run() throws InvocationTargetException, InterruptedException {
        this.column = this.csvEditor.getColumnIndexForName(this.comboFields.getItem(this.comboFields.getSelectionIndex()));
        CsvSplitColumnsRunnable splitRunnable = new CsvSplitColumnsRunnable(this.csvEditor, this.column, this.separator, System.currentTimeMillis());
        new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)splitRunnable);
    }
}

