/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CsvSelectMultiHitDialog
extends TitleAreaDialog {
    private TableViewer tableViewer;
    private String[] headers;
    private List<List<String>> listRows;
    private List<String> selectedRow = null;
    private int subjectColumn;

    public CsvSelectMultiHitDialog(Shell parentShell, String[] headers, List<List<String>> listRows, int subjectColumn) {
        super(parentShell);
        this.headers = headers;
        this.listRows = listRows;
        this.subjectColumn = subjectColumn;
    }

    public void create() {
        super.create();
        this.setTitle("Select sequence");
        this.setMessage("Select hit from list");
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        parent.getShell().setText("Select sequence");
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        composite.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(composite, 68356);
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 600;
        layoutData.heightHint = 200;
        this.tableViewer.getTable().setLayoutData((Object)layoutData);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.createColumns();
        this.addProviders();
        this.tableViewer.setInput(this.listRows);
        return compositeParent;
    }

    private void createColumns() {
        TableViewerColumn col = new TableViewerColumn(this.tableViewer, 0);
        col.getColumn().setText("Index");
        col.getColumn().setMoveable(false);
        col.getColumn().setWidth(30);
        String[] stringArray = this.headers;
        int n = this.headers.length;
        int n2 = 0;
        while (n2 < n) {
            String h = stringArray[n2];
            col = new TableViewerColumn(this.tableViewer, 0);
            col.getColumn().setText(h);
            col.getColumn().setMoveable(false);
            col.getColumn().setWidth(100);
            ++n2;
        }
    }

    private void addProviders() {
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList tableRow = (ArrayList)inputElement;
                return tableRow.toArray(new Object[tableRow.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                ArrayList tableRow = (ArrayList)element;
                return ((String)tableRow.get(columnIndex)).replace("<br>", "\n");
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
    }

    protected void okPressed() {
        int selectedIndex = this.tableViewer.getTable().getSelectionIndex();
        this.selectedRow = (ArrayList)this.tableViewer.getElementAt(selectedIndex);
        super.okPressed();
    }

    public List<String> getSelectedRow() {
        return this.selectedRow;
    }
}

