/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csvUtils.WorksheetUtils;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvCheckRowsRunnable;
import com.biotechvana.csveditor.model.CsvEditor.CsvEditorUtils2;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CsvSelectMultiDialog
extends Dialog {
    public final String TITLE = "Select by multiple criteria";
    private CSVEditor csvEditor;
    private CsvEditorUtils2 csvEditorUtils;
    private List<Label> listLabels = new ArrayList<Label>();
    private List<Combo> listColumns = new ArrayList<Combo>();
    private List<Combo> listOperators = new ArrayList<Combo>();
    private List<Text> listValues = new ArrayList<Text>();
    private List<Integer> listIndices = new ArrayList<Integer>();
    private Map<Combo, Combo> mapCombo = new HashMap<Combo, Combo>();
    private Map<Combo, Text> mapText = new HashMap<Combo, Text>();
    private Composite composite;
    private Button radioOr;
    private Button radioAND;
    public static final String OPERATOR_STRING_CONTAINS = "Contains";
    public static final String OPERATOR_STRING_NOT_CONTAINS = "Not contains";
    public static final String OPERATOR_STRING_EQUALS = "Equals";
    public static final String OPERATOR_STRING_DIFFERENT = "Is different";
    public static final String OPERATOR_NUMBER_GREATER = ">";
    public static final String OPERATOR_NUMBER_LOWER = "<";
    public static final String OPERATOR_NUMBER_GREATER_OR_EQUAL = ">=";
    public static final String OPERATOR_NUMBER_LOWER_OR_EQUAL = "<=";
    public static final String OPERATOR_NUMBER_EQUAL = "=";
    public static final String OPERATOR_NUMBER_DISTINCT = "!=";
    public final String[] OPERATORS_STRING = new String[]{"Contains", "Not contains", "Equals", "Is different"};
    public final String[] OPERATORS_NUMBER = new String[]{">", "<", ">=", "<=", "=", "!="};
    private NumberFormat nf = NumberFormat.getInstance();
    private Composite canvas;
    private int criteriaCount = 0;

    public CsvSelectMultiDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
        this.csvEditorUtils = new CsvEditorUtils2(csvEditor);
    }

    public static void main(String[] args) {
        if (CsvSelectMultiDialog.compareTo(OPERATOR_NUMBER_GREATER_OR_EQUAL, "5,91E-05", "0.05", "e-value")) {
            System.out.println("Cumple");
        } else {
            System.out.println("No cumple");
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Select by multiple criteria");
        compositeParent.setLayoutData((Object)new GridData(1808));
        this.composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(1, false);
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite sc = new ScrolledComposite(this.composite, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.canvas = new Composite((Composite)sc, 0);
        this.canvas.setLayout((Layout)new GridLayout(4, false));
        this.addRow(this.canvas, 0, 1);
        sc.setContent((Control)this.canvas);
        this.canvas.setSize(this.canvas.computeSize(-1, -1));
        ((GridData)sc.getLayoutData()).widthHint = 500;
        ((GridData)sc.getLayoutData()).heightHint = 300;
        Button button = new Button(this.composite, 8);
        button.setText("+ Add criteria");
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvSelectMultiDialog.this.addRow(CsvSelectMultiDialog.this.canvas, 0, 1);
            }
        });
        Group criteriaGrid = this.createGroupMode(this.composite, 0);
        criteriaGrid.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)criteriaGrid.getLayoutData()).verticalIndent = 20;
        return this.composite;
    }

    private void addRow(Composite parent, int style, int rows) {
        int i = 0;
        while (i < rows) {
            Label labelCol1 = new Label(parent, 0);
            labelCol1.setText("Criterion " + (this.criteriaCount + 1) + ":");
            ++this.criteriaCount;
            GridData layoutData = new GridData();
            labelCol1.setLayoutData((Object)layoutData);
            Combo comboColumns = new Combo(parent, 8);
            comboColumns.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true));
            layoutData = new GridData();
            layoutData.widthHint = 120;
            comboColumns.setLayoutData((Object)layoutData);
            Combo comboOperator = new Combo(parent, 8);
            layoutData = new GridData();
            layoutData.widthHint = 120;
            comboOperator.setLayoutData((Object)layoutData);
            Text textValue = new Text(parent, 2052);
            layoutData = new GridData();
            layoutData.widthHint = 160;
            textValue.setLayoutData((Object)layoutData);
            this.listLabels.add(labelCol1);
            this.listColumns.add(comboColumns);
            this.listOperators.add(comboOperator);
            this.listValues.add(textValue);
            this.mapCombo.put(comboColumns, comboOperator);
            this.mapText.put(comboColumns, textValue);
            comboColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Combo c = (Combo)e.getSource();
                    CsvSelectMultiDialog.this.updateDataTypeCombo(c, CsvSelectMultiDialog.this.mapCombo.get(c));
                }
            });
            ++i;
        }
        parent.setSize(parent.computeSize(-1, -1));
    }

    private Group createGroupMode(Composite parent, int style) {
        Group composite = new Group(parent, style);
        composite.setText("Search mode:");
        composite.setLayout((Layout)new GridLayout(2, true));
        GridData layoutData = new GridData(1808);
        this.radioOr = new Button((Composite)composite, 16);
        this.radioOr.setSelection(true);
        this.radioOr.setText("OR");
        this.radioOr.setLayoutData((Object)layoutData);
        this.radioAND = new Button((Composite)composite, 16);
        this.radioAND.setText("AND");
        this.radioOr.setLayoutData((Object)layoutData);
        return composite;
    }

    protected void okPressed() {
        if (!this.validate()) {
            return;
        }
        try {
            this.csvEditor.checkAllRows(false, false, false);
        }
        catch (Exception e1) {
            return;
        }
        try {
            this.run();
        }
        catch (InvocationTargetException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Select by multiple criteria", (String)("Failed selecting rows:" + e.getMessage()));
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.okPressed();
    }

    private void run() throws InvocationTargetException, InterruptedException {
        this.listIndices = new ArrayList<Integer>();
        new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                CsvSelectMultiDialog.this.getMatchingIndices(monitor);
            }
        });
        this.csvEditor.checkAllRows(false, false, false);
        CsvCheckRowsRunnable checkRunnable = new CsvCheckRowsRunnable(this.csvEditor, this.listIndices, true);
        new ProgressMonitorDialog(this.getShell()).run(false, false, (IRunnableWithProgress)checkRunnable);
        new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                CsvSelectMultiDialog.this.csvEditor.selectRows(CsvSelectMultiDialog.this.listIndices, monitor);
            }
        });
        if (this.listIndices.size() != 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Select by multiple criteria", (String)("Rows selected: " + this.listIndices.size()));
        }
    }

    private void getMatchingIndices(IProgressMonitor monitor) throws InterruptedException {
        ArrayList<Boolean> listBooleanRow = null;
        Table csvTable = this.csvEditor.getTable();
        TableItem[] tableItems = csvTable.getItems();
        int tableLength = tableItems.length;
        monitor.beginTask("Multiple search", tableLength);
        int i = 0;
        while (i < tableLength) {
            listBooleanRow = new ArrayList<Boolean>();
            for (Map.Entry<Combo, Combo> comboKey : this.mapCombo.entrySet()) {
                Combo comboColumns = comboKey.getKey();
                Combo comboOperator = comboKey.getValue();
                Text textValue = this.mapText.get(comboColumns);
                if (comboColumns.getSelectionIndex() == -1 || comboOperator.getSelectionIndex() == -1) continue;
                String columnName = comboColumns.getItem(comboColumns.getSelectionIndex());
                int columnModelIndex = this.csvEditor.getColumnIndexForName(columnName);
                String columnOperator = comboOperator.getItem(comboOperator.getSelectionIndex());
                String textVal = textValue.getText().toString();
                String valueColumn = tableItems[i].getText(columnModelIndex);
                if (CsvSelectMultiDialog.compareTo(columnOperator, valueColumn, textVal, columnName)) {
                    listBooleanRow.add(true);
                    continue;
                }
                listBooleanRow.add(false);
            }
            boolean isValid = true;
            if (this.radioOr.getSelection()) {
                isValid = false;
                var9_12 = listBooleanRow.iterator();
                while (var9_12.hasNext()) {
                    boolean b = (Boolean)var9_12.next();
                    if (!b) continue;
                    isValid = true;
                }
            } else {
                isValid = true;
                var9_12 = listBooleanRow.iterator();
                while (var9_12.hasNext()) {
                    boolean b = (Boolean)var9_12.next();
                    if (b) continue;
                    isValid = false;
                }
            }
            if (isValid) {
                this.listIndices.add(i);
            }
            monitor.worked(1);
            monitor.subTask("Reading row " + this.nf.format(i + 1) + " of " + this.nf.format(tableLength) + " total rows");
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ++i;
        }
        monitor.done();
    }

    private boolean validate() {
        for (Map.Entry<Combo, Combo> comboKey : this.mapCombo.entrySet()) {
            Combo comboColumns = comboKey.getKey();
            Combo comboOperator = comboKey.getValue();
            Text textValue = this.mapText.get(comboColumns);
            if (comboColumns.getSelectionIndex() == -1) continue;
            if (comboColumns.getSelectionIndex() != -1 && comboOperator.getSelectionIndex() == -1) {
                return false;
            }
            if (textValue.getText().equals("")) continue;
            String pattern = "(?i).*[abcdfghijklmnopqrstuvwxyz].*";
            if (!(textValue.getText().toString().matches("(?i).*[abcdfghijklmnopqrstuvwxyz].*") ? this.dataTypeCombo(comboColumns) != 0 : this.dataTypeCombo(comboColumns) != 1)) continue;
            return false;
        }
        return true;
    }

    private String[] getItemsOperators(int type) {
        ArrayList<String> listNames = new ArrayList<String>();
        if (type == 1) {
            listNames.addAll(Arrays.asList(this.OPERATORS_NUMBER));
        } else if (type == 0) {
            listNames.addAll(Arrays.asList(this.OPERATORS_STRING));
        }
        return listNames.toArray(new String[listNames.size()]);
    }

    private void updateDataTypeCombo(Combo comboColumns, Combo comboOperator) {
        comboOperator.setItems(this.getItemsOperators(this.dataTypeCombo(comboColumns)));
    }

    private int dataTypeCombo(Combo comboColumns) {
        String columnName = comboColumns.getItem(comboColumns.getSelectionIndex());
        int columnModelIndex = this.csvEditor.getColumnIndexForName(columnName);
        int dataType = this.csvEditorUtils.detectDataType(columnModelIndex);
        return dataType;
    }

    private static boolean compareTo(String operator, String valueColumn, String textVal, String columnName) {
        boolean isValid = false;
        if (operator.equals(OPERATOR_NUMBER_DISTINCT) || operator.equals(OPERATOR_NUMBER_EQUAL) || operator.equals(OPERATOR_NUMBER_GREATER) || operator.equals(OPERATOR_NUMBER_GREATER_OR_EQUAL) || operator.equals(OPERATOR_NUMBER_LOWER) || operator.equals(OPERATOR_NUMBER_LOWER_OR_EQUAL)) {
            textVal = textVal.replace(",", ".");
            valueColumn = valueColumn.replace(",", ".");
        }
        if (operator.equals(OPERATOR_STRING_CONTAINS)) {
            if (textVal.equals("")) {
                if (valueColumn.equals("")) {
                    isValid = true;
                }
            } else if (valueColumn.indexOf(textVal) != -1) {
                isValid = true;
            }
        } else if (operator.equals(OPERATOR_STRING_NOT_CONTAINS)) {
            if (textVal.equals("")) {
                if (!valueColumn.equals("")) {
                    isValid = true;
                }
            } else if (valueColumn.indexOf(textVal) == -1) {
                isValid = true;
            }
        } else if (operator.equals(OPERATOR_STRING_EQUALS)) {
            if (valueColumn.equals(textVal)) {
                isValid = true;
            }
        } else if (operator.equals(OPERATOR_STRING_DIFFERENT)) {
            if (!valueColumn.equals(textVal)) {
                isValid = true;
            }
        } else if (operator.equals(OPERATOR_NUMBER_EQUAL)) {
            if (!valueColumn.equals("")) {
                try {
                    double cell = Double.parseDouble(WorksheetUtils.parseColValueAuto((String)columnName, (String)valueColumn));
                    double user = Double.parseDouble(textVal);
                    if (cell == user) {
                        isValid = true;
                    }
                }
                catch (Exception ex) {
                    isValid = false;
                }
            } else if (textVal.equals("")) {
                isValid = true;
            }
        } else if (operator.equals(OPERATOR_NUMBER_DISTINCT)) {
            if (!valueColumn.equals("")) {
                try {
                    double cell = Double.parseDouble(WorksheetUtils.parseColValueAuto((String)columnName, (String)valueColumn));
                    double user = Double.parseDouble(textVal);
                    if (cell != user) {
                        isValid = true;
                    }
                }
                catch (Exception cell) {}
            } else if (!textVal.equals("")) {
                isValid = true;
            }
        } else if (operator.equals(OPERATOR_NUMBER_GREATER)) {
            if (!valueColumn.equals("") && !textVal.equals("")) {
                try {
                    double cell = Double.parseDouble(WorksheetUtils.parseColValueAuto((String)columnName, (String)valueColumn));
                    double user = Double.parseDouble(textVal);
                    if (cell > user) {
                        isValid = true;
                    }
                }
                catch (Exception cell) {}
            }
        } else if (operator.equals(OPERATOR_NUMBER_LOWER)) {
            if (!valueColumn.equals("") && !textVal.equals("")) {
                try {
                    double cell = Double.parseDouble(WorksheetUtils.parseColValueAuto((String)columnName, (String)valueColumn));
                    double user = Double.parseDouble(textVal);
                    if (cell < user) {
                        isValid = true;
                    }
                }
                catch (Exception cell) {}
            }
        } else if (operator.equals(OPERATOR_NUMBER_LOWER_OR_EQUAL)) {
            if (!valueColumn.equals("") && !textVal.equals("")) {
                try {
                    double cell = Double.parseDouble(WorksheetUtils.parseColValueAuto((String)columnName, (String)valueColumn));
                    double user = Double.parseDouble(textVal);
                    if (cell <= user) {
                        isValid = true;
                    }
                }
                catch (Exception cell) {}
            }
        } else if (operator.equals(OPERATOR_NUMBER_GREATER_OR_EQUAL) && !valueColumn.equals("") && !textVal.equals("")) {
            try {
                double cell = Double.parseDouble(WorksheetUtils.parseColValueAuto((String)columnName, (String)valueColumn));
                double user = Double.parseDouble(textVal);
                if (cell >= user) {
                    isValid = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isValid;
    }

    protected boolean isResizable() {
        return true;
    }
}

