/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.views.MetabolicPathsView;
import com.biotechvana.e3utils.WorkspaceUtils;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;

public class CsvMetabolicPathwaysDialog
extends TitleAreaDialog {
    public static final String TITLE = "Metabolic pathways";
    private CSVEditor csvEditor;
    private Combo comboColumnName;
    private Combo comboColumnEnzyme;
    private Combo comboColumnEvidence;
    private Combo comboColumnSpecies;
    private Button colorOption1;
    private Button colorOption2;
    private String[] visibleColumns;

    public CsvMetabolicPathwaysDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData layoutData = new GridData();
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        composite.setLayout((Layout)layout);
        this.visibleColumns = this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true);
        Label labelNames = new Label(composite, 0);
        labelNames.setText("Sequence names column:");
        this.comboColumnName = new Combo(composite, 2056);
        this.comboColumnName.setItems(this.visibleColumns);
        Label labelEnzyme = new Label(composite, 0);
        labelEnzyme.setText("Enzyme codes column:");
        this.comboColumnEnzyme = new Combo(composite, 2056);
        this.comboColumnEnzyme.setItems(this.visibleColumns);
        Label labelEvidence = new Label(composite, 0);
        labelEvidence.setText("Evidence codes column:");
        this.comboColumnEvidence = new Combo(composite, 2056);
        this.comboColumnEvidence.setItems(this.visibleColumns);
        Label labelSpecies = new Label(composite, 0);
        labelSpecies.setText("Species column:");
        this.comboColumnSpecies = new Combo(composite, 2056);
        this.comboColumnSpecies.setItems(this.visibleColumns);
        this.comboColumnSpecies.add("", 0);
        this.comboColumnSpecies.setToolTipText("Use Species Column to filter Pathways. Unselct this option if you do not want to use Speices as a filter.");
        Group groupOptions = new Group(composite, 2048);
        groupOptions.setText("Coloring options");
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        groupOptions.setLayoutData((Object)layoutData);
        groupOptions.setLayout((Layout)new FillLayout(512));
        this.colorOption1 = new Button((Composite)groupOptions, 16);
        this.colorOption1.setText("Option 1: assign colors using Evidence Code weights if present in this worksheet. \nEvidece Code weight are defined in \"Preferences->Evidence code weights\".");
        this.colorOption1.setSelection(true);
        this.colorOption2 = new Button((Composite)groupOptions, 16);
        this.colorOption2.setText("Option 2: color all Enzyme Codes present in this annotation worksheet in all maps.");
        this.initDialog();
        this.autodetectColumns();
        return compositeParent;
    }

    private void initDialog() {
        this.getShell().setText(TITLE);
        this.setTitle(TITLE);
        this.setMessage("Select required columns for pathway calculation");
    }

    private void autodetectColumns() {
        int speciesIndex;
        int evidenceIndex;
        int enzymeIndex;
        int sequenceIndex = this.getIndexByName("Sequence");
        if (sequenceIndex != -1) {
            this.comboColumnName.select(sequenceIndex);
        }
        if ((enzymeIndex = this.getIndexByName("Enzyme codes")) != -1) {
            this.comboColumnEnzyme.select(enzymeIndex);
        }
        if ((evidenceIndex = this.getIndexByName("Evidence codes")) != -1) {
            this.comboColumnEvidence.select(evidenceIndex);
        }
        if ((speciesIndex = this.getIndexByName("Species")) != -1) {
            this.comboColumnSpecies.select(speciesIndex + 1);
        }
    }

    private int getIndexByName(String name) {
        int i = 0;
        while (i < this.visibleColumns.length) {
            if (this.visibleColumns[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int open() {
        return super.open();
    }

    public void create() {
        super.create();
    }

    public boolean validate() {
        this.setErrorMessage(null);
        if (this.comboColumnName.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)"Sequence name column is required");
            return false;
        }
        if (this.comboColumnEnzyme.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)"Enzyme codes column is required");
            return false;
        }
        return true;
    }

    protected void okPressed() {
        if (!this.validate()) {
            return;
        }
        try {
            IViewPart viewPart = WorkspaceUtils.showView((String)"com.biotechvana.gydbpro.views.MetabolicPathsView");
            MetabolicPathsView metabolicView = (MetabolicPathsView)viewPart;
            int colorMode = 2;
            colorMode = this.colorOption2.getSelection() ? 2 : 1;
            try {
                metabolicView.addData(this.csvEditor, this.getNameColumnIndex(), this.getEnzymeColumnIndex(), this.getEvidenceColumnIndex(), this.getSpeciesColumnIndex(), colorMode);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Methabolic pathways", (String)("Cannot open view: " + e.getMessage()));
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    public int getNameColumnIndex() {
        return this.comboColumnName.getSelectionIndex() + 2;
    }

    public int getEnzymeColumnIndex() {
        return this.comboColumnEnzyme.getSelectionIndex() + 2;
    }

    public int getEvidenceColumnIndex() {
        if (this.comboColumnEvidence.getSelectionIndex() == -1) {
            return -1;
        }
        return this.comboColumnEvidence.getSelectionIndex() + 2;
    }

    public int getSpeciesColumnIndex() {
        if (this.comboColumnSpecies.getSelectionIndex() <= 0) {
            return -1;
        }
        return this.comboColumnSpecies.getSelectionIndex() + 2 - 1;
    }
}

