/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.dialogs.csvEditor.ColumnTableComposite;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnJoin;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CsvJoinColumnDialog
extends TitleAreaDialog {
    public static final String TITLE = "Join columns";
    private final String MESSAGE = "Join selected columns into one single column.";
    private CSVEditor csvEditor;
    private Text textName;
    private Combo comboSeparator;
    private ColumnTableComposite ctc;
    private String separator;
    private int[] arrayIndices;

    public CsvJoinColumnDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.ctc = new ColumnTableComposite(composite, 0, this.csvEditor.getEditorUtils2().getColumnNamesAsList(true, false, false), this.csvEditor.getEditorUtils2().getColumnNamesAsList(true, true, true));
        GridData layoutData = new GridData();
        layoutData.widthHint = 300;
        layoutData.horizontalSpan = 3;
        this.ctc.setLayoutData(layoutData);
        Label labelName = new Label(composite, 0);
        labelName.setText("Joined column name: ");
        layoutData = new GridData();
        labelName.setLayoutData((Object)layoutData);
        this.textName = new Text(composite, 2052);
        List<String> checkedNames = this.ctc.getNamesByState(true);
        if (checkedNames != null && checkedNames.size() > 0) {
            this.textName.setText(checkedNames.get(0));
        }
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.textName.setLayoutData((Object)layoutData);
        Label labelSeparator = new Label(composite, 0);
        labelSeparator.setText("Separator: ");
        layoutData = new GridData();
        labelSeparator.setLayoutData((Object)layoutData);
        String[] separators = new String[CSVEditor.SEPARATOR_CHARS.length + 1];
        separators[0] = "Whitespace";
        int i = 0;
        while (i < CSVEditor.SEPARATOR_CHARS.length) {
            separators[i + 1] = String.valueOf(CSVEditor.SEPARATOR_CHARS[i]);
            ++i;
        }
        this.comboSeparator = new Combo(composite, 2060);
        this.comboSeparator.setItems(separators);
        this.comboSeparator.select(this.comboSeparator.getItemCount() - 1);
        layoutData = new GridData();
        labelSeparator.setLayoutData((Object)layoutData);
        this.initDialog();
        this.addListeners();
        return compositeParent;
    }

    private void addListeners() {
    }

    private void initDialog() {
        this.setTitle(TITLE);
        this.setMessage("Join selected columns into one single column.", 0);
    }

    protected void okPressed() {
        try {
            this.joinColumns();
        }
        catch (Exception ex) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)("Failed joining columns:" + ex.getMessage()));
            ex.printStackTrace();
        }
        super.okPressed();
    }

    private void joinColumns() throws InterruptedException, InvocationTargetException {
        this.setErrorMessage(null);
        List<String> checkedNames = this.ctc.getNamesByState(true);
        if (checkedNames == null || checkedNames.size() < 2) {
            this.setErrorMessage("Please, select at least 2 columns for joining");
            return;
        }
        boolean isValid = false;
        String[] stringArray = this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (n3.equals(this.textName.getText())) {
                for (String s : checkedNames) {
                    if (!s.equals(n3)) continue;
                    isValid = true;
                }
                if (!isValid) {
                    this.setErrorMessage("Column name '" + this.textName.getText() + "' already exists");
                    return;
                }
            }
            ++n2;
        }
        this.arrayIndices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(checkedNames);
        if (this.arrayIndices.length < 2) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)"Please, select at least 2 columns for joining");
            return;
        }
        this.separator = this.comboSeparator.getItem(this.comboSeparator.getSelectionIndex());
        if (this.separator.equals("Whitespace")) {
            this.separator = " ";
        }
        String[] headersBefore = this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false);
        this.csvEditor.joinColumns(this.arrayIndices, this.separator.charAt(0), this.textName.getText(), true, true);
        this.csvEditor.getListActions().add(new CsvActionColumnJoin(this.arrayIndices, headersBefore, this.separator));
        try {
            this.csvEditor.checkAllColumns(false, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

