/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvExportClusterRunnable;
import com.biotechvana.utils.PreferenceManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CsvExportCategoriesDialog
extends Dialog {
    private final String TITLE = "Export categories & clusters";
    private CSVEditor csvEditor;
    private TableViewer tableColumns;
    private Combo comboColums;
    private Text textFolder;
    private Button buttonFolder;
    private Button buttonSelectAll;
    private Button buttonExportCategory;
    private Button buttonExportCluster;
    private List<Integer> listCheckedRows;
    private Button buttonRange;
    private Text textRange;

    public CsvExportCategoriesDialog(Shell parentShell, CSVEditor csvEditor, List<Integer> listCheckedRows) {
        super(parentShell);
        this.csvEditor = csvEditor;
        this.listCheckedRows = listCheckedRows;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Export categories & clusters");
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        Label labelFile = new Label(composite, 0);
        labelFile.setText("Select destination folder:");
        GridData layoutData = new GridData();
        labelFile.setLayoutData((Object)layoutData);
        this.textFolder = new Text(composite, 2060);
        layoutData = new GridData();
        layoutData.widthHint = 300;
        this.textFolder.setLayoutData((Object)layoutData);
        this.buttonFolder = new Button(composite, 8);
        this.buttonFolder.setText("Browse");
        layoutData = new GridData();
        this.buttonFolder.setLayoutData((Object)layoutData);
        Label labelColumns = new Label(composite, 0);
        labelColumns.setText("Select key column: ");
        layoutData = new GridData();
        layoutData.verticalIndent = 10;
        labelColumns.setLayoutData((Object)layoutData);
        String[] columnNames = this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true);
        Object[] checkedColumnNames = this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, true, true);
        Arrays.sort(checkedColumnNames);
        this.comboColums = new Combo(composite, 2060);
        this.comboColums.setItems(columnNames);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.comboColums.setLayoutData((Object)layoutData);
        Label labelColumsExport = new Label(composite, 0);
        labelColumsExport.setText("Select columns to export: ");
        layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        layoutData.verticalIndent = 10;
        labelColumsExport.setLayoutData((Object)layoutData);
        this.tableColumns = new TableViewer(composite, 2848);
        layoutData = new GridData(768);
        layoutData.heightHint = 140;
        layoutData.horizontalSpan = 3;
        this.tableColumns.getTable().setLayoutData((Object)layoutData);
        this.tableColumns.getTable().setLinesVisible(true);
        this.tableColumns.setContentProvider((IContentProvider)new CsvExportContentProvider());
        this.tableColumns.setLabelProvider((IBaseLabelProvider)new CsvExportLabelProvider());
        this.tableColumns.setInput((Object)columnNames);
        TableItem[] tableItemArray = this.tableColumns.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (Arrays.binarySearch(checkedColumnNames, ti.getText()) >= 0) {
                ti.setChecked(true);
            }
            ++n2;
        }
        this.buttonSelectAll = new Button(composite, 32);
        this.buttonSelectAll.setText("Select all");
        layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        this.buttonSelectAll.setLayoutData((Object)layoutData);
        this.buttonSelectAll.setSelection(true);
        Group groupExport = this.createExportGroup(composite, 0);
        layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        layoutData.grabExcessHorizontalSpace = true;
        groupExport.setLayoutData((Object)layoutData);
        this.buttonRange = new Button(composite, 32);
        this.buttonRange.setSelection(false);
        layoutData = new GridData();
        this.buttonRange.setText("Use range for selection (+/-): ");
        this.buttonRange.setLayoutData((Object)layoutData);
        this.textRange = new Text(composite, 2048);
        this.textRange.setText("0");
        layoutData = new GridData();
        layoutData.widthHint = 100;
        layoutData.horizontalSpan = 2;
        this.textRange.setLayoutData((Object)layoutData);
        Label labelSeparator = new Label(composite, 0);
        labelSeparator.setText("");
        layoutData = new GridData();
        labelSeparator.setLayoutData((Object)layoutData);
        Label labelRange = new Label(composite, 0);
        labelRange.setText("Option only available if selected key column is numeric.");
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        labelRange.setLayoutData((Object)layoutData);
        this.addListeners();
        return compositeParent;
    }

    private Group createExportGroup(Composite parent, int style) {
        Group groupExport = new Group(parent, style);
        groupExport.setText("Export options");
        groupExport.setLayout((Layout)new GridLayout(1, false));
        this.buttonExportCategory = new Button((Composite)groupExport, 16);
        this.buttonExportCategory.setText("Categories: one file per category.");
        this.buttonExportCategory.setSelection(true);
        this.buttonExportCluster = new Button((Composite)groupExport, 16);
        this.buttonExportCluster.setText("Clusters: all clusters grouped in one single file.");
        return groupExport;
    }

    private void addListeners() {
        this.buttonFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvExportCategoriesDialog.this.browseFolder();
                CsvExportCategoriesDialog.this.validation();
            }
        });
        this.comboColums.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvExportCategoriesDialog.this.validation();
            }
        });
        this.buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvExportCategoriesDialog.this.checkAll(CsvExportCategoriesDialog.this.buttonSelectAll.getSelection());
                CsvExportCategoriesDialog.this.validation();
            }
        });
    }

    private void checkAll(boolean option) {
        int itemCount = this.tableColumns.getTable().getItemCount();
        int i = 0;
        while (i < itemCount) {
            this.tableColumns.getTable().getItem(i).setChecked(option);
            ++i;
        }
    }

    private void browseFolder() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8196);
        dialog.setFilterPath(PreferenceManager.getInstance().get("workspace", ""));
        String res = dialog.open();
        if (res == null) {
            return;
        }
        this.textFolder.setText(res);
    }

    private void validation() {
        this.getButton(0).setEnabled(false);
        if (this.textFolder.getText().isEmpty()) {
            this.getButton(0).setEnabled(false);
            return;
        }
        if (this.comboColums.getSelectionIndex() == -1) {
            return;
        }
        this.getButton(0).setEnabled(true);
    }

    private List<Integer> getSelectedColumns() {
        int itemCount = this.tableColumns.getTable().getItemCount();
        ArrayList<Integer> listChecked = new ArrayList<Integer>();
        int i = 0;
        while (i < itemCount) {
            if (this.tableColumns.getTable().getItem(i).getChecked() && i != this.comboColums.getSelectionIndex()) {
                listChecked.add(i + 2);
            }
            ++i;
        }
        return listChecked;
    }

    protected void okPressed() {
        if (this.buttonRange.getSelection()) {
            try {
                double range = Double.parseDouble(this.textRange.getText());
                if (range < 0.0) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Invalid range", (String)"Range cannot be negative");
                    return;
                }
            }
            catch (NumberFormatException ex) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Invalid range", (String)"Range must be a positive number. Please check format.");
                return;
            }
        }
        if (this.buttonExportCategory.getSelection()) {
            try {
                this.exportCategories();
            }
            catch (Exception ex) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Export categories & clusters", (String)("Cannot export categories: " + ex.getMessage()));
            }
        } else {
            try {
                this.exportClusters();
            }
            catch (Exception ex) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Export categories & clusters", (String)("Cannot export clusters: " + ex.getMessage()));
            }
        }
        super.okPressed();
    }

    private void exportCategories() throws InvocationTargetException, InterruptedException {
        String outputFolder = this.textFolder.getText();
        if (!this.checkFolder(outputFolder)) {
            return;
        }
        int categoryColumnIndex = this.comboColums.getSelectionIndex() + 2;
        List<String> selectedColumnNames = this.getSelectedTableNames(false);
        List<Integer> selectedIndices = this.csvEditor.getEditorUtils2().getColumnIndicesAsList(selectedColumnNames);
        selectedColumnNames.add(0, this.comboColums.getText());
        this.csvEditor.exportByCategory(categoryColumnIndex, selectedIndices, this.listCheckedRows, new File(outputFolder), false, selectedColumnNames, Double.parseDouble(this.textRange.getText()));
    }

    private void exportClusters() throws InvocationTargetException, InterruptedException {
        this.checkFolder(this.textFolder.getText());
        HashSet<Integer> listIndices = new HashSet<Integer>();
        listIndices.add(this.comboColums.getSelectionIndex());
        for (int i : this.getSelectedColumns()) {
            listIndices.add(i);
        }
        int[] finalExportIndices = new int[listIndices.size()];
        int counter = 0;
        for (Integer i : listIndices) {
            finalExportIndices[counter++] = i;
        }
        List<String> selectedColumnNames = this.getSelectedTableNames(true);
        List<Integer> exportColumnIndices = this.csvEditor.getEditorUtils2().getColumnIndicesAsList(selectedColumnNames);
        CsvExportClusterRunnable csvRunnable = new CsvExportClusterRunnable(this.csvEditor, this.comboColums.getSelectionIndex() + 2, exportColumnIndices, selectedColumnNames, this.listCheckedRows, new File(this.textFolder.getText()), true, false);
        if (this.buttonRange.getSelection()) {
            csvRunnable.setRange(Double.parseDouble(this.textRange.getText()));
        }
        new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)csvRunnable);
        CsvExportClusterRunnable fastaRunnable = new CsvExportClusterRunnable(this.csvEditor, this.comboColums.getSelectionIndex() + 2, exportColumnIndices, selectedColumnNames, this.listCheckedRows, new File(this.textFolder.getText()), false, true);
        if (this.buttonRange.getSelection()) {
            csvRunnable.setRange(Double.parseDouble(this.textRange.getText()));
        }
        new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)fastaRunnable);
    }

    private List<String> getSelectedTableNames(boolean includeCategoryName) {
        ArrayList<String> listNames = new ArrayList<String>();
        String categoryName = this.comboColums.getText();
        int itemCount = this.tableColumns.getTable().getItemCount();
        int i = 0;
        while (i < itemCount) {
            int index = i;
            if (this.tableColumns.getTable().getItem(index).getChecked()) {
                String name = this.tableColumns.getTable().getItem(index).getText();
                if (!includeCategoryName) {
                    if (!name.equals(categoryName)) {
                        listNames.add(name);
                    }
                } else {
                    listNames.add(name);
                }
            }
            ++i;
        }
        return listNames;
    }

    private boolean checkFolder(String folderPath) {
        boolean res;
        File outputFolder = new File(folderPath);
        if (!outputFolder.isDirectory()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Export categories & clusters", (String)"Not a valid folder");
            return false;
        }
        File[] listFiles = outputFolder.listFiles();
        return listFiles.length <= 0 || (res = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Export categories & clusters", (String)"Output folder already contains files. Overwrite files?"));
    }

    public int open() {
        return super.open();
    }

    private static class CsvExportContentProvider
    implements IStructuredContentProvider {
        private CsvExportContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class CsvExportLabelProvider
    implements ITableLabelProvider {
        private CsvExportLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

