/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csvUtils.CSVUtils2;
import com.biotechvana.csvUtils.CsvBufferedReader;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.editors.CSVEditorInput;
import com.biotechvana.csveditor.model.CsvEditor.CsvEditorCombineWorksheetMultipleRunnable;
import com.biotechvana.e3utils.MultiFileInput;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CsvCombineDialog
extends TitleAreaDialog {
    private final int TEXT_WIDTH = 300;
    private final int COMBO_WIDTH = 200;
    private final int COMBO_HEIGHT = 200;
    private final String TITLE = "Combine worksheets";
    private Text textMaster;
    private Button buttonMaster;
    private Button buttonMasterExport;
    private Button buttonRelatedExport;
    private Combo comboMasterKey;
    private Combo comboRelatedKey;
    private TableViewer tableViewerMaster;
    private TableViewer tableViewerRelated;
    private CSVEditor csvEditor;
    private CSVEditorInput csvEditorInput;
    private CSVUtils2 csvUtils;
    private MultiFileInput multiFileInput;
    private Combo comboSeparator;
    private Combo comboQuotes;

    public CsvCombineDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
        this.csvEditorInput = (CSVEditorInput)this.csvEditor.getEditorInput();
    }

    public void create() {
        super.create();
        this.setTitle("Combine worksheets");
        this.setMessage("Combine data from two or more worksheets related by a shared column.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        parent.getShell().setText("Combine worksheets");
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        composite.setLayout((Layout)layout);
        Group groupMaster = this.createGroupMaster(composite, 0);
        groupMaster.setLayoutData((Object)new GridData(4, 4, true, true));
        Group groupRelated = this.createGroupRelated(composite, 0);
        groupRelated.setLayoutData((Object)new GridData(4, 4, true, true));
        if (!this.textMaster.getText().isEmpty()) {
            try {
                String[] headers = this.updateKeys(this.textMaster.getText(), this.comboMasterKey);
                this.updateColumns(this.tableViewerMaster, headers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.buttonMasterExport.setSelection(true);
            this.checkAllTable(this.tableViewerMaster, this.buttonMasterExport.getSelection());
        }
        return compositeParent;
    }

    protected void okPressed() {
        if (!this.validation()) {
            return;
        }
        this.run();
        super.okPressed();
    }

    private boolean validateTableChecked(TableViewer tableViewer) {
        int itemCount = tableViewer.getTable().getItemCount();
        int i = 0;
        while (i < itemCount) {
            if (tableViewer.getTable().getItem(i).getChecked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateColumns(TableViewer tableViewer, String[] headers) {
        tableViewer.setInput((Object)headers);
    }

    private String[] updateKeys(String csvFile, Combo combo) {
        this.csvUtils = CSVUtils2.createNewUtils((String)csvFile, (boolean)true);
        try {
            this.csvUtils.parse();
            String[] headers = null;
            List listHeader = this.csvUtils.getHeaders();
            headers = listHeader.toArray(new String[listHeader.size()]);
            combo.setItems(headers);
            return headers;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (CSVUtils2.LineCountNotDoneException e) {
            e.printStackTrace();
        }
        catch (CSVUtils2.ColumnCountNotDoneException e) {
            e.printStackTrace();
        }
        catch (CSVUtils2.SeparatorNotParsedException e) {
            e.printStackTrace();
        }
        catch (CSVUtils2.DelimiterNotParsedException e) {
            e.printStackTrace();
        }
        catch (CSVUtils2.CannotOpenFileException e) {
            e.printStackTrace();
        }
        catch (CSVUtils2.HeadersNotParsedException e) {
            e.printStackTrace();
        }
        catch (CSVUtils2.CommentsNotParsedException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void checkAllTable(TableViewer tableViewer, boolean checked) {
        int itemCount = tableViewer.getTable().getItemCount();
        int i = 0;
        while (i < itemCount) {
            tableViewer.getTable().getItem(i).setChecked(checked);
            ++i;
        }
    }

    private Group createGroupMaster(Composite parent, int style) {
        Group group = new Group(parent, style);
        group.setText("Master worksheet");
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 64);
        label.setText("This is the main worksheet on which all related data will be appended.");
        label.setLayoutData((Object)new GridData(65, 0x1000000, false, false, 3, 1));
        label = new Label((Composite)group, 64);
        label.setText("");
        label.setLayoutData((Object)new GridData(65, 0x1000000, false, false, 3, 1));
        ((GridData)label.getLayoutData()).verticalIndent = 4;
        label = new Label((Composite)group, 0);
        label.setText("File:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textMaster = new Text((Composite)group, 2060);
        this.textMaster.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textMaster.setText(this.csvEditorInput.getInputFile().getAbsolutePath());
        this.textMaster.setSelection(this.textMaster.getText().length());
        ((GridData)this.textMaster.getLayoutData()).widthHint = 300;
        this.buttonMaster = new Button((Composite)group, 8);
        this.buttonMaster.setText("Browse");
        this.buttonMaster.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonMaster.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(CsvCombineDialog.this.getShell(), 4098);
                String res = dialog.open();
                System.out.println("res: " + res);
                if (!CsvCombineDialog.this.textMaster.getText().isEmpty()) {
                    try {
                        String[] headers = CsvCombineDialog.this.updateKeys(CsvCombineDialog.this.textMaster.getText(), CsvCombineDialog.this.comboMasterKey);
                        CsvCombineDialog.this.updateColumns(CsvCombineDialog.this.tableViewerMaster, headers);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        label = new Label((Composite)group, 64);
        label.setText("");
        label.setLayoutData((Object)new GridData(65, 0x1000000, false, false, 3, 1));
        ((GridData)label.getLayoutData()).verticalIndent = 4;
        Label labelMasterKey = new Label((Composite)group, 0);
        labelMasterKey.setText("Key column:");
        labelMasterKey.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboMasterKey = new Combo((Composite)group, 2060);
        this.comboMasterKey.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        ((GridData)this.comboMasterKey.getLayoutData()).widthHint = 150;
        Label labelMasterExport = new Label((Composite)group, 0);
        labelMasterExport.setText("Export columns:");
        labelMasterExport.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.tableViewerMaster = new TableViewer((Composite)group, 2848);
        this.tableViewerMaster.setContentProvider((IContentProvider)new ColumnContentProvider());
        this.tableViewerMaster.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
        this.tableViewerMaster.getTable().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        ((GridData)this.tableViewerMaster.getTable().getLayoutData()).heightHint = 200;
        this.buttonMasterExport = new Button((Composite)group, 32);
        this.buttonMasterExport.setText("Select all");
        this.buttonMasterExport.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.buttonMasterExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvCombineDialog.this.checkAllTable(CsvCombineDialog.this.tableViewerMaster, CsvCombineDialog.this.buttonMasterExport.getSelection());
            }
        });
        Group groupAdvancedOptions = this.createGroupAdvancedOptions((Composite)group);
        groupAdvancedOptions.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        ((GridData)groupAdvancedOptions.getLayoutData()).verticalIndent = 10;
        return group;
    }

    private Group createGroupRelated(Composite parent, int style) {
        Group group = new Group(parent, style);
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        group.setText("Related worksheets");
        Label label = new Label((Composite)group, 64);
        label.setText("When selecting multiple files, related worksheets must have its \ncolumns in the same order.");
        label.setLayoutData((Object)new GridData(64, 0x1000000, false, false, 3, 1));
        this.multiFileInput = new MultiFileInput((Composite)group, 0, null);
        this.multiFileInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.multiFileInput.getInputControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    List<String> listHeaders = CsvCombineDialog.this.getFirstFileHeaders();
                    CsvCombineDialog.this.updateColumns(CsvCombineDialog.this.tableViewerRelated, listHeaders.toArray(new String[listHeaders.size()]));
                    CsvCombineDialog.this.comboRelatedKey.setItems(listHeaders.toArray(new String[listHeaders.size()]));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        Label labelRelatedKey = new Label((Composite)group, 0);
        labelRelatedKey.setText("Key column:");
        labelRelatedKey.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboRelatedKey = new Combo((Composite)group, 2060);
        this.comboRelatedKey.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        ((GridData)this.comboRelatedKey.getLayoutData()).widthHint = 200;
        Label labelRelatedExport = new Label((Composite)group, 0);
        labelRelatedExport.setText("Export columns:");
        labelRelatedExport.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.tableViewerRelated = new TableViewer((Composite)group, 2848);
        this.tableViewerRelated.setContentProvider((IContentProvider)new ColumnContentProvider());
        this.tableViewerRelated.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
        this.tableViewerRelated.getTable().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        ((GridData)this.tableViewerRelated.getTable().getLayoutData()).heightHint = 200;
        this.buttonRelatedExport = new Button((Composite)group, 32);
        this.buttonRelatedExport.setText("Select all");
        this.buttonRelatedExport.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.buttonRelatedExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvCombineDialog.this.checkAllTable(CsvCombineDialog.this.tableViewerRelated, CsvCombineDialog.this.buttonRelatedExport.getSelection());
            }
        });
        return group;
    }

    private boolean validation() {
        if (this.textMaster.getText().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Master worksheet is empty.");
            return false;
        }
        if (this.multiFileInput.getInputPath().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Related worksheet is empty.");
            return false;
        }
        if (this.multiFileInput.getOutputPath().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Output is empty");
            return false;
        }
        if (this.comboMasterKey.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Master worksheet key must be selected");
            return false;
        }
        if (this.comboRelatedKey.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Related worksheet key must be selected");
            return false;
        }
        int[] arrayMasterCheckedIndices = this.getTableCheckedColumnIndices(this.tableViewerMaster);
        if (arrayMasterCheckedIndices.length == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Master worksheet: must select export columns");
            return false;
        }
        int[] arrayRelatedCheckedIndices = this.getTableCheckedColumnIndices(this.tableViewerRelated);
        if (arrayRelatedCheckedIndices.length == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Related worksheets: must select export columns");
            return false;
        }
        return true;
    }

    private List<String> getFirstFileHeaders() throws IOException {
        File[] inputFileList = this.multiFileInput.getInputFileList();
        if (inputFileList == null) {
            return null;
        }
        File firstFile = inputFileList[0];
        CsvBufferedReader csvReader = new CsvBufferedReader(firstFile, ';', '\"');
        List listHeader = csvReader.readLine();
        return listHeader;
    }

    private void run() {
        CsvEditorCombineWorksheetMultipleRunnable runnable = new CsvEditorCombineWorksheetMultipleRunnable(new File(this.textMaster.getText()), this.multiFileInput.getInputFileList(), this.comboMasterKey.getSelectionIndex(), this.comboRelatedKey.getSelectionIndex(), this.getTableCheckedColumnIndices(this.tableViewerMaster), this.getTableCheckedColumnIndices(this.tableViewerRelated), new File(this.multiFileInput.getOutputPath()), this.getSelectedSeparator(), this.getSelectedQuotes());
        try {
            new ProgressMonitorDialog(this.csvEditor.getSite().getShell()).run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e1) {
            MessageDialog.openWarning((Shell)this.csvEditor.getSite().getShell(), (String)"Combine worksheets", (String)("Failed combining worksheets: " + e1.getMessage()));
            e1.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int[] getTableCheckedColumnIndices(TableViewer tableViewer) {
        ArrayList<Integer> listIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < tableViewer.getTable().getItemCount()) {
            if (tableViewer.getTable().getItem(i).getChecked()) {
                listIndices.add(i);
            }
            ++i;
        }
        int[] arrayIndices = new int[listIndices.size()];
        int i2 = 0;
        while (i2 < listIndices.size()) {
            arrayIndices[i2] = (Integer)listIndices.get(i2);
            ++i2;
        }
        return arrayIndices;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private Group createGroupAdvancedOptions(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Advanced options:");
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText("Column separator:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboSeparator = new Combo((Composite)group, 2060);
        this.comboSeparator.setItems(new String[]{"Semicolon", "Colon", "Tab", "Space"});
        this.comboSeparator.select(0);
        this.comboSeparator.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboSeparator.getLayoutData()).widthHint = 200;
        label = new Label((Composite)group, 0);
        label.setText("Column quotes:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboQuotes = new Combo((Composite)group, 2060);
        this.comboQuotes.setItems(new String[]{"Double quotes", "Single quotes", "None"});
        this.comboQuotes.select(0);
        this.comboQuotes.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboQuotes.getLayoutData()).widthHint = 200;
        return group;
    }

    private char getSelectedSeparator() {
        switch (this.comboSeparator.getSelectionIndex()) {
            case 0: {
                return ';';
            }
            case 1: {
                return ':';
            }
            case 2: {
                return '\t';
            }
            case 3: {
                return ' ';
            }
        }
        return ';';
    }

    private char getSelectedQuotes() {
        switch (this.comboQuotes.getSelectionIndex()) {
            case 0: {
                return '\"';
            }
            case 1: {
                return '\'';
            }
            case 2: {
                return 'N';
            }
        }
        return '\"';
    }

    private class ColumnContentProvider
    implements IStructuredContentProvider {
        private ColumnContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }
    }

    private class ColumnLabelProvider
    extends LabelProvider {
        private ColumnLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

