/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.csvUtils.CsvBufferedReader;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvAppendWorksheetMultifileRunnable;
import com.biotechvana.csveditor.model.CsvEditor.CsvAppendColumnPair;
import com.biotechvana.e3utils.MultiFileInput;
import com.biotechvana.utils.FilenameUtils;
import com.biotechvana.utils.HTMLTooltip;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class CsvAppendWorksheetDialog
extends TitleAreaDialog {
    private final String TITLE = "Append worksheet";
    private CSVEditor csvEditor;
    private Text textMaster;
    private Table table;
    private TableViewer tableViewer;
    private CsvAppendColumnPair[] columnPairList;
    private Combo comboSeparator;
    private Combo comboQuotes;
    private MultiFileInput multiFileInput;

    public CsvAppendWorksheetDialog(Shell parentShell, CSVEditor csvEditor, String defaultFile) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    public void create() {
        super.create();
        this.getShell().setText("Import");
        this.setTitle("Append worksheet");
        this.setMessage("Append data from other worksheet.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        composite.setLayout((Layout)layout);
        Group groupInput = this.createInputGroup(composite);
        groupInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.table = new Table(composite, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        layoutData.heightHint = 300;
        layoutData.verticalIndent = 20;
        this.table.setLayoutData((Object)layoutData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.initializeTable();
        this.addProviders();
        Link linkHelp = new Link(composite, 0);
        linkHelp.setText("<a>Help</a>");
        layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        linkHelp.setLayoutData((Object)layoutData);
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("<h3>Help</h3>");
        sbuilder.append("Columns in both worksheets must contain the same column names and must be identically ordered");
        new HTMLTooltip((Control)linkHelp, sbuilder.toString());
        Group groupAdvanced = this.createGroupAdvancedOptions(composite);
        groupAdvanced.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)groupAdvanced.getLayoutData()).verticalIndent = 10;
        return compositeParent;
    }

    private Group createInputGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Input files:");
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText("Master file:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textMaster = new Text((Composite)group, 2060);
        this.textMaster.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.csvEditor != null && this.csvEditor.getCsvFile() != null) {
            this.textMaster.setText(this.csvEditor.getCsvFile().getAbsolutePath());
            this.textMaster.setSelection(this.textMaster.getText().length());
        }
        Button button = new Button((Composite)group, 8);
        button.setText("Browse");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String res;
                FileDialog dialog = new FileDialog(CsvAppendWorksheetDialog.this.getShell(), 4096);
                if (CsvAppendWorksheetDialog.this.csvEditor.getCsvFile() != null) {
                    dialog.setFilterPath(CsvAppendWorksheetDialog.this.csvEditor.getCsvFile().getAbsolutePath());
                }
                if ((res = dialog.open()) != null) {
                    CsvAppendWorksheetDialog.this.textMaster.setText(res);
                    CsvAppendWorksheetDialog.this.textMaster.setSelection(res.length());
                    try {
                        CsvAppendWorksheetDialog.this.tableViewer.setInput((Object)CsvAppendWorksheetDialog.this.generateColumnPairs());
                    }
                    catch (IOException e1) {
                        MessageDialog.openWarning((Shell)CsvAppendWorksheetDialog.this.getShell(), (String)"Column names", (String)("Failed updating column names: " + e1.getMessage()));
                        e1.printStackTrace();
                    }
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Append files:");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.multiFileInput = new MultiFileInput((Composite)group, 0, null);
        this.multiFileInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.multiFileInput.getInputControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    CsvAppendWorksheetDialog.this.tableViewer.setInput((Object)CsvAppendWorksheetDialog.this.generateColumnPairs());
                }
                catch (IOException e1) {
                    MessageDialog.openWarning((Shell)CsvAppendWorksheetDialog.this.getShell(), (String)"Column names", (String)("Failed updating column names: " + e1.getMessage()));
                    e1.printStackTrace();
                }
            }
        });
        return group;
    }

    private List<List<String>> getCsvHeaders(File[] arrayFileCsv) throws IOException {
        ArrayList<List<String>> listHeaders = new ArrayList<List<String>>();
        File[] fileArray = arrayFileCsv;
        int n = arrayFileCsv.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            listHeaders.add(this.getCsvHeaders(f));
            ++n2;
        }
        return listHeaders;
    }

    private List<String> getCsvHeaders(File fileCsv) throws IOException {
        CsvBufferedReader reader = new CsvBufferedReader(fileCsv, ';', '\"');
        List row = reader.readLine();
        while (row == null || row.size() == 0) {
            row = reader.readLine();
        }
        reader.close();
        return row;
    }

    private boolean compareHeaders(List<List<String>> listHeaders) {
        int headersLen = listHeaders.get(0).size();
        int i = 0;
        while (i < headersLen) {
            int j = 1;
            while (j < listHeaders.size()) {
                String valCurr;
                String valPrev = listHeaders.get(j - 1).get(i);
                if (!valPrev.equals(valCurr = listHeaders.get(j).get(i))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private void initializeTable() {
        TableViewerColumn colStatus = new TableViewerColumn(this.tableViewer, 0);
        colStatus.getColumn().setText("Status");
        colStatus.getColumn().setWidth(60);
        colStatus.getColumn().setResizable(true);
        colStatus.getColumn().setMoveable(false);
        colStatus.getColumn().setAlignment(0x1000000);
        TableViewerColumn colMaster = new TableViewerColumn(this.tableViewer, 0);
        colMaster.getColumn().setText("Master");
        colMaster.getColumn().setWidth(150);
        colMaster.getColumn().setResizable(true);
        colMaster.getColumn().setMoveable(false);
        TableViewerColumn colRelated = new TableViewerColumn(this.tableViewer, 0);
        colRelated.getColumn().setText("Import");
        colRelated.getColumn().setWidth(150);
        colRelated.getColumn().setResizable(true);
        colRelated.getColumn().setMoveable(false);
    }

    private int getErrorColumnPairCount() {
        int countError = 0;
        if (this.columnPairList == null) {
            return 0;
        }
        CsvAppendColumnPair[] csvAppendColumnPairArray = this.columnPairList;
        int n = this.columnPairList.length;
        int n2 = 0;
        while (n2 < n) {
            CsvAppendColumnPair p = csvAppendColumnPairArray[n2];
            if (p.getStatus() != 0) {
                ++countError;
            }
            ++n2;
        }
        return countError;
    }

    private void addProviders() {
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return (CsvAppendColumnPair[])inputElement;
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                CsvAppendColumnPair pair = (CsvAppendColumnPair)element;
                switch (columnIndex) {
                    case 1: {
                        return pair.getColumnMaster();
                    }
                    case 2: {
                        return pair.getColumnRelated();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    switch (((CsvAppendColumnPair)element).getStatus()) {
                        case 0: {
                            return SharedImages.ACCEPT;
                        }
                    }
                    return SharedImages.CANCEL;
                }
                return null;
            }
        });
    }

    protected void okPressed() {
        if (this.getErrorColumnPairCount() > 0 && !MessageDialog.openConfirm((Shell)this.getShell(), (String)"Append worksheet", (String)"Errors were found. Continue?")) {
            return;
        }
        if (!this.validation()) {
            return;
        }
        try {
            this.run();
        }
        catch (InvocationTargetException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Append worksheet", (String)"Failed appending worksheets");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.okPressed();
    }

    private CsvAppendColumnPair[] generateColumnPairs() throws IOException {
        List<String> headersMaster = this.getCsvHeaders(new File(this.textMaster.getText()));
        File[] relatedFiles = this.multiFileInput.getInputFileList();
        List<String> headersRelated = this.getCsvHeaders(relatedFiles[0]);
        int maxLength = headersMaster.size();
        if (headersRelated.size() > maxLength) {
            maxLength = headersRelated.size();
        }
        CsvAppendColumnPair[] columnPairs = new CsvAppendColumnPair[maxLength];
        int i = 0;
        while (i < maxLength) {
            String masterName = null;
            String relatedName = null;
            if (i < headersMaster.size()) {
                masterName = headersMaster.get(i);
            }
            if (i < headersRelated.size()) {
                relatedName = headersRelated.get(i);
            }
            columnPairs[i] = new CsvAppendColumnPair(masterName, relatedName);
            ++i;
        }
        return columnPairs;
    }

    private boolean compareAllFilesHeaders() throws IOException {
        File[] relatedFiles;
        List<String> headersMaster = this.getCsvHeaders(new File(this.textMaster.getText()));
        File[] fileArray = relatedFiles = this.multiFileInput.getInputFileList();
        int n = relatedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File rf = fileArray[n2];
            List<String> headersRelated = this.getCsvHeaders(rf);
            if (headersMaster.size() != headersRelated.size()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Append worksheet", (String)("Non matching headers in file: " + rf.getName()));
                return false;
            }
            int i = 0;
            while (i < headersMaster.size()) {
                String hRelated;
                String hMaster = headersMaster.get(i);
                if (!hMaster.equalsIgnoreCase(hRelated = headersRelated.get(i))) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Append worksheet", (String)("Invalid header name '" + hRelated + "' in file: " + rf.getName()));
                    return false;
                }
                ++i;
            }
            ++n2;
        }
        return true;
    }

    private boolean validation() {
        if (this.textMaster.getText().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Invalid master file");
            return false;
        }
        if (this.multiFileInput.getInputControl().getText().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Invalid append source");
            return false;
        }
        if (this.multiFileInput.getOutputPath().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Invalid output folder");
            return false;
        }
        try {
            return this.compareAllFilesHeaders();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private List<List<String>> getAllHeaders() throws IOException {
        List<String> headersMaster = this.getCsvHeaders(new File(this.textMaster.getText()));
        List<List<String>> headersRelated = this.getCsvHeaders(this.multiFileInput.getInputFileList());
        ArrayList<List<String>> listAll = new ArrayList<List<String>>();
        listAll.add(headersMaster);
        listAll.addAll(headersRelated);
        return listAll;
    }

    private File[] getFilesFromFolder(File inputFolder, final File masterFile) {
        return inputFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".csv") && !name.equalsIgnoreCase(masterFile.getName());
            }
        });
    }

    private void run() throws InvocationTargetException, InterruptedException {
        String inputBasename = FilenameUtils.getBasename((String)this.textMaster.getText());
        File outputFile = new File(this.multiFileInput.getOutputPath() + "/" + inputBasename + "_append.csv");
        CsvAppendWorksheetMultifileRunnable runnable = new CsvAppendWorksheetMultifileRunnable(new File(this.textMaster.getText()), this.multiFileInput.getInputFileList(), outputFile, this.getSelectedSeparator(), this.getSelectedQuotes());
        new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)runnable);
    }

    private Group createGroupAdvancedOptions(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Advanced options:");
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText("Column separator:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboSeparator = new Combo((Composite)group, 2060);
        this.comboSeparator.setItems(new String[]{"Semicolon", "Colon", "Tab", "Space"});
        this.comboSeparator.select(0);
        this.comboSeparator.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboSeparator.getLayoutData()).widthHint = 200;
        label = new Label((Composite)group, 0);
        label.setText("Column quotes:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboQuotes = new Combo((Composite)group, 2060);
        this.comboQuotes.setItems(new String[]{"Double quotes", "Single quotes", "None"});
        this.comboQuotes.select(0);
        this.comboQuotes.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboQuotes.getLayoutData()).widthHint = 200;
        return group;
    }

    private char getSelectedSeparator() {
        switch (this.comboSeparator.getSelectionIndex()) {
            case 0: {
                return ';';
            }
            case 1: {
                return ':';
            }
            case 2: {
                return '\t';
            }
            case 3: {
                return ' ';
            }
        }
        return ';';
    }

    private char getSelectedQuotes() {
        switch (this.comboQuotes.getSelectionIndex()) {
            case 0: {
                return '\"';
            }
            case 1: {
                return '\'';
            }
            case 2: {
                return 'N';
            }
        }
        return '\"';
    }

    class ActionEditor
    extends EditingSupport {
        private CellEditor editor;

        public ActionEditor(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            CsvAppendColumnPair colPair = (CsvAppendColumnPair)element;
            if (colPair.getStatus() == 0) {
                return null;
            }
            this.editor = new ComboBoxCellEditor((Composite)CsvAppendWorksheetDialog.this.tableViewer.getTable(), new String[]{"No action", "Insert", "Delete"}, 8);
            return this.editor;
        }

        protected Object getValue(Object element) {
            return ((CsvAppendColumnPair)element).getAction();
        }

        protected void setValue(Object element, Object value) {
            CsvAppendColumnPair colPair = (CsvAppendColumnPair)element;
            colPair.setAction((Integer)value);
            this.getViewer().update(element, null);
        }
    }
}

