/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.dialogs.CustomColorDialog;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CsvAnnotationColorsDialog
extends TitleAreaDialog {
    private final int BUTTON_HEIGHT = 20;
    private final int BUTTON_WIDTH = 20;
    public static final String TITLE = "Apply annotation colors";
    private CSVEditor csvEditor;
    private int colorNohit;
    private int colorHit;
    private int colorFunction;
    private int colorMapped;
    private int colorMappedPlus;
    private Label buttonColorNohit;
    private Label buttonColorHit;
    private Label buttonColorFunction;
    private Label buttonColorMapped;
    private Label buttonColorMappedPlus;
    private Combo comboNoHit;
    private Combo comboHit;
    private Combo comboFunction;
    private Combo comboMapped;
    private Combo comboMappedPlus;
    private String[] columnNames;
    private Text textEvalue;
    private double evalueThreshold = 1.0E-4;
    private final String[] EVALUE_TERMS = new String[]{"e-value", "evalue", "e value"};
    private final String[] FUNCTION_TERMS = new String[]{"Funciton", "Subject", "Subject mapping"};
    private final String[] GO_TERMS = new String[]{"GO", "GOs", "Gene ontology", "Gene ontologies"};
    private final String[] ENZYME_TERMS = new String[]{"EC", "Enzyme code"};
    private IPrefs prefs = PreferenceManager.getInstance();

    public CsvAnnotationColorsDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
        this.columnNames = csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        composite.setLayout((Layout)layout);
        Group groupAnnotationColor = this.createAnnotationColorGroup(composite, 0);
        this.initDialog();
        return compositeParent;
    }

    private void initDialog() {
        this.getShell().setText("Functional annotation");
        this.setTitle(TITLE);
        this.setMessage("Apply colors to worksheet rows by its annotation level");
    }

    private Group createAnnotationColorGroup(Composite parent, int style) {
        Group composite = new Group(parent, style);
        composite.setText("Annotation colors");
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData layoutData = new GridData();
        this.buttonColorNohit = new Label((Composite)composite, 2048);
        layoutData = new GridData();
        layoutData.widthHint = 20;
        layoutData.heightHint = 20;
        this.buttonColorNohit.setLayoutData((Object)layoutData);
        Label labelNohit = new Label((Composite)composite, 0);
        labelNohit.setText(CSVEditor.Annotation.ANNOTATION_NOHIT.getValue());
        this.comboNoHit = new Combo((Composite)composite, 2056);
        this.comboNoHit.setItems(this.columnNames);
        this.preSelectCombo(this.comboNoHit, this.EVALUE_TERMS);
        this.buttonColorHit = new Label((Composite)composite, 2048);
        layoutData = new GridData();
        layoutData.widthHint = 20;
        layoutData.heightHint = 20;
        this.buttonColorHit.setLayoutData((Object)layoutData);
        Label labelHit = new Label((Composite)composite, 0);
        labelHit.setText(CSVEditor.Annotation.ANNOTATION_HIT.getValue());
        this.comboHit = new Combo((Composite)composite, 2056);
        this.comboHit.setItems(this.columnNames);
        this.preSelectCombo(this.comboHit, this.EVALUE_TERMS);
        this.buttonColorFunction = new Label((Composite)composite, 2048);
        layoutData = new GridData();
        layoutData.widthHint = 20;
        layoutData.heightHint = 20;
        this.buttonColorFunction.setLayoutData((Object)layoutData);
        Label labelFunction = new Label((Composite)composite, 0);
        labelFunction.setText(CSVEditor.Annotation.ANNOTATION_FUNCTION.getValue());
        this.comboFunction = new Combo((Composite)composite, 2056);
        this.comboFunction.setItems(this.columnNames);
        this.preSelectCombo(this.comboFunction, this.FUNCTION_TERMS);
        this.buttonColorMapped = new Label((Composite)composite, 2048);
        layoutData = new GridData();
        layoutData.widthHint = 20;
        layoutData.heightHint = 20;
        this.buttonColorMapped.setLayoutData((Object)layoutData);
        Label labelMapped = new Label((Composite)composite, 0);
        labelMapped.setText(CSVEditor.Annotation.ANNOTATION_MAPPED.getValue());
        this.comboMapped = new Combo((Composite)composite, 2056);
        this.comboMapped.setItems(this.columnNames);
        this.preSelectCombo(this.comboMapped, this.GO_TERMS);
        this.buttonColorMappedPlus = new Label((Composite)composite, 2048);
        layoutData = new GridData();
        layoutData.widthHint = 20;
        layoutData.heightHint = 20;
        this.buttonColorMappedPlus.setLayoutData((Object)layoutData);
        Label labelMappedPlus = new Label((Composite)composite, 0);
        labelMappedPlus.setText(CSVEditor.Annotation.ANNOTATION_MAPPED_PLUS.getValue());
        this.comboMappedPlus = new Combo((Composite)composite, 2056);
        this.comboMappedPlus.setItems(this.columnNames);
        this.preSelectCombo(this.comboMappedPlus, this.ENZYME_TERMS);
        new Label((Composite)composite, 0);
        Label labelEvalue = new Label((Composite)composite, 0);
        labelEvalue.setText("E-value threshold");
        this.textEvalue = new Text((Composite)composite, 2052);
        layoutData = new GridData(768);
        this.textEvalue.setLayoutData((Object)layoutData);
        String v = this.prefs.get("evalueThreshold", "");
        if (!v.isEmpty()) {
            try {
                this.evalueThreshold = Double.parseDouble(v);
                this.textEvalue.setText(v);
            }
            catch (Exception ex) {
                this.textEvalue.setText(String.valueOf(this.evalueThreshold));
            }
        } else {
            this.textEvalue.setText(String.valueOf(this.evalueThreshold));
        }
        this.initAnnotationColors();
        this.addListeners();
        return composite;
    }

    public int open() {
        return super.open();
    }

    public void create() {
        super.create();
        this.textEvalue.setFocus();
    }

    private void initAnnotationColors() {
        String noHit = this.prefs.get(CSVEditor.Annotation.ANNOTATION_NOHIT.getPreferenceKey(), "");
        if (!noHit.isEmpty()) {
            this.buttonColorNohit.setImage(CustomColorDialog.imageArray[Integer.parseInt(noHit)]);
            this.colorNohit = Integer.parseInt(noHit);
        } else {
            this.buttonColorNohit.setImage(CustomColorDialog.imageArray[0]);
            this.prefs.put(CSVEditor.Annotation.ANNOTATION_NOHIT.getPreferenceKey(), "0");
            this.colorNohit = 0;
        }
        String hit = this.prefs.get(CSVEditor.Annotation.ANNOTATION_HIT.getPreferenceKey(), "");
        if (!hit.isEmpty()) {
            this.buttonColorHit.setImage(CustomColorDialog.imageArray[Integer.parseInt(hit)]);
            this.colorHit = Integer.parseInt(hit);
        } else {
            this.buttonColorHit.setImage(CustomColorDialog.imageArray[6]);
            this.colorHit = 6;
        }
        String mapped = this.prefs.get(CSVEditor.Annotation.ANNOTATION_FUNCTION.getPreferenceKey(), "");
        if (!mapped.isEmpty()) {
            this.buttonColorFunction.setImage(CustomColorDialog.imageArray[Integer.parseInt(mapped)]);
            this.colorFunction = Integer.parseInt(mapped);
        } else {
            this.buttonColorFunction.setImage(CustomColorDialog.imageArray[14]);
            this.colorFunction = 14;
        }
        String annotated = this.prefs.get(CSVEditor.Annotation.ANNOTATION_MAPPED.getPreferenceKey(), "");
        if (!annotated.isEmpty()) {
            this.buttonColorMapped.setImage(CustomColorDialog.imageArray[Integer.parseInt(annotated)]);
            this.colorMapped = Integer.parseInt(annotated);
        } else {
            this.buttonColorMapped.setImage(CustomColorDialog.imageArray[12]);
            this.colorMapped = 12;
        }
        String annotatedPlus = this.prefs.get(CSVEditor.Annotation.ANNOTATION_MAPPED_PLUS.getPreferenceKey(), "");
        if (!annotatedPlus.isEmpty()) {
            this.buttonColorMappedPlus.setImage(CustomColorDialog.imageArray[Integer.parseInt(annotatedPlus)]);
            this.colorMappedPlus = Integer.parseInt(annotatedPlus);
        } else {
            this.buttonColorMappedPlus.setImage(CustomColorDialog.imageArray[10]);
            this.colorMappedPlus = 10;
        }
    }

    protected void okPressed() {
        if (this.csvEditor.isShowAnnotationColors()) {
            try {
                this.csvEditor.resetAnnotationColors();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            this.csvEditor.setShowAnnotationColors(false);
        } else {
            this.csvEditor.evalueThreshold = Double.parseDouble(this.textEvalue.getText());
            this.generateMaps();
            try {
                this.csvEditor.loadAnnotationColors();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            this.csvEditor.setShowAnnotationColors(true);
        }
        super.okPressed();
    }

    private void addListeners() {
        this.comboNoHit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvAnnotationColorsDialog.this.comboHit.select(CsvAnnotationColorsDialog.this.comboNoHit.getSelectionIndex());
            }
        });
        this.comboHit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvAnnotationColorsDialog.this.comboNoHit.select(CsvAnnotationColorsDialog.this.comboHit.getSelectionIndex());
            }
        });
    }

    private void preSelectCombo(Combo combo, String[] values) {
        int i = 0;
        while (i < values.length) {
            values[i] = values[i].toLowerCase();
            ++i;
        }
        Arrays.sort(values);
        int index = -1;
        int i2 = 0;
        while (i2 < this.columnNames.length && index < 0) {
            if (Arrays.binarySearch(values, this.columnNames[i2].toLowerCase()) >= 0) {
                index = i2;
            }
            ++i2;
        }
        if (index >= 0) {
            combo.select(index);
            return;
        }
        i2 = 0;
        while (i2 < this.columnNames.length && index < 0) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (this.columnNames[i2].contains(v)) {
                    combo.select(i2);
                    return;
                }
                ++n2;
            }
            ++i2;
        }
    }

    private void generateMaps() {
        HashMap<String, Color> mapAnnotationColors = new HashMap<String, Color>();
        HashMap<String, Integer> mapAnnotationIndices = new HashMap<String, Integer>();
        mapAnnotationColors.put(CSVEditor.Annotation.ANNOTATION_NOHIT.getKey(), new Color((Device)this.getShell().getDisplay(), CustomColorDialog.rgbArray[this.colorNohit]));
        mapAnnotationColors.put(CSVEditor.Annotation.ANNOTATION_HIT.getKey(), new Color((Device)this.getShell().getDisplay(), CustomColorDialog.rgbArray[this.colorHit]));
        mapAnnotationColors.put(CSVEditor.Annotation.ANNOTATION_FUNCTION.getKey(), new Color((Device)this.getShell().getDisplay(), CustomColorDialog.rgbArray[this.colorFunction]));
        mapAnnotationColors.put(CSVEditor.Annotation.ANNOTATION_MAPPED.getKey(), new Color((Device)this.getShell().getDisplay(), CustomColorDialog.rgbArray[this.colorMapped]));
        mapAnnotationColors.put(CSVEditor.Annotation.ANNOTATION_MAPPED_PLUS.getKey(), new Color((Device)this.getShell().getDisplay(), CustomColorDialog.rgbArray[this.colorMappedPlus]));
        mapAnnotationIndices.put(CSVEditor.Annotation.ANNOTATION_NOHIT.getKey(), this.csvEditor.getColumnIndexForName(this.comboNoHit.getText()));
        mapAnnotationIndices.put(CSVEditor.Annotation.ANNOTATION_HIT.getKey(), this.csvEditor.getColumnIndexForName(this.comboNoHit.getText()));
        if (this.comboFunction.getSelectionIndex() != -1) {
            mapAnnotationIndices.put(CSVEditor.Annotation.ANNOTATION_FUNCTION.getKey(), this.csvEditor.getColumnIndexForName(this.comboFunction.getText()));
        }
        if (this.comboMapped.getSelectionIndex() != -1) {
            mapAnnotationIndices.put(CSVEditor.Annotation.ANNOTATION_MAPPED.getKey(), this.csvEditor.getColumnIndexForName(this.comboMapped.getText()));
        }
        if (this.comboMappedPlus.getSelectionIndex() != -1) {
            mapAnnotationIndices.put(CSVEditor.Annotation.ANNOTATION_MAPPED_PLUS.getKey(), this.csvEditor.getColumnIndexForName(this.comboMappedPlus.getText()));
        }
        this.csvEditor.setMapAnnotationColors(mapAnnotationColors);
        this.csvEditor.setMapAnnotationIndices(mapAnnotationIndices);
    }
}

