/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.csveditor.editors.CSVEditorInput;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.javabiotoolkit.exceptions.FastaReaderNotParsedException;
import com.biotechvana.javabiotoolkit.io.FASTAFileRecord;
import com.biotechvana.javabiotoolkit.io.FASTAReader;
import com.biotechvana.utils.PreferenceManager;
import com.biotechvana.utils.TermMatcher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;

public class CSVFastaOpenDialog
extends TitleAreaDialog {
    private final String[] FIELD_SEPARATORS = new String[]{"None", "|", ";", ",", "Tab", "Space"};
    private final String[] FILTER_NAMES = new String[]{"Comma separated values files (*.csv)", "All file types (*.*)"};
    private final String[] FILTER_EXTS = new String[]{"*.csv", "*.*"};
    private Label labelInput;
    private Label labelSeparator;
    private Label labelSeparatorOther;
    private Label labelPreview;
    private Text textInput;
    private Text textSeparatorOther;
    private Button buttonInput;
    private Combo comboFieldSeparator;
    private String csvFile;
    private TableViewer tableViewer;

    public CSVFastaOpenDialog(Shell parentShell, String csvFile) {
        super(parentShell);
        this.csvFile = csvFile;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Composite compositeArea = new Composite(composite, 0);
        GridLayout layoutArea = new GridLayout(3, false);
        compositeArea.setLayout((Layout)layoutArea);
        compositeArea.setLayoutData((Object)new GridData(768));
        this.labelInput = new Label(compositeArea, 0);
        this.labelInput.setText("Input file:");
        GridData layoutData = new GridData();
        this.labelInput.setLayoutData((Object)layoutData);
        this.textInput = new Text(compositeArea, 2052);
        if (this.csvFile != null) {
            this.textInput.setText(this.csvFile);
        }
        layoutData = new GridData(768);
        this.textInput.setLayoutData((Object)layoutData);
        this.buttonInput = new Button(compositeArea, 8);
        this.buttonInput.setText("Browse");
        this.buttonInput.setImage(SharedImages.FOLDER);
        layoutData = new GridData();
        this.buttonInput.setLayoutData((Object)layoutData);
        this.labelSeparator = new Label(compositeArea, 0);
        this.labelSeparator.setText("Field separator:");
        layoutData = new GridData();
        this.labelSeparator.setLayoutData((Object)layoutData);
        this.createFieldSeparatorComposite(compositeArea);
        this.labelPreview = new Label(compositeArea, 0);
        this.labelPreview.setText("File preview:");
        layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        this.labelPreview.setLayoutData((Object)layoutData);
        this.tableViewer = new TableViewer(compositeArea, 2816);
        layoutData = new GridData(768);
        layoutData.heightHint = 200;
        layoutData.widthHint = 300;
        layoutData.horizontalSpan = 3;
        this.tableViewer.getTable().setLayoutData((Object)layoutData);
        this.tableViewer.getTable().setLinesVisible(true);
        this.updatePreview();
        this.buttonInput.addSelectionListener((SelectionListener)new BrowseInputListener());
        return super.createDialogArea(parent);
    }

    private void addProviders() {
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList model = (ArrayList)inputElement;
                return model.toArray();
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                String[] el = (String[])element;
                return el[columnIndex];
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
    }

    private void createFieldSeparatorComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)layoutData);
        this.comboFieldSeparator = new Combo(composite, 12);
        this.comboFieldSeparator.setItems(this.FIELD_SEPARATORS);
        this.comboFieldSeparator.select(1);
        layoutData = new GridData();
        this.comboFieldSeparator.setLayoutData((Object)layoutData);
        this.labelSeparatorOther = new Label(composite, 0);
        this.labelSeparatorOther.setText("Other:");
        layoutData = new GridData();
        this.labelSeparatorOther.setLayoutData((Object)layoutData);
        this.textSeparatorOther = new Text(composite, 2052);
        layoutData = new GridData(768);
        this.textSeparatorOther.setLayoutData((Object)layoutData);
    }

    public void create() {
        super.create();
        this.setTitle("Open fasta file");
        this.setMessage("Open fasta data sheet");
        this.getButton(0).setEnabled(true);
    }

    protected void okPressed() {
        File csvFile = new File(this.textInput.getText());
        String nameFile = FilenameUtils.getBaseName((String)csvFile.getName());
        String ruteCsvFileNew = csvFile.getParent() + "/" + nameFile + ".csv";
        File csvFileNew = new File(ruteCsvFileNew);
        String content = this.getTextEditor(csvFile);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(csvFileNew));
            bw.write(content);
            bw.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            CSVEditorInput input = new CSVEditorInput(csvFileNew, ";".charAt(0), "\"".charAt(0), true, false);
            WorkspaceUtils.openEditor((IEditorInput)input, (String)"com.biotechvana.csveditor.editors.CSVEditor");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    private void browseInput() {
        FileDialog dialog = new FileDialog(this.getShell(), 4);
        dialog.setFilterExtensions(this.FILTER_EXTS);
        dialog.setFilterNames(this.FILTER_NAMES);
        dialog.setFilterPath(PreferenceManager.getInstance().get("workspace", ""));
        String res = dialog.open();
        if (res == null) {
            return;
        }
        this.textInput.setText(res);
    }

    private void updatePreview() {
        if (!this.textInput.getText().isEmpty()) {
            if (!new File(this.textInput.getText()).exists()) {
                return;
            }
            this.getPreview(this.textInput.getText());
        }
    }

    private String getTextEditor(File csvFile) {
        FASTAReader fastaReader = null;
        StringBuilder textEditor = new StringBuilder();
        try {
            fastaReader = new FASTAReader(csvFile);
            fastaReader.parse();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String separator = null;
        separator = this.textSeparatorOther.getText().isEmpty() ? TermMatcher.escapeTerm((String)this.comboFieldSeparator.getItem(this.comboFieldSeparator.getSelectionIndex())) : TermMatcher.escapeTerm((String)this.textSeparatorOther.getText());
        String[] text = null;
        int counter = 0;
        try {
            for (FASTAFileRecord headers : fastaReader.getFastaRecords()) {
                try {
                    text = headers.loadDescription().replace(">", "").split(separator);
                    if (counter == 0) {
                        int i = 0;
                        while (i < text.length) {
                            textEditor.append("\"Column_" + i + "\";");
                            ++i;
                        }
                        textEditor.append("\n");
                    }
                    String[] stringArray = text;
                    int n = text.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String st = stringArray[n2];
                        textEditor.append("\"" + st + "\";");
                        ++n2;
                    }
                    textEditor.append("\n");
                    ++counter;
                }
                catch (FileNotFoundException exception) {
                    exception.printStackTrace();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (FastaReaderNotParsedException exception) {
            exception.printStackTrace();
        }
        return textEditor.toString();
    }

    private void getPreview(String fileName) {
        int MAX_LINES = 10;
        ArrayList<String[]> listPreview = new ArrayList<String[]>();
        File csvFile = new File(fileName);
        FASTAReader fastaReader = null;
        try {
            fastaReader = new FASTAReader(csvFile);
            fastaReader.parse();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int counter = 1;
        String header = null;
        String separator = null;
        separator = this.textSeparatorOther.getText().isEmpty() ? TermMatcher.escapeTerm((String)this.comboFieldSeparator.getItem(this.comboFieldSeparator.getSelectionIndex())) : TermMatcher.escapeTerm((String)this.textSeparatorOther.getText());
        try {
            for (FASTAFileRecord headers : fastaReader.getFastaRecords()) {
                if (counter <= 10) {
                    header = headers.loadDescription().replace(">", "");
                    listPreview.add(header.split(separator));
                    ++counter;
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException exception) {
            exception.printStackTrace();
        }
        catch (FastaReaderNotParsedException exception) {
            exception.printStackTrace();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        int numcols = ((String[])listPreview.get(0)).length;
        int i = 0;
        while (i < numcols) {
            TableViewerColumn tc = new TableViewerColumn(this.tableViewer, 0);
            tc.getColumn().setWidth(100);
            ++i;
        }
        this.addProviders();
        this.tableViewer.setInput(listPreview);
    }

    class BrowseInputListener
    implements SelectionListener {
        BrowseInputListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CSVFastaOpenDialog.this.browseInput();
            CSVFastaOpenDialog.this.updatePreview();
        }
    }
}

