/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.taxonomy.AddAnnotationsToCSVRunnable;
import com.biotechvana.e3utils.MultiFileInput;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AnnotationDialog
extends TitleAreaDialog {
    private final String TITLE = "Annoatate worksheet";
    private CSVEditor csvEditor;
    private Button buttonAppendGO;
    private Button buttonAppendEvidence;
    private Button buttonAppendEnzime;
    private Button buttonAppendGenbankAccession;
    private Button buttonAppendSwissprotAccession;
    private Button buttonAppendUniprotAccession;
    private Button buttonAppendGeneName;
    private Button buttonAppendGi;
    private Button buttonAppendInterpro;
    private Combo comboInput;
    private Combo comboType;
    private final String TYPE_GI = "GI";
    private final String TYPE_SWISSPROT_ACCESSION = "SwissProt accession";
    private final String TYPE_UNIPROT_ACCESSION = "UniProt accession";
    private final String TYPE_GENBANK = "GenBank accession";
    private final String TYPE_DESCRIPTION = "Description";
    private final String TYPE_GO = "GO";
    private MultiFileInput multifileInput;

    public AnnotationDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    public void create() {
        super.create();
        this.setTitle("Annoatate worksheet");
        this.setMessage("Append annotation data");
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        parent.getShell().setText("Annoatate worksheet");
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        composite.setLayout((Layout)layout);
        this.multifileInput = new MultiFileInput(composite, 0, this.csvEditor.getCsvFile());
        this.multifileInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group groupInput = this.createInputGroup(composite);
        groupInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)groupInput.getLayoutData()).verticalIndent = 10;
        Group groupOutput = this.createOutputGroup(composite);
        groupOutput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)groupOutput.getLayoutData()).verticalIndent = 10;
        this.disableAll();
        return compositeParent;
    }

    private Group createInputGroup(Composite parent) {
        Group groupInput = new Group(parent, 0);
        groupInput.setText("Source data column:");
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        groupInput.setLayout((Layout)layout);
        String[] columNames = this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false);
        Label label = new Label((Composite)groupInput, 0);
        label.setText("Colum name: ");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboInput = new Combo((Composite)groupInput, 2060);
        this.comboInput.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboInput.setItems(columNames);
        this.comboInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnnotationDialog.this.disableAll();
                AnnotationDialog.this.activateOptions();
            }
        });
        label = new Label((Composite)groupInput, 0);
        label.setText("Data type:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboType = new Combo((Composite)groupInput, 2060);
        this.comboType.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboType.setItems(new String[]{"GI", "SwissProt accession", "UniProt accession", "GenBank accession", "Description", "GO"});
        this.comboType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnnotationDialog.this.disableAll();
                AnnotationDialog.this.activateOptions();
            }
        });
        return groupInput;
    }

    private void activateOptions() {
        String selected = this.comboType.getText();
        if (selected.equalsIgnoreCase("GI")) {
            this.buttonAppendSwissprotAccession.setEnabled(true);
            this.buttonAppendUniprotAccession.setEnabled(true);
            this.buttonAppendGeneName.setEnabled(true);
            this.buttonAppendGO.setEnabled(true);
        } else if (selected.equalsIgnoreCase("SwissProt accession")) {
            this.buttonAppendGi.setEnabled(true);
            this.buttonAppendUniprotAccession.setEnabled(true);
            this.buttonAppendGO.setEnabled(true);
        } else if (selected.equalsIgnoreCase("UniProt accession")) {
            this.buttonAppendGi.setEnabled(true);
            this.buttonAppendSwissprotAccession.setEnabled(true);
            this.buttonAppendGO.setEnabled(true);
            this.buttonAppendInterpro.setEnabled(true);
            this.buttonAppendGeneName.setEnabled(true);
        } else if (selected.equalsIgnoreCase("GenBank accession")) {
            this.buttonAppendGeneName.setEnabled(true);
        } else if (selected.equalsIgnoreCase("Description")) {
            this.buttonAppendGO.setEnabled(true);
        } else if (selected.equalsIgnoreCase("GO")) {
            this.buttonAppendEnzime.setEnabled(true);
            this.buttonAppendSwissprotAccession.setEnabled(true);
            this.buttonAppendUniprotAccession.setEnabled(true);
        }
    }

    private Group createOutputGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Append data from: ");
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        this.buttonAppendGi = new Button((Composite)group, 32);
        this.buttonAppendGi.setText("GI");
        this.buttonAppendGi.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonAppendGO = new Button((Composite)group, 32);
        this.buttonAppendGO.setText("GO");
        this.buttonAppendGO.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonAppendEvidence = new Button((Composite)group, 32);
        this.buttonAppendEvidence.setText("Evidence codes");
        this.buttonAppendEvidence.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonAppendEnzime = new Button((Composite)group, 32);
        this.buttonAppendEnzime.setText("Enzyme codes");
        this.buttonAppendEnzime.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonAppendGenbankAccession = new Button((Composite)group, 32);
        this.buttonAppendGenbankAccession.setText("GeneBank accession");
        this.buttonAppendGenbankAccession.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonAppendSwissprotAccession = new Button((Composite)group, 32);
        this.buttonAppendSwissprotAccession.setText("SwissProt accession");
        this.buttonAppendSwissprotAccession.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonAppendUniprotAccession = new Button((Composite)group, 32);
        this.buttonAppendUniprotAccession.setText("UniProt accession");
        this.buttonAppendUniprotAccession.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonAppendGeneName = new Button((Composite)group, 32);
        this.buttonAppendGeneName.setText("Gene name");
        this.buttonAppendGeneName.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonAppendInterpro = new Button((Composite)group, 32);
        this.buttonAppendInterpro.setText("InterPro");
        this.buttonAppendInterpro.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Label label = new Label((Composite)group, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        final Button buttonCheckAll = new Button((Composite)group, 32);
        buttonCheckAll.setText("Check all available options");
        buttonCheckAll.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 3, 1));
        buttonCheckAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnnotationDialog.this.checkAllAvailableOptions(buttonCheckAll.getSelection());
            }
        });
        return group;
    }

    private void disableAll() {
        this.buttonAppendGi.setEnabled(false);
        this.buttonAppendGO.setEnabled(false);
        this.buttonAppendEvidence.setEnabled(false);
        this.buttonAppendEnzime.setEnabled(false);
        this.buttonAppendGenbankAccession.setEnabled(false);
        this.buttonAppendSwissprotAccession.setEnabled(false);
        this.buttonAppendUniprotAccession.setEnabled(false);
        this.buttonAppendGeneName.setEnabled(false);
        this.buttonAppendInterpro.setEnabled(false);
        this.buttonAppendGi.setSelection(false);
        this.buttonAppendGO.setSelection(false);
        this.buttonAppendEvidence.setSelection(false);
        this.buttonAppendEnzime.setSelection(false);
        this.buttonAppendGenbankAccession.setSelection(false);
        this.buttonAppendSwissprotAccession.setSelection(false);
        this.buttonAppendUniprotAccession.setSelection(false);
        this.buttonAppendGeneName.setSelection(false);
        this.buttonAppendInterpro.setSelection(false);
    }

    private void checkAllAvailableOptions(boolean enable) {
        if (this.buttonAppendGi.isEnabled()) {
            this.buttonAppendGi.setSelection(enable);
        }
        if (this.buttonAppendGO.isEnabled()) {
            this.buttonAppendGO.setSelection(enable);
        }
        if (this.buttonAppendEvidence.isEnabled()) {
            this.buttonAppendEvidence.setSelection(enable);
        }
        if (this.buttonAppendEnzime.isEnabled()) {
            this.buttonAppendEnzime.setSelection(enable);
        }
        if (this.buttonAppendGenbankAccession.isEnabled()) {
            this.buttonAppendGenbankAccession.setSelection(enable);
        }
        if (this.buttonAppendSwissprotAccession.isEnabled()) {
            this.buttonAppendSwissprotAccession.setSelection(enable);
        }
        if (this.buttonAppendUniprotAccession.isEnabled()) {
            this.buttonAppendUniprotAccession.setSelection(enable);
        }
        if (this.buttonAppendGeneName.isEnabled()) {
            this.buttonAppendGeneName.setSelection(enable);
        }
        if (this.buttonAppendInterpro.isEnabled()) {
            this.buttonAppendInterpro.setSelection(enable);
        }
    }

    protected void okPressed() {
        if (!this.validate()) {
            return;
        }
        try {
            this.run();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Annoatate worksheet", (String)("Failed: " + e.getMessage()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.okPressed();
    }

    private boolean validate() {
        if (!this.validateInput()) {
            return false;
        }
        if (this.getInputDataType() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Annoatate worksheet", (String)"Invalid data type selected");
            return false;
        }
        if (!this.validateAppendData()) {
            return false;
        }
        if (this.multifileInput.getOutputPath().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Annoatate worksheet", (String)"Invalid output folder");
            return false;
        }
        return true;
    }

    private boolean validateAppendData() {
        if (!(this.buttonAppendGi.getSelection() || this.buttonAppendGO.getSelection() || this.buttonAppendEvidence.getSelection() || this.buttonAppendEnzime.getSelection() || this.buttonAppendGenbankAccession.getSelection() || this.buttonAppendSwissprotAccession.getSelection() || this.buttonAppendUniprotAccession.getSelection() || this.buttonAppendGeneName.getSelection() || this.buttonAppendInterpro.getSelection())) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Annoatate worksheet", (String)"Select append data");
            return false;
        }
        return true;
    }

    private boolean validateInput() {
        if (this.comboInput.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Annoatate worksheet", (String)"Select input column");
            return false;
        }
        return true;
    }

    private int getInputDataType() {
        String selected = this.comboType.getText();
        if (selected.equalsIgnoreCase("GI")) {
            return 0;
        }
        if (selected.equalsIgnoreCase("swissprot accession")) {
            return 3;
        }
        if (selected.equalsIgnoreCase("Uniprot accession")) {
            return 8;
        }
        if (selected.equalsIgnoreCase("Genbank accession")) {
            return 2;
        }
        if (selected.equalsIgnoreCase("Description")) {
            return 1;
        }
        if (selected.equalsIgnoreCase("GO")) {
            return 5;
        }
        return -1;
    }

    private List<Integer> getOutputDataTypes() {
        ArrayList<Integer> listOutputDataTypes = new ArrayList<Integer>();
        if (this.buttonAppendGi.getSelection()) {
            listOutputDataTypes.add(0);
        }
        if (this.buttonAppendGO.getSelection()) {
            listOutputDataTypes.add(5);
        }
        if (this.buttonAppendEvidence.getSelection()) {
            listOutputDataTypes.add(6);
        }
        if (this.buttonAppendEnzime.getSelection()) {
            listOutputDataTypes.add(7);
        }
        if (this.buttonAppendGenbankAccession.getSelection()) {
            listOutputDataTypes.add(2);
        }
        if (this.buttonAppendSwissprotAccession.getSelection()) {
            listOutputDataTypes.add(3);
        }
        if (this.buttonAppendUniprotAccession.getSelection()) {
            listOutputDataTypes.add(8);
        }
        if (this.buttonAppendGeneName.getSelection()) {
            listOutputDataTypes.add(4);
        }
        if (this.buttonAppendInterpro.getSelection()) {
            listOutputDataTypes.add(9);
        }
        return listOutputDataTypes;
    }

    private void run() throws InvocationTargetException, InterruptedException {
        AddAnnotationsToCSVRunnable runnable = new AddAnnotationsToCSVRunnable(this.multifileInput.getInputFileList(), new File(this.multifileInput.getOutputPath()), this.comboInput.getSelectionIndex(), this.getInputDataType(), this.getOutputDataTypes());
        new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)runnable);
    }
}

