/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.taxonomy.AddEnzymeCodesByGoHTTPRunnable;
import com.biotechvana.csveditor.model.CsvEditor.CSVLabelProvider;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddEnzymeCodesByGoDialog
extends TitleAreaDialog {
    public static final String TITLE = "Enzyme codes";
    private CSVEditor csvEditor;
    private Combo comboColumns;

    public AddEnzymeCodesByGoDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    public void create() {
        super.create();
        this.setTitle(TITLE);
        this.setMessage("Add Enzyme codes by GO terms");
        this.getButton(0).setEnabled(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        this.getShell().setText(TITLE);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label labelColumn = new Label(composite, 0);
        labelColumn.setText("Gene Ontology codes column:");
        GridData layoutData = new GridData();
        labelColumn.setLayoutData((Object)layoutData);
        this.comboColumns = new Combo(composite, 8);
        this.comboColumns.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true));
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.comboColumns.setLayoutData((Object)layoutData);
        this.addListeners();
        return composite;
    }

    private void addListeners() {
    }

    protected void okPressed() {
        try {
            this.run();
        }
        catch (InvocationTargetException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)("Failed processing:" + e.getMessage()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.okPressed();
    }

    private void run() throws InvocationTargetException, InterruptedException {
        if (!this.validate()) {
            return;
        }
        int columnIndex = this.comboColumns.getSelectionIndex();
        this.csvEditor.createColumns(new String[]{"Enzyme code"}, this.csvEditor.getColumnCount(), true, true);
        this.csvEditor.getTableViewer().setLabelProvider((IBaseLabelProvider)new CSVLabelProvider());
        AddEnzymeCodesByGoHTTPRunnable runnable = new AddEnzymeCodesByGoHTTPRunnable(this.csvEditor, columnIndex + 2);
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)"Connection with server was lost. Please, try again.");
        }
        this.csvEditor.setModified(true);
    }

    private boolean validate() {
        if (this.comboColumns.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)"Gene ontology column cannot be empty");
            return false;
        }
        return true;
    }
}

