/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class MemoryDialog
extends Dialog {
    private int memory;
    private int lineCount;
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");

    public MemoryDialog(Shell parentShell, int memory, int lineCount) {
        super(parentShell);
        this.memory = memory;
        this.lineCount = lineCount;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.getShell().setText("Memory configuration");
        try {
            final URL url = new URL(System.getProperty("eclipse.home.location"));
            Link link = new Link(composite, 0);
            link.setText("The current memory configuration (" + this.decimalFormat.format(this.memory) + "MB) may be insufficient for opening a worksheet containing \nmore than " + this.decimalFormat.format(this.lineCount) + " records.\n\nPlease, <a>click here to edit the configuration file named GPRO.ini</a> to allocate a larger memory size \ndepending on your system's physical available memory.\n\nYou can edit the -XmxNNm parameter, where NN represents the maximum amount of memory (in MB) \nassigned to this application.\n\nSuggested values are:\n    >10.000 sequences => -Xmx512m\n    >30.000 sequences => -Xmx1000m\n    >50.000 sequences => -Xmx2000m\n    >80.000 sequences => -Xmx3000m\n\nLarger memory sizes than 4.000MB can only be set in 64 bit operating systems.\n\nFinally, you must restart the GPRO application for applying your new settings.");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        Program.launch((String)url.getPath());
                    }
                    catch (Exception ex) {
                        try {
                            Program.launch((String)System.getProperty("eclipse.home.location"));
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                        }
                        ex.printStackTrace();
                    }
                }
            });
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        return compositeParent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Ignore and continue anyway", false);
        this.createButton(parent, 1, "Close", true);
    }
}

