/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.csvEditor.dialogs;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvMergeSequencesRunnable;
import com.biotechvana.utils.FilenameUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CsvMergeSequencesComposite
extends Composite {
    private CSVEditor csvEditor;
    private Text textFileFasta;
    private Text textFileCsv;
    private Text textOutputFolder;
    private Combo comboSequenceName;
    private Combo comboAnnotation;
    private Combo comboQueryFrom;
    private Combo comboQueryTo;
    private Combo comboHitFrom;
    private Combo comboHitTo;
    private Combo comboQueryLen;
    private Combo comboHitLen;
    private Combo comboQueryFrame;
    private Text textIdentityThreshold;
    private Text textTrimTerminals;
    private Button buttonNonOverlapping;

    public CsvMergeSequencesComposite(Composite parent, CSVEditor csvEditor) {
        super(parent, 0);
        this.csvEditor = csvEditor;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        this.setLayout((Layout)layout);
        Group groupInput = this.createInputComposite(this);
        groupInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group groupColumns = this.createColumnComposite(this);
        groupColumns.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group groupMerge = this.createMergeGroup(this);
        groupMerge.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)groupMerge.getLayoutData()).verticalIndent = 10;
    }

    private Group createInputComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Input columns");
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText("Input CSV:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textFileCsv = new Text((Composite)group, 2060);
        this.textFileCsv.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.csvEditor != null) {
            this.textFileCsv.setText(this.csvEditor.getCsvFile().getAbsolutePath());
        }
        Button button = new Button((Composite)group, 0);
        button.setText("Browse");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String res;
                FileDialog dialog = new FileDialog(CsvMergeSequencesComposite.this.getShell(), 4096);
                if (CsvMergeSequencesComposite.this.csvEditor != null) {
                    dialog.setFilterPath(CsvMergeSequencesComposite.this.csvEditor.getCsvFile().getParent());
                }
                if ((res = dialog.open()) != null) {
                    CsvMergeSequencesComposite.this.textFileCsv.setText(res);
                    CsvMergeSequencesComposite.this.textFileCsv.setSelection(res.length());
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Input FASTA:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textFileFasta = new Text((Composite)group, 2060);
        this.textFileFasta.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button = new Button((Composite)group, 0);
        button.setText("Browse");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String res;
                FileDialog dialog = new FileDialog(CsvMergeSequencesComposite.this.getShell(), 4096);
                if (!CsvMergeSequencesComposite.this.textFileCsv.getText().isEmpty()) {
                    dialog.setFilterPath(FilenameUtils.getPath((String)CsvMergeSequencesComposite.this.textFileCsv.getText()));
                }
                if ((res = dialog.open()) != null) {
                    CsvMergeSequencesComposite.this.textFileFasta.setText(res);
                    CsvMergeSequencesComposite.this.textFileFasta.setSelection(res.length());
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Output folder:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textOutputFolder = new Text((Composite)group, 2060);
        this.textOutputFolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (!this.textFileCsv.getText().isEmpty()) {
            this.textOutputFolder.setText(FilenameUtils.getPath((String)this.textFileCsv.getText()));
        }
        button = new Button((Composite)group, 0);
        button.setText("Browse");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String res;
                DirectoryDialog dialog = new DirectoryDialog(CsvMergeSequencesComposite.this.getShell(), 4096);
                if (!CsvMergeSequencesComposite.this.textFileCsv.getText().isEmpty()) {
                    dialog.setFilterPath(FilenameUtils.getPath((String)CsvMergeSequencesComposite.this.textFileCsv.getText()));
                }
                if ((res = dialog.open()) != null) {
                    CsvMergeSequencesComposite.this.textOutputFolder.setText(res);
                    CsvMergeSequencesComposite.this.textOutputFolder.setSelection(res.length());
                }
            }
        });
        return group;
    }

    private Group createColumnComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Input columns");
        GridLayout layout = new GridLayout(8, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        group.setLayout((Layout)layout);
        int comboWidth = 100;
        String[] columnNames = new String[]{};
        if (this.csvEditor != null) {
            columnNames = this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false);
        }
        Label label = new Label((Composite)group, 0);
        label.setText("Sequence:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboSequenceName = new Combo((Composite)group, 12);
        this.comboSequenceName.setItems(columnNames);
        this.comboSequenceName.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboSequenceName.getLayoutData()).widthHint = 100;
        int[] indices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Sequence", "sequence"});
        if (indices.length > 0) {
            this.comboSequenceName.select(indices[0] - 2);
        }
        label = new Label((Composite)group, 0);
        label.setText("Subject:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboAnnotation = new Combo((Composite)group, 12);
        this.comboAnnotation.setItems(columnNames);
        this.comboAnnotation.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboAnnotation.getLayoutData()).widthHint = 100;
        indices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Subject", "subject", "Subject mapping"});
        if (indices.length > 0) {
            this.comboAnnotation.select(indices[0] - 2);
        }
        label = new Label((Composite)group, 0);
        label.setText("Query from:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboQueryFrom = new Combo((Composite)group, 12);
        this.comboQueryFrom.setItems(columnNames);
        this.comboQueryFrom.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboQueryFrom.getLayoutData()).widthHint = 100;
        indices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Query-from", "Query from", "query-from"});
        if (indices.length > 0) {
            this.comboQueryFrom.select(indices[0] - 2);
        }
        label = new Label((Composite)group, 0);
        label.setText("Query to:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboQueryTo = new Combo((Composite)group, 12);
        this.comboQueryTo.setItems(columnNames);
        this.comboQueryTo.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboQueryTo.getLayoutData()).widthHint = 100;
        indices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Query-to", "Query to", "query-to"});
        if (indices.length > 0) {
            this.comboQueryTo.select(indices[0] - 2);
        }
        label = new Label((Composite)group, 0);
        label.setText("Hit from:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboHitFrom = new Combo((Composite)group, 12);
        this.comboHitFrom.setItems(columnNames);
        this.comboHitFrom.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboHitFrom.getLayoutData()).widthHint = 100;
        indices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Subject-from", "Subject from", "subject-from"});
        if (indices.length > 0) {
            this.comboHitFrom.select(indices[0] - 2);
        }
        label = new Label((Composite)group, 0);
        label.setText("Hit to:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboHitTo = new Combo((Composite)group, 12);
        this.comboHitTo.setItems(columnNames);
        this.comboHitTo.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboHitTo.getLayoutData()).widthHint = 100;
        indices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Subject-to", "Subject to", "subject-to"});
        if (indices.length > 0) {
            this.comboHitTo.select(indices[0] - 2);
        }
        label = new Label((Composite)group, 0);
        label.setText("Query len:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboQueryLen = new Combo((Composite)group, 12);
        this.comboQueryLen.setItems(columnNames);
        this.comboQueryLen.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboQueryLen.getLayoutData()).widthHint = 100;
        indices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Query length", "Query len", "query length", "query len"});
        if (indices.length > 0) {
            this.comboQueryLen.select(indices[0] - 2);
        }
        label = new Label((Composite)group, 0);
        label.setText("Hit len:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboHitLen = new Combo((Composite)group, 12);
        this.comboHitLen.setItems(columnNames);
        this.comboHitLen.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboHitLen.getLayoutData()).widthHint = 100;
        indices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Hit length", "Hit len", "hit length", "hit len"});
        if (indices.length > 0) {
            this.comboHitLen.select(indices[0] - 2);
        }
        label = new Label((Composite)group, 0);
        label.setText("Query frame:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboQueryFrame = new Combo((Composite)group, 12);
        this.comboQueryFrame.setItems(columnNames);
        this.comboQueryFrame.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.comboQueryFrame.getLayoutData()).widthHint = 100;
        indices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Query frame", "query frame"});
        if (indices.length > 0) {
            this.comboQueryFrame.select(indices[0] - 2);
        }
        return group;
    }

    private Group createMergeGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Merging options");
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText("Identity threshold for merging (minimum 90%)");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textIdentityThreshold = new Text((Composite)group, 2052);
        this.textIdentityThreshold.setText("100");
        this.textIdentityThreshold.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.textIdentityThreshold.getLayoutData()).widthHint = 100;
        label = new Label((Composite)group, 0);
        label.setText("%");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label = new Label((Composite)group, 0);
        label.setText("Trim N (up to 10) nucleotides at 3' and 5' ends before aligning");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textTrimTerminals = new Text((Composite)group, 2052);
        this.textTrimTerminals.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        ((GridData)this.textTrimTerminals.getLayoutData()).widthHint = 100;
        this.textTrimTerminals.setText("0");
        this.buttonNonOverlapping = new Button((Composite)group, 32);
        this.buttonNonOverlapping.setText("Merge also non overlapping sequences (Gaps will be filled with Ns)");
        this.buttonNonOverlapping.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        return group;
    }

    public boolean validate() {
        int value;
        if (this.textFileCsv.getText().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Input CSV cannot be empty");
            return false;
        }
        if (this.textFileFasta.getText().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Input FASTA cannot be empty");
            return false;
        }
        if (this.comboSequenceName.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Sequence name column cannot be empty");
            return false;
        }
        if (this.comboAnnotation.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Annotation column cannot be empty");
            return false;
        }
        if (this.comboQueryFrom.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Query-from column cannot be empty");
            return false;
        }
        if (this.comboQueryTo.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Query-to column cannot be empty");
            return false;
        }
        if (this.comboHitFrom.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Hit-from column cannot be empty");
            return false;
        }
        if (this.comboHitTo.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Hit-to column cannot be empty");
            return false;
        }
        if (this.comboQueryLen.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Query-len column cannot be empty");
            return false;
        }
        if (this.comboHitLen.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Hit-len column cannot be empty");
            return false;
        }
        if (this.comboQueryFrame.getSelectionIndex() == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Query-frame column cannot be empty");
            return false;
        }
        try {
            value = Integer.parseInt(this.textIdentityThreshold.getText());
            if (value < 90 || value > 100) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Invalid identity threshold value");
                return false;
            }
        }
        catch (Exception ex) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Invalid identity threshold value");
            return false;
        }
        try {
            value = Integer.parseInt(this.textTrimTerminals.getText());
            if (value < 0 || value > 10) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Invalid trim value");
                return false;
            }
        }
        catch (Exception ex) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Invalid trim value");
            return false;
        }
        return true;
    }

    public void run() {
        CsvMergeSequencesRunnable runnable = new CsvMergeSequencesRunnable(new File(this.textFileFasta.getText()), new File(this.textFileCsv.getText()), new File(this.textOutputFolder.getText()), this.comboSequenceName.getSelectionIndex(), this.comboAnnotation.getSelectionIndex(), this.comboQueryFrom.getSelectionIndex(), this.comboQueryTo.getSelectionIndex(), this.comboHitFrom.getSelectionIndex(), this.comboHitTo.getSelectionIndex(), this.comboQueryLen.getSelectionIndex(), this.comboHitLen.getSelectionIndex(), this.comboQueryFrame.getSelectionIndex(), Float.parseFloat(this.textIdentityThreshold.getText()), this.buttonNonOverlapping.getSelection(), Integer.parseInt(this.textTrimTerminals.getText()));
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Merge sequences", (String)("Error found: " + e.getMessage()));
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

