/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.csvEditor.dialogs;

import com.biotechvana.csveditor.csvEditor.dialogs.CsvCurationAdvancedFilter;
import com.biotechvana.csveditor.editors.CSVEditor;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CsvCurationFilterComposite
extends Composite {
    private Combo comboCol;
    private Text textRename;
    private Button buttonRegexp;
    private Text textFilter;
    private Button buttonConcatenated;
    private Button buttonRepeats;

    public CsvCurationFilterComposite(Composite parent, CSVEditor csvEditor) {
        super(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        this.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1, 128, false, false));
        Label labelColName = new Label(composite, 0);
        labelColName.setText("Column:");
        labelColName.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboCol = new Combo(composite, 12);
        this.comboCol.setItems(csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false));
        this.comboCol.setLayoutData((Object)new GridData(1, 128, false, false));
        Label labelRename = new Label(composite, 0);
        labelRename.setText("New name(optional):");
        labelRename.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textRename = new Text(composite, 2052);
        this.textRename.setLayoutData((Object)new GridData(4, 128, true, false));
        composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        Label labelFilter = new Label(composite, 0);
        labelFilter.setText("Terms:");
        labelFilter.setLayoutData((Object)new GridData(1, 128, false, false));
        this.textFilter = new Text(composite, 2818);
        this.textFilter.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        ((GridData)this.textFilter.getLayoutData()).heightHint = 80;
        Label label = new Label(composite, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonRegexp = new Button(composite, 32);
        this.buttonRegexp.setText("Use regular expressions");
        this.buttonRegexp.setLayoutData((Object)new GridData(1, 128, false, false));
        this.buttonRegexp.setSelection(false);
        Link linkHelp = new Link(composite, 0);
        linkHelp.setText("<a>Help</a>");
        linkHelp.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        linkHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HelpDialog dialog = new HelpDialog(CsvCurationFilterComposite.this.getShell());
                dialog.open();
            }
        });
        label = new Label(composite, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonConcatenated = new Button(composite, 32);
        this.buttonConcatenated.setText("Search list of concatenated terms in fixed order");
        this.buttonConcatenated.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.buttonConcatenated.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        label = new Label(composite, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonRepeats = new Button(composite, 32);
        this.buttonRepeats.setText("When concatenated, allow repeats of terms");
        this.buttonRepeats.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
    }

    public void enableAdvancedOptions(boolean enable) {
        this.comboCol.setEnabled(enable);
        this.textRename.setEnabled(enable);
        this.buttonRegexp.setEnabled(enable);
        this.textFilter.setEnabled(enable);
        this.buttonConcatenated.setEnabled(enable);
        this.buttonRepeats.setEnabled(enable);
    }

    public int getColumnIndex() {
        return this.comboCol.getSelectionIndex();
    }

    public String getNewName() {
        return this.textRename.getText();
    }

    public boolean useRegexp() {
        return this.buttonRegexp.getSelection();
    }

    public List<String> getListTerms() {
        String[] arrayTerms;
        ArrayList<String> listTerms = new ArrayList<String>();
        String[] stringArray = arrayTerms = this.textFilter.getText().split("\n");
        int n = arrayTerms.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (!t.trim().isEmpty()) {
                listTerms.add(t);
            }
            ++n2;
        }
        return listTerms;
    }

    public boolean getRepeat() {
        return this.buttonRepeats.getSelection();
    }

    public boolean getConcatenated() {
        return this.buttonConcatenated.getSelection();
    }

    public boolean isValid() {
        if (this.comboCol.getSelectionIndex() == -1) {
            return false;
        }
        return !this.textFilter.getText().trim().isEmpty();
    }

    public CsvCurationAdvancedFilter getFilter() {
        CsvCurationAdvancedFilter filter = new CsvCurationAdvancedFilter();
        filter.column = this.getColumnIndex();
        filter.rename = this.getNewName();
        filter.regexp = this.useRegexp();
        filter.terms = this.getListTerms();
        filter.repeat = this.getRepeat();
        filter.concatenated = this.getConcatenated();
        return filter;
    }

    private class HelpDialog
    extends TitleAreaDialog {
        public HelpDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(composite, 0);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            container.setLayout((Layout)layout);
            Label label = new Label(container, 64);
            label.setText("Examples:\n\tterm_\\d+ --> mathes term_1, term_2, term_200...\n\tterm_1\\d --> matches term_10, term_11, term_12...term_19\n\tterm_[a-z]{2,} --> matches term_aa, term_ab, term_zz...\n\tterm_[x|y]a --> matches term_xa and term_y\n\t^a.+ --> starts with a and followed by any other chars\n\t.+z$ --> char sequence finished by z");
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Link linkMore = new Link(container, 0);
            linkMore.setText("<a>Know more about regular expressions syntax</a>");
            linkMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(new URI("http://perldoc.perl.org/perlreref.html"));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        catch (URISyntaxException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            linkMore.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
            ((GridData)linkMore.getLayoutData()).verticalIndent = 20;
            return composite;
        }

        public void create() {
            super.create();
            this.setTitle("Regular expressions help");
            this.setMessage("A short guide on using regular expressions");
        }
    }
}

