/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.csvEditor.dialogs;

import com.biotechvana.csveditor.csvEditor.dialogs.CsvCurationAdvancedFilter;
import com.biotechvana.csveditor.csvEditor.dialogs.CsvCurationFilterComposite;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvCurationRunnable;
import com.biotechvana.e3utils.MultiFileInput;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CsvCurationComposite
extends Composite {
    private CSVEditor csvEditor;
    private MultiFileInput multifileInput;
    private Combo comboSequenceName;
    private Combo comboAnnotation;
    private Combo comboStart;
    private Combo comboEnd;
    private Combo comboLen;
    private Combo comboFrame;
    private Button buttonUseFrame;
    private Button buttonMergeOverlapping;
    private Button buttonMergeNonOverlapping;
    private Text textNonOverlapping;
    private Button buttonUseAdvanced;
    private Composite compositeWrapper;
    private List<CsvCurationFilterComposite> listFilterComposites;
    private Text textMaxlen;

    public CsvCurationComposite(Composite parent, CSVEditor csvEditor) {
        super(parent, 0);
        this.csvEditor = csvEditor;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        this.setLayout((Layout)layout);
        this.multifileInput = new MultiFileInput((Composite)this, 0, csvEditor.getCsvFile());
        this.multifileInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group groupColumns = this.createColumnComposite(this);
        groupColumns.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group groupMerge = this.createMergeGroup(this);
        groupMerge.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)groupMerge.getLayoutData()).verticalIndent = 10;
        Group groupAdvanced = this.createAdvancedComposite2(this);
        groupAdvanced.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)groupAdvanced.getLayoutData()).heightHint = 340;
    }

    private Group createAdvancedComposite2(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Advanced options");
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        group.setLayout((Layout)layout);
        this.buttonUseAdvanced = new Button((Composite)group, 32);
        this.buttonUseAdvanced.setText("Use advanced filtering");
        this.buttonUseAdvanced.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.buttonUseAdvanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvCurationComposite.this.enableAdvanced();
            }
        });
        Label label = new Label((Composite)group, 0);
        label.setText("Joined sequence maximum length:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textMaxlen = new Text((Composite)group, 2052);
        this.textMaxlen.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.textMaxlen.getLayoutData()).widthHint = 80;
        ScrolledComposite sc = new ScrolledComposite((Composite)group, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ((GridData)sc.getLayoutData()).heightHint = 200;
        sc.setLayout((Layout)new GridLayout(1, false));
        this.compositeWrapper = new Composite((Composite)sc, 0);
        this.compositeWrapper.setLayout((Layout)new GridLayout(1, false));
        this.compositeWrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        sc.setContent((Control)this.compositeWrapper);
        this.compositeWrapper.setSize(this.compositeWrapper.computeSize(-1, -1));
        Button buttonAdd = new Button((Composite)group, 8);
        buttonAdd.setText("Add more term filter criteria");
        buttonAdd.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false, 2, 1));
        buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvCurationComposite.this.addFilterComposite();
            }
        });
        this.addFilterComposite();
        return group;
    }

    private void addFilterComposite() {
        if (this.listFilterComposites == null) {
            this.listFilterComposites = new ArrayList<CsvCurationFilterComposite>();
        }
        CsvCurationFilterComposite composite = new CsvCurationFilterComposite(this.compositeWrapper, this.csvEditor);
        composite.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.enableAdvanced();
        this.compositeWrapper.setSize(this.compositeWrapper.computeSize(-1, -1));
        this.listFilterComposites.add(composite);
    }

    private void enableAdvanced() {
        this.textMaxlen.setEnabled(this.buttonUseAdvanced.getSelection());
        Control[] controlArray = this.compositeWrapper.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof CsvCurationFilterComposite) {
                ((CsvCurationFilterComposite)child).enableAdvancedOptions(this.buttonUseAdvanced.getSelection());
            }
            ++n2;
        }
    }

    private Group createColumnComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Input columns");
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        group.setLayout((Layout)layout);
        Composite compositeLeft = new Composite((Composite)group, 0);
        compositeLeft.setLayout((Layout)new GridLayout(2, false));
        compositeLeft.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Label label = new Label(compositeLeft, 0);
        label.setText("Sequence name:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboSequenceName = new Combo(compositeLeft, 2060);
        this.comboSequenceName.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false));
        this.comboSequenceName.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        int[] indices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Sequence", "scaffold"});
        if (indices != null && indices.length == 1) {
            this.comboSequenceName.select(indices[0] - 2);
        }
        label = new Label(compositeLeft, 0);
        label.setText("Annotation:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboAnnotation = new Combo(compositeLeft, 2060);
        this.comboAnnotation.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false));
        this.comboAnnotation.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        indices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Subject", "Name1", "Annotation"});
        if (indices != null && indices.length == 1) {
            this.comboAnnotation.select(indices[0] - 2);
        }
        Composite compositeMiddle = new Composite((Composite)group, 0);
        compositeMiddle.setLayout((Layout)new GridLayout(2, false));
        compositeMiddle.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Label label2 = new Label(compositeMiddle, 0);
        label2.setText("Start:");
        label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboStart = new Combo(compositeMiddle, 2060);
        this.comboStart.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false));
        this.comboStart.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        int[] indices2 = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Query-from", "start"});
        if (indices2 != null && indices2.length == 1) {
            this.comboStart.select(indices2[0] - 2);
        }
        label2 = new Label(compositeMiddle, 0);
        label2.setText("End:");
        label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboEnd = new Combo(compositeMiddle, 2060);
        this.comboEnd.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false));
        this.comboEnd.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        indices2 = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Query-to", "end"});
        if (indices2 != null && indices2.length == 1) {
            this.comboEnd.select(indices2[0] - 2);
        }
        Composite compositeRight = new Composite((Composite)group, 0);
        compositeRight.setLayout((Layout)new GridLayout(2, false));
        compositeRight.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Label label3 = new Label(compositeRight, 0);
        label3.setText("Length:");
        label3.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboLen = new Combo(compositeRight, 2060);
        this.comboLen.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false));
        this.comboLen.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        int[] indices3 = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Size", "Length", "Len", "size", "len", "length"});
        if (indices3 != null && indices3.length == 1) {
            this.comboLen.select(indices3[0] - 2);
        }
        this.buttonUseFrame = new Button(compositeRight, 32);
        this.buttonUseFrame.setText("Use query frame:");
        this.buttonUseFrame.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboFrame = new Combo(compositeRight, 2060);
        this.comboFrame.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false));
        this.comboFrame.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        indices2 = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Query frame"});
        if (indices2 != null && indices2.length == 1) {
            this.comboFrame.select(indices2[0] - 2);
        }
        return group;
    }

    private Group createMergeGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Merging options");
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        group.setLayout((Layout)layout);
        this.buttonMergeOverlapping = new Button((Composite)group, 16);
        this.buttonMergeOverlapping.setText("Merge overlapping");
        this.buttonMergeOverlapping.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.buttonMergeOverlapping.setSelection(true);
        this.buttonMergeNonOverlapping = new Button((Composite)group, 16);
        this.buttonMergeNonOverlapping.setText("Merge non overlapping");
        this.buttonMergeNonOverlapping.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textNonOverlapping = new Text((Composite)group, 2052);
        this.textNonOverlapping.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.textNonOverlapping.getLayoutData()).widthHint = 80;
        Label label = new Label((Composite)group, 0);
        label.setText("Maximum distance allowed for merging");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        return group;
    }

    public boolean validate() {
        if (this.multifileInput.getInputPath() == null || this.multifileInput.getInputPath().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Invalid input file or folder");
            return false;
        }
        if (this.multifileInput.getOutputPath() == null || this.multifileInput.getOutputPath().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Invalid output");
            return false;
        }
        if (this.buttonMergeNonOverlapping.getSelection() && this.textNonOverlapping.getText().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Invalid maximum distance");
            return false;
        }
        if (this.buttonUseAdvanced.getSelection() && this.textMaxlen.getText().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Invalid maximum length");
            return false;
        }
        return true;
    }

    public void run() {
        if (this.multifileInput.getInputMode() == 1) {
            System.out.println("multi");
            try {
                new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        int useFrame = -1;
                        int maxDistance = -1;
                        if (CsvCurationComposite.this.buttonUseFrame.getSelection()) {
                            useFrame = CsvCurationComposite.this.comboFrame.getSelectionIndex();
                        }
                        if (CsvCurationComposite.this.buttonMergeNonOverlapping.getSelection()) {
                            try {
                                maxDistance = Integer.parseInt(CsvCurationComposite.this.textNonOverlapping.getText().trim());
                            }
                            catch (Exception ex) {
                                MessageDialog.openWarning((Shell)CsvCurationComposite.this.getShell(), (String)"Validation", (String)"Invalid maximum distance");
                            }
                        }
                        File[] totalFiles = CsvCurationComposite.this.multifileInput.getInputFileList();
                        monitor.beginTask("Process files", totalFiles.length);
                        File[] fileArray = totalFiles;
                        int n = totalFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            monitor.subTask(f.getName());
                            CsvCurationRunnable runnable = new CsvCurationRunnable(f, new File(CsvCurationComposite.this.multifileInput.getOutputPath()), CsvCurationComposite.this.comboSequenceName.getSelectionIndex(), CsvCurationComposite.this.comboAnnotation.getSelectionIndex(), CsvCurationComposite.this.comboStart.getSelectionIndex(), CsvCurationComposite.this.comboEnd.getSelectionIndex(), CsvCurationComposite.this.comboLen.getSelectionIndex(), useFrame, maxDistance);
                            if (CsvCurationComposite.this.buttonUseAdvanced.getSelection()) {
                                runnable.setFiltering(CsvCurationComposite.this.getAdvancedFilters(), Integer.parseInt(CsvCurationComposite.this.textMaxlen.getText()));
                            }
                            runnable.run((IProgressMonitor)new NullProgressMonitor());
                            monitor.worked(1);
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            ++n2;
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e1) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e1.getMessage());
                e1.printStackTrace();
            }
            catch (InterruptedException e1) {}
        } else {
            try {
                int useFrame = -1;
                int maxDistance = -1;
                if (this.buttonUseFrame.getSelection()) {
                    useFrame = this.comboFrame.getSelectionIndex();
                }
                if (this.buttonMergeNonOverlapping.getSelection()) {
                    try {
                        maxDistance = Integer.parseInt(this.textNonOverlapping.getText().trim());
                    }
                    catch (Exception ex) {
                        MessageDialog.openWarning((Shell)this.getShell(), (String)"Validation", (String)"Invalid maximum distance");
                    }
                }
                CsvCurationRunnable runnable = new CsvCurationRunnable(this.multifileInput.getFileInput(), new File(this.multifileInput.getOutputPath()), this.comboSequenceName.getSelectionIndex(), this.comboAnnotation.getSelectionIndex(), this.comboStart.getSelectionIndex(), this.comboEnd.getSelectionIndex(), this.comboLen.getSelectionIndex(), useFrame, maxDistance);
                if (this.buttonUseAdvanced.getSelection()) {
                    runnable.setFiltering(this.getAdvancedFilters(), Integer.parseInt(this.textMaxlen.getText()));
                }
                new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"RUN", (String)("Error found: " + e.getMessage()));
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private List<CsvCurationAdvancedFilter> getAdvancedFilters() {
        ArrayList<CsvCurationAdvancedFilter> listFilters = new ArrayList<CsvCurationAdvancedFilter>();
        for (CsvCurationFilterComposite filterComposite : this.listFilterComposites) {
            if (!filterComposite.isValid()) continue;
            listFilters.add(filterComposite.getFilter());
        }
        return listFilters;
    }
}

