/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions.keggViewer;

import com.biotechvana.csveditor.views.KeggViewer;
import com.biotechvana.e3utils.WorkspaceUtils;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class KeggViewerOpenAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String TITLE = "Download KEGG maps";
    public static final int TYPE_EC = 0;
    public static final int TYPE_KEGG = 1;
    private String[] codes;
    private int type;

    public KeggViewerOpenAction(String[] codes, int type) {
        this.setText(TITLE);
        int i = 0;
        while (i < codes.length) {
            codes[i] = codes[i].replace(":", " ");
            ++i;
        }
        this.codes = codes;
        this.type = type;
    }

    public void dispose() {
    }

    public void run() {
        try {
            IViewPart viewPart = WorkspaceUtils.showView((String)"com.biotechvana.gydbpro.views.KeggViewer");
            if (viewPart != null) {
                KeggViewer keggViewer = (KeggViewer)viewPart;
                if (this.type == 0) {
                    ArrayList<String> listKeggs = keggViewer.getKeggsByEc(this.codes);
                    if (listKeggs != null && listKeggs.size() > 0) {
                        keggViewer.addPaths(listKeggs.toArray(new String[listKeggs.size()]));
                    } else {
                        WorkspaceUtils.hideView((String)"com.biotechvana.gydbpro.views.KeggViewer");
                        MessageDialog.openWarning((Shell)WorkspaceUtils.getShell(), (String)"KEGG viewer", (String)"KEGG maps not found for selected ECs");
                    }
                } else if (this.codes == null || this.codes.length == 0) {
                    WorkspaceUtils.hideView((String)"com.biotechvana.gydbpro.views.KeggViewer");
                    MessageDialog.openWarning((Shell)WorkspaceUtils.getShell(), (String)"KEGG viewer", (String)"KEGG maps not found for selected ECs");
                } else {
                    keggViewer.addPaths(this.codes);
                }
            }
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)WorkspaceUtils.getShell(), (String)"KEGG viewer", (String)"Cannot open KEGG viewer");
        }
    }
}

