/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions.fileExplorer;

import com.biotechvana.csveditor.dialogs.csvEditor.CsvOpenDialog;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.actions.ActionFactory;

public class WorksheetOpenAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private FileExplorerBasic fileExplorer;

    public WorksheetOpenAction(FileExplorerBasic fileExplorer) {
        this.setText("Open worksheet file");
        this.fileExplorer = fileExplorer;
    }

    public void dispose() {
    }

    public void run() {
        File[] selectedFiles = this.fileExplorer.getSelectedFiles();
        boolean isAlredy = true;
        if (selectedFiles == null || selectedFiles.length == 0) {
            MessageDialog.openWarning((Shell)this.fileExplorer.getSite().getShell(), (String)"Open worksheet", (String)"No csv worksheet file selected");
            return;
        }
        File[] fileArray = selectedFiles;
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File csvFile = fileArray[n2];
            isAlredy = true;
            if (!FilenameUtils.getExtension((String)csvFile.getName()).equals("csv") && !FilenameUtils.getExtension((String)csvFile.getName()).equals("gff")) {
                MessageDialog.openWarning((Shell)this.fileExplorer.getSite().getShell(), (String)"Open worksheet", (String)"No csv worksheet file selected");
                return;
            }
            IEditorReference[] refs = WorkspaceUtils.getEditorReference((String)"com.biotechvana.csveditor.editors.CSVEditor");
            if (refs != null) {
                IEditorReference[] iEditorReferenceArray = refs;
                int n3 = refs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference r = iEditorReferenceArray[n4];
                    if (r.getPartName().equals(csvFile.getName())) {
                        System.out.println("File is already open");
                        WorkspaceUtils.activateEditor((IEditorReference)r);
                        isAlredy = false;
                    }
                    ++n4;
                }
            }
            if (isAlredy) {
                CsvOpenDialog dialog = new CsvOpenDialog(this.fileExplorer.getSite().getShell(), csvFile.getAbsolutePath());
                dialog.open();
            }
            ++n2;
        }
    }
}

