/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions.fileExplorer;

import com.biotechvana.csveditor.dialogs.csvEditor.CSVFastaOpenDialog;
import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import com.biotechvana.javabiotoolkit.exceptions.FastaReaderNotParsedException;
import com.biotechvana.javabiotoolkit.io.FASTAReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

public class FastaWorksheetOpenAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private FileExplorerBasic fileExplorer;

    public FastaWorksheetOpenAction(FileExplorerBasic fileExplorer) {
        this.setText("Open database as worksheet");
        this.fileExplorer = fileExplorer;
    }

    public void dispose() {
    }

    public void run() {
        File[] selectedFiles = this.fileExplorer.getSelectedFiles();
        if (selectedFiles == null || selectedFiles.length == 0) {
            MessageDialog.openWarning((Shell)this.fileExplorer.getSite().getShell(), (String)"Open database as worksheet", (String)"No fasta file selected");
            return;
        }
        File fastaFile = selectedFiles[0];
        FASTAReader fastaReader = null;
        try {
            fastaReader = new FASTAReader(fastaFile);
            fastaReader.parse();
            if (fastaReader.getFastaRecords().size() == 0) {
                MessageDialog.openWarning((Shell)this.fileExplorer.getSite().getShell(), (String)"Open worksheet", (String)"FASTA file not selected");
                return;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FastaReaderNotParsedException e) {
            e.printStackTrace();
        }
        CSVFastaOpenDialog dialog = new CSVFastaOpenDialog(this.fileExplorer.getSite().getShell(), fastaFile.getAbsolutePath());
        dialog.open();
    }
}

