/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions.csvEditor;

import com.biotechvana.csveditor.dialogs.csvEditor.CsvOpenDialog;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.actions.ActionFactory;

public class CsvOpenAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String TITLE = "Open worksheet...";
    private CSVEditor csvEditor;

    public CsvOpenAction(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.setText(TITLE);
    }

    public void run() {
        IPrefs prefs = PreferenceManager.getInstance();
        String[] filterExtensions = new String[]{"*.csv", "*.gff", "*.gtf", "*.*"};
        String[] filterNames = new String[]{".csv (Comma separated value files", "*.* (All files)"};
        FileDialog dialog = new FileDialog(this.csvEditor.getSite().getShell(), 4100);
        dialog.setText("Open worksheet file");
        dialog.setFilterPath(prefs.get("workspace", ""));
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterNames(filterNames);
        String res = dialog.open();
        if (res == null) {
            return;
        }
        CsvOpenDialog csvDialog = new CsvOpenDialog(this.csvEditor.getSite().getShell(), res);
        csvDialog.open();
        csvDialog.close();
    }

    public void dispose() {
    }
}

