/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions.csvEditor;

import com.biotechvana.csveditor.dialogs.csvEditor.CsvExportCategoriesDialog;
import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

public class CsvExportCategoriesAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String TITLE = "Export categories and clusters...";
    private CSVEditor csvEditor;

    public CsvExportCategoriesAction(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.setText(TITLE);
    }

    public void run() {
        try {
            List<Integer> listCheckedRows = this.csvEditor.getCheckedRowIndices(true, true);
            this.csvEditor.setSelectedIndices(listCheckedRows);
            if (listCheckedRows.size() == 0) {
                MessageDialog.openError((Shell)this.csvEditor.getSite().getShell(), (String)"Export", (String)"Please, select rows to export");
                return;
            }
            CsvExportCategoriesDialog dialog = new CsvExportCategoriesDialog(this.csvEditor.getSite().getShell(), this.csvEditor, listCheckedRows);
            if (dialog.open() == 1) {
                return;
            }
            dialog.close();
        }
        catch (InvocationTargetException e1) {
            MessageDialog.openWarning((Shell)this.csvEditor.getSite().getShell(), (String)"Export categories and clusters", (String)"An error ocurred");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void dispose() {
    }
}

