/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

public class CsvDeleteCheckedRowsAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String TITLE = "Delete checked rows...";
    private CSVEditor csvEditor;
    private List<Integer> listSelectedRows;

    public CsvDeleteCheckedRowsAction(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.setText(TITLE);
    }

    public void run() {
        long timestamp = System.currentTimeMillis();
        if (this.csvEditor.isDirty()) {
            MessageDialog.openInformation((Shell)this.csvEditor.getSite().getShell(), (String)TITLE, (String)"Please, save document before deleting");
            return;
        }
        try {
            this.listSelectedRows = this.csvEditor.getCheckedRowIndices(true, false);
            if (this.listSelectedRows.size() == 0) {
                return;
            }
            this.csvEditor.deleteRows(this.listSelectedRows, timestamp);
            this.csvEditor.resetModelIndices(true, false);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return;
        }
    }

    public void dispose() {
    }
}

