/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

public class CsvCutCheckedRowsAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final String TITLE = "Cut checked rows";
    private CSVEditor csvEditor;
    private List<Integer> listSelectedRows;

    public CsvCutCheckedRowsAction(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.setText(TITLE);
    }

    public void run() {
        try {
            this.listSelectedRows = this.csvEditor.getCheckedRowIndices(true, false);
            if (this.listSelectedRows.size() == 0) {
                MessageDialog.openInformation((Shell)this.csvEditor.getSite().getShell(), (String)TITLE, (String)"No rows were selected");
                return;
            }
            this.csvEditor.cutRows(this.listSelectedRows);
        }
        catch (InvocationTargetException e1) {
            MessageDialog.openWarning((Shell)this.csvEditor.getSite().getShell(), (String)TITLE, (String)"Failed cutting rows");
        }
        catch (InterruptedException e1) {
            return;
        }
    }

    public void dispose() {
    }
}

