/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

public class CsvCopyCheckedRowsAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String TITLE = "Copy checked rows";
    private final String ERROR_MSG = "Failed copying rows";
    private CSVEditor csvEditor;
    private List<Integer> listSelectedRows;

    public CsvCopyCheckedRowsAction(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.setText(TITLE);
    }

    public void run() {
        try {
            this.listSelectedRows = this.csvEditor.getCheckedRowIndices(true, false);
            if (this.listSelectedRows.size() == 0) {
                return;
            }
            this.csvEditor.copyRows(this.listSelectedRows);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openWarning((Shell)this.csvEditor.getSite().getShell(), (String)TITLE, (String)"Failed copying rows");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void dispose() {
    }
}

