/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

public class CsvAddColumnAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String TITLE = "Add new column";
    private CSVEditor csvEditor;

    public CsvAddColumnAction(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.setText(TITLE);
    }

    public void run() {
        InputDialog dialog = new InputDialog(this.csvEditor.getSite().getShell(), TITLE, "Enter new column name: ", "ColumnName", new IInputValidator(){

            public String isValid(String newText) {
                int index = CsvAddColumnAction.this.csvEditor.getColumnIndexForName(newText);
                if (index >= 0) {
                    return "Invalid name: column name already exists";
                }
                return null;
            }
        });
        if (dialog.open() == 1) {
            return;
        }
        try {
            this.csvEditor.createColumns(new String[]{dialog.getValue()}, this.csvEditor.getColumnCount(), true, true);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.csvEditor.getSite().getShell(), (String)TITLE, (String)("Cannot create new column: " + e.getMessage()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void dispose() {
    }
}

