/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions;

import com.biotechvana.csvUtils.CSVUtils2;
import com.biotechvana.csveditor.FileExplorer.CsvFileExplorer;
import com.biotechvana.csveditor.dialogs.MemoryDialog;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.editors.CSVEditorInput;
import com.biotechvana.csveditor.model.DetectAppParameters;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.ActionFactory;

public class CsvNewAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String TITLE = "New worksheet...";

    public CsvNewAction() {
        this.setText(TITLE);
    }

    public void run() {
        IPrefs prefs = PreferenceManager.getInstance();
        String[] filterExtensions = new String[]{"*.csv", "*.*"};
        String[] filterNames = new String[]{".csv (Comma separated value files", "*.* (All files)"};
        FileDialog dialog = new FileDialog(WorkspaceUtils.getShell(), 8196);
        dialog.setText("Create new worksheet file");
        dialog.setFilterPath(prefs.get("workspace", ""));
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterNames(filterNames);
        Object res = dialog.open();
        if (res == null) {
            return;
        }
        try {
            if (!((String)res).endsWith(".csv")) {
                res = (String)res + ".csv";
            }
            CSVEditor.createEmptyDocument(new File((String)res));
            CSVUtils2 csvUtils = CSVUtils2.createNewUtils((File)new File((String)res), (boolean)true);
            csvUtils.parse();
            File inputFile = new File((String)res);
            if (!inputFile.exists() || !inputFile.canRead()) {
                return;
            }
            CSVEditorInput input = null;
            int lineCount = csvUtils.getLineCount();
            DetectAppParameters dap = new DetectAppParameters();
            boolean showMemoryDialog = false;
            if (lineCount > 80000 && dap.getXms() < 3000) {
                showMemoryDialog = true;
            } else if (lineCount > 50000 && dap.getXms() < 2000) {
                showMemoryDialog = true;
            } else if (lineCount > 30000 && dap.getXms() < 1000) {
                showMemoryDialog = true;
            } else if (lineCount > 10000 && dap.getXms() < 512) {
                showMemoryDialog = true;
            }
            if (showMemoryDialog) {
                MemoryDialog dialogMemory = new MemoryDialog(WorkspaceUtils.getShell(), dap.getXms(), lineCount);
                if (dialogMemory.open() == 1) {
                    return;
                }
                dialogMemory.close();
            }
            input = new CSVEditorInput(inputFile, ';', '\"', true, false);
            input.setMultiHit(false);
            input.setMultiHitFile(null);
            WorkspaceUtils.openEditor((IEditorInput)input, (String)"com.biotechvana.csveditor.editors.CSVEditor");
            ((CsvFileExplorer)WorkspaceUtils.findView((String)CsvFileExplorer.ID)).updateInput();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)WorkspaceUtils.getShell(), (String)"Open worksheet", (String)("Failed opening worksheet:\n" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void dispose() {
    }
}

