/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor;

import com.biotechvana.commons.model.ServiceStatus;
import com.biotechvana.commons.model.UserLoginInfo;
import com.biotechvana.pipelineCommander.PipelineCommander;
import com.biotechvana.users.UserManager;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LocalUserManager
extends UserManager {
    IPrefs preferences = PreferenceManager.getInstance();

    public String get(String propKey, String defaultValue) {
        if (this.preferences == null) {
            return null;
        }
        return this.preferences.get(propKey, defaultValue);
    }

    public void put(String propKey, String propValue) {
        if (this.preferences != null) {
            this.preferences.put(propKey, propValue);
        }
    }

    public void savePreferences() {
        if (this.preferences != null) {
            this.preferences.savePreferences();
        }
    }

    protected void postLoginHandle() throws IOException {
    }

    protected void chechIfRooted() {
    }

    public List<ServiceStatus> getCheckStatus(final UserLoginInfo userLogin) {
        ArrayList<ServiceStatus> services = new ArrayList<ServiceStatus>();
        services.add(new ServiceStatus(){
            {
                this.name = "Server API LOGIN";
            }

            public boolean runCheck() {
                String userName = userLogin.getUserName();
                Object host = userLogin.getHostInfo().getServerURL();
                int sshPort = userLogin.getHostInfo().getSshPort();
                int ftpPort = userLogin.getHostInfo().getFtpPort();
                int httpPort = userLogin.getHostInfo().getHttpPort();
                String password = userLogin.getPassword();
                String scheme = userLogin.getHostInfo().getScheme();
                if (httpPort != 80) {
                    host = (String)host + ":" + httpPort;
                }
                try {
                    LocalUserManager.fetchDatabaseSettings((UserManager)LocalUserManager.this, (String)host, (String)userName, (String)PipelineCommander.md5Hash((String)password));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
        });
        return services;
    }
}

