/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;

public class StringUtils {
    private static final char ESCAPE_CHAR = '\\';
    private static final DecimalFormat NICE_INT_FORMAT = new DecimalFormat("###,###");

    public static String join(String[] arrayString, String glue) {
        StringBuilder builder = new StringBuilder();
        if (arrayString != null && arrayString.length > 0) {
            builder.append(arrayString[0]);
            int i = 1;
            while (i < arrayString.length) {
                builder.append(glue + arrayString[i]);
                ++i;
            }
        }
        return builder.toString();
    }

    public static String join(String[] arrayString, String glue, String enclosure) {
        return StringUtils.join(arrayString, glue, enclosure, false);
    }

    public static String join(String[] arrayString, String glue, String enclosure, boolean encloseOnlyIfWhitespace) {
        StringBuilder builder = new StringBuilder();
        if (arrayString != null && arrayString.length > 0) {
            String value = arrayString[0].replace(enclosure, "\\" + enclosure);
            if (encloseOnlyIfWhitespace && value.contains(" ") || !encloseOnlyIfWhitespace) {
                builder.append(enclosure + value + enclosure);
            } else {
                builder.append(value);
            }
            int i = 1;
            while (i < arrayString.length) {
                value = arrayString[i].replace(enclosure, "\\" + enclosure);
                builder.append(glue);
                if (encloseOnlyIfWhitespace && value.contains(" ") || !encloseOnlyIfWhitespace) {
                    builder.append(enclosure + value + enclosure);
                } else {
                    builder.append(value);
                }
                ++i;
            }
        }
        return builder.toString();
    }

    public static String join(List<String> listString, String glue) {
        return StringUtils.join(listString.toArray(new String[listString.size()]), glue);
    }

    public static String join(List<String> listString, String glue, String enclosure) {
        return StringUtils.join(listString.toArray(new String[listString.size()]), glue, enclosure, false);
    }

    public static String join(List<String> listString, String glue, String enclosure, boolean encloseOnlyIfWhitespace) {
        return StringUtils.join(listString.toArray(new String[listString.size()]), glue, enclosure, encloseOnlyIfWhitespace);
    }

    public static String join(Object[] arrayObject, String glue) {
        String[] stringArray = (String[])Arrays.copyOf(arrayObject, arrayObject.length, String[].class);
        return StringUtils.join(stringArray, glue);
    }

    public static String join(Object[] arrayObject, String glue, String enclosure) {
        String[] stringArray = (String[])Arrays.copyOf(arrayObject, arrayObject.length, String[].class);
        return StringUtils.join(stringArray, glue, enclosure, false);
    }

    public static String join(Object[] arrayObject, String glue, String enclosure, boolean onlyIfWhitespace) {
        String[] stringArray = (String[])Arrays.copyOf(arrayObject, arrayObject.length, String[].class);
        return StringUtils.join(stringArray, glue, enclosure, onlyIfWhitespace);
    }

    public static int countMatches(String fullString, String searchString) {
        int counter = 0;
        int lastIndex = 0;
        while (lastIndex != -1) {
            if ((lastIndex = fullString.indexOf(searchString, lastIndex)) == -1) continue;
            ++counter;
            lastIndex += searchString.length();
        }
        return counter;
    }

    public static String reverse(String str) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(str);
        stringBuilder = stringBuilder.reverse();
        return stringBuilder.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String toString(Reader reader) throws IOException {
        int read;
        if (!(reader instanceof BufferedReader)) {
            return StringUtils.toString(new BufferedReader(reader));
        }
        char[] buffer = new char[1024];
        StringBuilder result = new StringBuilder();
        do {
            if ((read = reader.read(buffer)) <= 0) continue;
            result.append(new String(buffer, 0, read));
        } while (read != -1);
        return result.toString();
    }

    public static final boolean endsWith(String s, String ... suffixes) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        String[] stringArray = suffixes;
        int n = suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suff = stringArray[n2];
            if (s.endsWith(suff)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int longestCommonSubStrLen(String s, String t) {
        if (s.isEmpty() || t.isEmpty()) {
            return 0;
        }
        int m = s.length();
        int n = t.length();
        int cost = 0;
        int maxLen = 0;
        int[] p = new int[n];
        int[] d = new int[n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                cost = s.charAt(i) != t.charAt(j) ? 0 : (i == 0 || j == 0 ? 1 : p[j - 1] + 1);
                d[j] = cost;
                if (cost > maxLen) {
                    maxLen = cost;
                }
                ++j;
            }
            int[] swap = p;
            p = d;
            d = swap;
            ++i;
        }
        return maxLen;
    }

    public static String longestCommonSubStr(String X, String Y) {
        return StringUtils.longestCommonSubStr(X, Y, X.length(), Y.length());
    }

    public static String longestCommonSubStr(String X, String Y, int m, int n) {
        int[][] LCSuff = new int[m + 1][n + 1];
        int len = 0;
        int row = 0;
        int col = 0;
        int i = 0;
        while (i <= m) {
            int j = 0;
            while (j <= n) {
                if (i == 0 || j == 0) {
                    LCSuff[i][j] = 0;
                } else if (X.charAt(i - 1) == Y.charAt(j - 1)) {
                    LCSuff[i][j] = LCSuff[i - 1][j - 1] + 1;
                    if (len < LCSuff[i][j]) {
                        len = LCSuff[i][j];
                        row = i;
                        col = j;
                    }
                } else {
                    LCSuff[i][j] = 0;
                }
                ++j;
            }
            ++i;
        }
        if (len == 0) {
            return "";
        }
        Object resultStr = "";
        while (LCSuff[row][col] != 0) {
            resultStr = X.charAt(row - 1) + (String)resultStr;
            --len;
            --row;
            --col;
        }
        return resultStr;
    }

    public static String longestCommonPrefix(String[] a) {
        int size = (a = (String[])a.clone()).length;
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return a[0];
        }
        Arrays.sort(a);
        int end = Math.min(a[0].length(), a[size - 1].length());
        int i = 0;
        while (i < end && a[0].charAt(i) == a[size - 1].charAt(i)) {
            ++i;
        }
        String pre = a[0].substring(0, i);
        return pre;
    }

    public static String longestCommonSuffix(String[] b) {
        int le0;
        int le = b.length;
        if (le == 0) {
            return "";
        }
        if (le == 1) {
            return b[0];
        }
        int minLen = le0 = b[0].length();
        int i = 1;
        while (i < le) {
            if (b[i].length() < minLen) {
                minLen = b[i].length();
            }
            ++i;
        }
        if (minLen == 0) {
            return "";
        }
        String res = "";
        int i2 = 1;
        while (i2 <= minLen) {
            String suffix = b[0].substring(le0 - i2);
            int j = 1;
            while (j < b.length) {
                String e = b[j];
                if (!e.endsWith(suffix)) {
                    return res;
                }
                ++j;
            }
            res = suffix;
            ++i2;
        }
        return res;
    }
}

