/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.prefs.Preferences;

public class ServerSettingsUtils {
    @Deprecated
    public static void fetchDatabaseSettings(Preferences preferences, String host, String user, String hash) throws IOException {
        URL url = new URL("http://" + host + "/gpro/db_settings/db_connection.php?user=" + user + "&pass=" + hash.toLowerCase());
        URLConnection urlConn = url.openConnection();
        urlConn.setConnectTimeout(30000);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));){
            String line;
            preferences.put("PBS", "NO");
            preferences.put("ssh_home_prefix", "home");
            while ((line = in.readLine()) != null) {
                if (line.isEmpty()) continue;
                String[] parts = line.split(":");
                System.out.println("line: " + line);
                if (parts[0].equals("DB_HOST")) {
                    preferences.put("DB_HOST", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_USER")) {
                    preferences.put("DB_USER", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_PASS")) {
                    preferences.put("DB_PASS", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_PIPELINE")) {
                    preferences.put("DB_PIPELINE", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_TAXONOMY")) {
                    preferences.put("DB_TAXONOMY", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_COG")) {
                    preferences.put("DB_COG", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_KOG")) {
                    preferences.put("DB_KOG", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_ORTHOMCL")) {
                    preferences.put("DB_ORTHOMCL", parts[1]);
                    continue;
                }
                if (parts[0].equals("PBS")) {
                    preferences.put("PBS", parts[1]);
                    continue;
                }
                if (parts[0].equals("ssh_home_prefix")) {
                    preferences.put("ssh_home_prefix", parts[1]);
                    continue;
                }
                if (parts[0].equals("MAX_PROCESSES")) {
                    preferences.put("MAX_PROCESSES", parts[1]);
                    continue;
                }
                if (parts[0].equals("SERVER_BIN_PATH")) {
                    preferences.put("SERVER_BIN_PATH", parts[1]);
                    continue;
                }
                if (parts[0].equals("DEMO_MODE")) {
                    preferences.put("DEMO_MODE", parts[1]);
                    continue;
                }
                if (parts[0].equals("DEFAULT_NUMBER_PROCESSES")) {
                    preferences.put("DEFAULT_NUMBER_PROCESSES", parts[1]);
                    continue;
                }
                if (!parts[0].equals("EXPIRES_ON")) continue;
                preferences.put("EXPIRES_ON", parts[1]);
            }
        }
        System.out.println("expires_on: " + preferences.get("EXPIRES_ON", "") + "\n");
        System.out.println("expired: " + String.valueOf(ServerSettingsUtils.licenseHasExpired(preferences)) + "\n");
    }

    public static boolean licenseHasExpired(Preferences preferences) {
        String expirationDate = preferences.get("EXPIRES_ON", "");
        Pattern pattern = Pattern.compile("(\\d{4}\\-\\d{2}\\-\\d{2})");
        Matcher matcher = pattern.matcher(expirationDate);
        if (matcher.find()) {
            String dateString = matcher.group(1);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date dateExp = sdf.parse(dateString);
                Date dateCurrent = new Date();
                if (dateExp.before(dateCurrent)) {
                    return true;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

