/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SequenceFileInfo {
    private File inputFile;
    private boolean isFasta = false;
    private boolean isFastq = false;
    private int byteSize = 0;
    private int sequenceCount = 0;
    private int lineCount = 0;
    private int charCount = 0;
    private static final int LINE_LIMIT = 4;
    private static final char FASTQ_START_CHAR = '@';
    private static final char FASTA_START_CHAR = '>';
    private int longestSequenceLength = 0;
    private int shortestSequenceLength = -1;
    private int below50BasesCount = 0;
    private int below100BasesCount = 0;
    private int below250BasesCount = 0;
    private int below500BasesCount = 0;
    private int below1000BasesCount = 0;
    private boolean checkedIsFasta = false;
    private boolean checkedIsFastq = false;

    public static void main(String[] args) {
        try {
            SequenceFileInfo seq = new SequenceFileInfo(new File("/data/material_gpro/203/asdf.fa"), true);
            seq.printInfo();
            for (String s : seq.getSequenceNamesFastaSorted(true)) {
                System.out.println(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SequenceFileInfo(File inputFile) throws IOException {
        this(inputFile, false);
    }

    public SequenceFileInfo(File inputFile, boolean debug) throws IOException {
        this.inputFile = inputFile;
        this.isFASTA();
        this.isFASTQ();
        if (this.isFasta) {
            if (debug) {
                System.out.println("Is fastA");
            }
            this.scanFileFASTA((IProgressMonitor)new NullProgressMonitor());
        } else {
            if (debug) {
                System.out.println("Is fastQ");
            }
            this.scanFileFASTQ();
        }
        if (debug) {
            this.printInfo();
        }
    }

    public boolean isFASTA() throws IOException {
        if (!this.checkedIsFasta) {
            this.checkFasta();
            this.checkedIsFasta = true;
        }
        return this.isFasta;
    }

    public void setFASTA(boolean isFASTA) {
        this.isFasta = isFASTA;
        this.isFastq = !isFASTA;
    }

    public boolean isFASTQ() throws IOException {
        if (!this.checkedIsFastq) {
            this.checkFastq();
            this.checkedIsFastq = true;
        }
        return this.isFastq;
    }

    public void setFASTQ(boolean isFASTQ) {
        this.isFastq = isFASTQ;
        this.isFasta = !isFASTQ;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(int byteSize) {
        this.byteSize = byteSize;
    }

    public int getSequenceCount() {
        return this.sequenceCount;
    }

    public void setSequenceCount(int sequenceCount) {
        this.sequenceCount = sequenceCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    public int getCharCount() {
        return this.charCount;
    }

    public void setCharCount(int charCount) {
        this.charCount = charCount;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public int getLongestSequenceLength() {
        return this.longestSequenceLength;
    }

    public int getShortestSequenceLength() {
        return this.shortestSequenceLength;
    }

    public int getBelow50BasesCount() {
        return this.below50BasesCount;
    }

    public int getBelow100BasesCount() {
        return this.below100BasesCount;
    }

    public int getBelow250BasesCount() {
        return this.below250BasesCount;
    }

    public int getBelow500BasesCount() {
        return this.below500BasesCount;
    }

    public int getBelow1000BasesCount() {
        return this.below1000BasesCount;
    }

    private void checkFastq() throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.inputFile));){
            String line;
            int counter = 0;
            while ((line = reader.readLine()) != null && counter < 4) {
                if (line.isEmpty()) continue;
                if (line.charAt(0) == '@') {
                    this.setFASTQ(true);
                }
                ++counter;
            }
            if (!this.isFastq) {
                this.setFASTA(true);
            }
        }
    }

    private void checkFasta() throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.inputFile));){
            String line;
            int counter = 0;
            while ((line = reader.readLine()) != null && counter < 4) {
                if (line.isEmpty()) continue;
                if (line.charAt(0) == '@') {
                    this.setFASTA(false);
                }
                ++counter;
            }
            if (!this.isFastq) {
                this.setFASTA(true);
            }
        }
    }

    private void scanFileFASTA(IProgressMonitor monitor) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.inputFile));
        monitor.beginTask("Scan sequence file", -1);
        try {
            String line;
            this.resetCounters();
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                ++this.lineCount;
                this.charCount += line.length();
                if (line.length() > 0 && line.charAt(0) == '>') {
                    this.parseFastaSequence(builder.toString());
                    ++this.sequenceCount;
                    builder = new StringBuilder();
                    continue;
                }
                builder.append(line);
            }
            if (builder.length() > 0) {
                this.parseFastaSequence(builder.toString());
            }
        }
        finally {
            reader.close();
            monitor.done();
        }
    }

    private void parseFastaSequence(String sequence) {
        if (sequence.length() > 0) {
            if (sequence.length() > this.longestSequenceLength) {
                this.longestSequenceLength = sequence.length();
            }
            if (this.shortestSequenceLength == -1 || sequence.length() < this.shortestSequenceLength) {
                this.shortestSequenceLength = sequence.length();
            }
            if (sequence.length() <= 50) {
                ++this.below50BasesCount;
            } else if (sequence.length() <= 100) {
                ++this.below100BasesCount;
            } else if (sequence.length() <= 250) {
                ++this.below250BasesCount;
            } else if (sequence.length() <= 500) {
                ++this.below500BasesCount;
            } else if (sequence.length() <= 1000) {
                ++this.below1000BasesCount;
            }
        }
    }

    private void scanFileFASTQ() throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.inputFile));){
            String line;
            this.resetCounters();
            while ((line = reader.readLine()) != null) {
                ++this.lineCount;
                this.charCount += line.length();
                if (line.length() <= 0 || line.charAt(0) != '@') continue;
                String sequence = reader.readLine();
                ++this.lineCount;
                this.parseFastaSequence(sequence);
                reader.readLine();
                ++this.lineCount;
                reader.readLine();
                ++this.lineCount;
                ++this.sequenceCount;
            }
        }
    }

    private void resetCounters() {
        this.sequenceCount = 0;
        this.lineCount = 0;
        this.charCount = 0;
        this.shortestSequenceLength = -1;
        this.longestSequenceLength = 0;
        this.below50BasesCount = 0;
        this.below100BasesCount = 0;
        this.below250BasesCount = 0;
        this.below500BasesCount = 0;
        this.below1000BasesCount = 0;
    }

    public List<String> getSequenceNamesFastaSorted(boolean removeStartChar) throws IOException {
        ArrayList<String> listSequenceNames = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.inputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                int pos;
                if (line.isEmpty() || line.charAt(0) != '>') continue;
                String sequenceName = line;
                if (removeStartChar) {
                    sequenceName = line.substring(1);
                }
                if ((pos = Collections.binarySearch(listSequenceNames, sequenceName)) >= 0) continue;
                listSequenceNames.add(-pos - 1, sequenceName);
            }
        }
        return listSequenceNames;
    }

    public List<String> getSequenceNamesFastqSorted(boolean removeStartChar) throws IOException {
        ArrayList<String> listSequenceNames = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.inputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                int pos;
                if (line.isEmpty() || line.charAt(0) != '@') continue;
                String sequenceName = line;
                if (removeStartChar) {
                    sequenceName = line.substring(1);
                }
                if ((pos = Collections.binarySearch(listSequenceNames, sequenceName)) < 0) {
                    listSequenceNames.add(-pos - 1, sequenceName);
                }
                reader.readLine();
                reader.readLine();
                reader.readLine();
            }
        }
        return listSequenceNames;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getSequenceNamesFasta(boolean removeStartChar, int start, int end) throws IOException {
        ArrayList<String> listNames = new ArrayList<String>();
        int counter = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.inputFile));){
            block10: {
                String line;
                boolean endReached;
                block9: {
                    endReached = false;
                    if (!true) break block9;
                    line = reader.readLine();
                    if (line == null) return listNames;
                    if (endReached) break block10;
                }
                do {
                    if (!line.isEmpty() && line.charAt(0) == '>') {
                        String sequenceName = line;
                        if (removeStartChar) {
                            sequenceName = line.substring(1);
                        }
                        if (counter >= start) {
                            listNames.add(sequenceName);
                        }
                        if (counter >= end) {
                            endReached = true;
                        }
                        ++counter;
                    }
                    line = reader.readLine();
                    if (line == null) return listNames;
                } while (!endReached);
            }
            return listNames;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getSequenceNamesFastq(boolean removeStartChar, int start, int end) throws IOException {
        ArrayList<String> listSequenceNames = new ArrayList<String>();
        int counter = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.inputFile));){
            block10: {
                String line;
                boolean endReached;
                block9: {
                    endReached = false;
                    if (!true) break block9;
                    line = reader.readLine();
                    if (line == null) return listSequenceNames;
                    if (endReached) break block10;
                }
                do {
                    if (!line.isEmpty() && line.charAt(0) == '@') {
                        String sequenceName = line;
                        if (removeStartChar) {
                            sequenceName = line.substring(1);
                        }
                        if (counter >= start) {
                            listSequenceNames.add(sequenceName);
                        }
                        if (counter > end) {
                            endReached = true;
                        }
                        reader.readLine();
                        reader.readLine();
                        reader.readLine();
                        ++counter;
                    }
                    line = reader.readLine();
                    if (line == null) return listSequenceNames;
                } while (!endReached);
            }
            return listSequenceNames;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getMatchingSequenceNamesFasta(boolean removeStartChar, String filter, boolean exact) throws IOException {
        ArrayList<String> listNames = new ArrayList<String>();
        String regex = this.prepareFilterAsRegexp(filter, exact);
        try (BufferedReader reader = new BufferedReader(new FileReader(this.inputFile));){
            block9: {
                String line;
                boolean endReached;
                block8: {
                    endReached = false;
                    if (!true) break block8;
                    line = reader.readLine();
                    if (line == null) return listNames;
                    if (endReached) break block9;
                }
                do {
                    if (!line.isEmpty() && line.charAt(0) == '>') {
                        String sequenceName = line;
                        if (removeStartChar) {
                            sequenceName = line.substring(1);
                        }
                        if (filter == null || filter.isEmpty() || sequenceName.matches(regex)) {
                            listNames.add(sequenceName);
                        }
                    }
                    line = reader.readLine();
                    if (line == null) return listNames;
                } while (!endReached);
            }
            return listNames;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getSequenceNamesFastq(boolean removeStartChar, String filter, boolean exactMatch, IProgressMonitor monitor) throws IOException {
        monitor.beginTask("Fetch sequences", 100);
        int stepSize = this.sequenceCount / 100;
        int counter = 0;
        ArrayList<String> listSequenceNames = new ArrayList<String>();
        String regex = this.prepareFilterAsRegexp(filter, exactMatch);
        try (BufferedReader reader = new BufferedReader(new FileReader(this.inputFile));){
            String line;
            boolean endReached = false;
            while ((line = reader.readLine()) != null && !endReached) {
                if (line.isEmpty() || line.charAt(0) != '@') continue;
                String sequenceName = line;
                if (removeStartChar) {
                    sequenceName = line.substring(1);
                }
                if (filter == null || filter.isEmpty() || sequenceName.matches(regex)) {
                    listSequenceNames.add(sequenceName);
                }
                reader.readLine();
                reader.readLine();
                reader.readLine();
                if (++counter % stepSize == 0) {
                    monitor.worked(1);
                }
                if (!monitor.isCanceled()) continue;
                reader.close();
                ArrayList<String> arrayList = listSequenceNames;
                return arrayList;
            }
        }
        monitor.done();
        return listSequenceNames;
    }

    private String prepareFilterAsRegexp(String filter, boolean exact) {
        if (filter.isEmpty()) {
            return filter;
        }
        if (filter.charAt(0) == '*') {
            filter = filter.substring(1);
        }
        if (filter.charAt(filter.length() - 1) == '*') {
            filter = filter.substring(0, filter.length());
        }
        filter = filter.replace("*", ".*");
        if (exact) {
            System.out.println("exact match: ^(?i).*" + filter + ".*$");
            return "^(?i)" + filter + "$";
        }
        System.out.println("partial match: (?i).*" + filter + ".*");
        return "(?i).*" + filter + ".*";
    }

    public void printInfo() {
        NumberFormat nf = NumberFormat.getIntegerInstance();
        System.out.println("Sequence count: " + nf.format(this.sequenceCount));
        System.out.println("Line count: " + nf.format(this.lineCount));
        System.out.println("Char count: " + nf.format(this.charCount));
        System.out.println("Shortest sequence length: " + nf.format(this.shortestSequenceLength));
        System.out.println("Longest sequence length: " + nf.format(this.longestSequenceLength));
        System.out.println("1-50 bases sequence count: " + nf.format(this.below50BasesCount));
        System.out.println("51-100 bases sequence count: " + nf.format(this.below100BasesCount));
        System.out.println("101-250 bases sequence count: " + nf.format(this.below250BasesCount));
        System.out.println("251-500 bases sequence count: " + nf.format(this.below500BasesCount));
        System.out.println("501-1000 bases sequence count: " + nf.format(this.below1000BasesCount));
    }
}

