/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.utils;

import com.biotechvana.javabiotoolkit.exceptions.FastaReaderNotParsedException;
import com.biotechvana.javabiotoolkit.io.FASTAFileRecord;
import com.biotechvana.javabiotoolkit.io.FASTAReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Point;

public class FastaUtils {
    public int joinFiles(String[] fastaFiles, String outputFile) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
            String[] stringArray = fastaFiles;
            int n = fastaFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!new File(s).canRead()) {
                    System.out.println("Cannot open file: " + s);
                } else {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(s));
                    while ((line = br.readLine()) != null) {
                        bw.write(line);
                        bw.newLine();
                    }
                    br.close();
                }
                ++n2;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 1;
    }

    public String getSequence(String fastaFile, String defline) {
        StringBuffer sbuffer = new StringBuffer();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fastaFile));
            while ((line = br.readLine()) != null) {
                if (line.compareTo(defline) != 0) continue;
                while ((line = br.readLine()) != null) {
                    if (line.indexOf(">") == 0) {
                        br.close();
                        return sbuffer.toString();
                    }
                    sbuffer.append(line);
                }
            }
            br.close();
            return sbuffer.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int splitSequences(String fastaFile, int start, int length, String outputFile) {
        int defCounter = 0;
        if (start == 0) {
            start = 1;
        }
        if (!new File(fastaFile).canRead()) {
            System.out.println("Cannot open fastaFile:" + fastaFile);
            return -1;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fastaFile));
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.indexOf(">") == 0) {
                    ++defCounter;
                }
                if (defCounter == start + length) break;
                if (defCounter < start) continue;
                bw.append(line);
                bw.append("\r\n");
            }
            br.close();
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 1;
    }

    public int splitSequences(String fastaFile, int start, String outputFile) {
        int countSequences = this.getDefList(fastaFile).length;
        this.splitSequences(fastaFile, start, countSequences - start + 1, outputFile);
        return 1;
    }

    public int formatDeflines(String fastaFile, String separator, String replace, int numCols, String outputFile) {
        BufferedWriter bw;
        BufferedReader br;
        try {
            br = new BufferedReader(new FileReader(fastaFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
        try {
            bw = new BufferedWriter(new FileWriter(outputFile));
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        Pattern p = Pattern.compile(">(.+)");
        try {
            String line;
            while ((line = br.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (m.find()) {
                    String[] cols = m.group(1).split(separator);
                    bw.write(">");
                    int i = 0;
                    while (i < numCols - 1) {
                        bw.write(cols[i]);
                        bw.write(replace);
                        ++i;
                    }
                    bw.write(cols[numCols - 1]);
                } else {
                    bw.write(line);
                }
                bw.newLine();
            }
            br.close();
            bw.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return -2;
        }
        return 1;
    }

    public String[] getDefList(String fastaFile) {
        ArrayList<String> defList = new ArrayList<String>();
        BufferedReader br = null;
        Pattern p = Pattern.compile("^(>.+)$");
        try {
            String line;
            br = new BufferedReader(new FileReader(fastaFile));
            while ((line = br.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (!m.find()) continue;
                defList.add(m.group(1).trim());
            }
            String[] stringArray = defList.toArray(new String[defList.size()]);
            return stringArray;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
    }

    public String[] getDefList(String fastaFile, String regexp) {
        ArrayList<String> deflist = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fastaFile));
            while ((line = br.readLine()) != null) {
                if (!line.matches(regexp)) continue;
                deflist.add(line);
            }
            br.close();
            return deflist.toArray(new String[deflist.size()]);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int getSequencesFromDefList(String defFile, String fastaFile, String outputFile) {
        File inputFile = new File(defFile);
        if (!inputFile.isFile()) {
            System.out.println("Error. Cannot open file: " + defFile);
            return -1;
        }
        ArrayList<String> defList = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(defFile));
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) continue;
                defList.add(line.trim());
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public boolean getSequencesFromDefList2(String[] defList, File fastaFile, String outputFile) {
        FASTAReader reader = new FASTAReader(fastaFile);
        Object writer = null;
        int countRecords = 0;
        try {
            reader.parse();
            String[] stringArray = defList;
            int n = defList.length;
            int n2 = 0;
            while (n2 < n) {
                String d = stringArray[n2];
                if (d.charAt(0) == '>') {
                    d = d.substring(1);
                }
                List listRecords = reader.findRecords(d);
                for (FASTAFileRecord ffr : listRecords) {
                    ++countRecords;
                }
                ++n2;
            }
            System.out.println("cuenta: " + countRecords);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FastaReaderNotParsedException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean getSequencesFromDefList(String[] defList, String fastaFile, String outputFile) {
        File inputFile = new File(fastaFile);
        if (!inputFile.canRead()) {
            System.out.println("Error. Cannot open file");
        }
        BufferedReader br = null;
        try {
            try {
                String line;
                br = new BufferedReader(new FileReader(fastaFile));
                boolean write = false;
                String currentDef = null;
                StringBuffer sbuffer = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).indexOf(">") != -1) {
                        if (this.searchDefInList(line, defList)) {
                            write = true;
                            if (currentDef != null) {
                                this.appendSequenceToFile(outputFile, currentDef, sbuffer.toString());
                            }
                            sbuffer = new StringBuffer();
                            currentDef = line;
                            continue;
                        }
                        write = false;
                        continue;
                    }
                    if (!write) continue;
                    sbuffer.append(line);
                }
                System.out.println("-----------------------------------------------------");
                if (currentDef != null) {
                    this.appendSequenceToFile(outputFile, currentDef, sbuffer.toString());
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        return false;
                    }
                }
                return false;
            }
            catch (IOException e) {
                block24: {
                    e.printStackTrace();
                    if (br == null) break block24;
                    try {
                        br.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                        return false;
                    }
                }
                return false;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSequenceFromDef(String def, String fastaFile) throws IOException {
        try {
            BufferedReader bReader = new BufferedReader(new FileReader(fastaFile));
            try {
                String line;
                StringBuilder sBuilder = new StringBuilder();
                do {
                    if ((line = bReader.readLine()) != null) continue;
                    return null;
                } while (!(line = line.trim()).equals(def));
                while (true) {
                    if ((line = bReader.readLine()) == null) {
                        String string = sBuilder.toString();
                        return string;
                    }
                    if (line.indexOf(">") == 0) {
                        bReader.close();
                        String string = sBuilder.toString();
                        return string;
                    }
                    sBuilder.append(line);
                }
            }
            finally {
                bReader.readLine();
                bReader.close();
            }
        }
        catch (IOException ex) {
            new IOException(ex);
        }
        return null;
    }

    private boolean searchDefInList(String defSearch, String[] defList) {
        defSearch = defSearch.trim();
        String[] stringArray = defList;
        int n = defList.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.trim().compareTo(defSearch) == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int appendSequenceToFile(String file, String defline, String sequence) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file, true));
            bw.append(defline);
            bw.append("\r\n");
            bw.append(sequence);
            bw.append("\r\n");
            bw.close();
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void renameSequences(String fastaFile, int[] sequenceIndices, String[] sequenceNames) {
        Object[] objectArray = sequenceIndices;
        int n = sequenceIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = objectArray[n2];
            System.out.println("si: " + i);
            ++n2;
        }
        objectArray = sequenceNames;
        n = sequenceNames.length;
        n2 = 0;
        while (n2 < n) {
            int s = objectArray[n2];
            System.out.println("sn: " + (String)s);
            ++n2;
        }
        BufferedReader bReader = null;
        BufferedWriter bWriter = null;
        try {
            try {
                String line;
                bReader = new BufferedReader(new FileReader(fastaFile));
                File tempFile = new File("workspace/associated_fasta.tmp");
                bWriter = new BufferedWriter(new FileWriter(tempFile));
                int defCounter = 0;
                while ((line = bReader.readLine()) != null) {
                    if (line.indexOf(">") == 0) {
                        int index = Arrays.binarySearch(sequenceIndices, defCounter);
                        if (index >= 0) {
                            System.out.println("index[" + index + "]" + sequenceNames[index]);
                            bWriter.append(">" + sequenceNames[index]);
                        } else {
                            bWriter.append(line);
                        }
                    } else {
                        bWriter.append(line);
                    }
                    bWriter.newLine();
                    if (line.indexOf(">") != 0) continue;
                    ++defCounter;
                }
                try {
                    bReader.close();
                    bWriter.close();
                }
                catch (IOException e) {
                    System.err.println("Cannot close buffered reader");
                    e.printStackTrace();
                }
                System.out.println("Nuevo archivo en: " + tempFile.getAbsolutePath());
                System.out.println("FastaUtils: Moving file");
                FastaUtils.copyFileContents(tempFile.getAbsolutePath(), fastaFile);
            }
            catch (Exception e) {
                System.err.println("Filed editing file: " + fastaFile);
                e.printStackTrace();
                try {
                    bReader.close();
                    bWriter.close();
                }
                catch (IOException e2) {
                    System.err.println("Cannot close buffered reader");
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                bReader.close();
                bWriter.close();
            }
            catch (IOException e) {
                System.err.println("Cannot close buffered reader");
                e.printStackTrace();
            }
        }
    }

    public static void copyFileContents(String inputFile, String outputFile) throws IOException {
        try {
            BufferedReader bReader = new BufferedReader(new FileReader(inputFile));
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(outputFile, false));
            try {
                String line;
                while ((line = bReader.readLine()) != null) {
                    bWriter.write(line);
                    bWriter.newLine();
                }
            }
            finally {
                bReader.close();
                bWriter.close();
            }
        }
        catch (IOException ex) {
            throw new IOException(ex);
        }
    }

    public static String formatSequence(String sequence, int blockSize) {
        int length = sequence.length();
        StringBuilder builder = new StringBuilder();
        int charCounter = 0;
        int i = 0;
        while (i < length) {
            char c = sequence.charAt(i);
            if (c != '\n' && c != '\r' && c != ' ') {
                if (charCounter > 0 && charCounter % blockSize == 0) {
                    builder.append("\n");
                }
                builder.append(c);
                ++charCounter;
            }
            ++i;
        }
        return builder.toString();
    }

    public static String maskSequence(byte[] sequence, List<Point> maskRanges, String mask) {
        return FastaUtils.maskSequence(new String(sequence), maskRanges, mask);
    }

    public static String maskSequence(String sequence, List<Point> maskRanges, String mask) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < sequence.length()) {
            char c = sequence.charAt(i);
            if (c != '\n' && c != '\r' && c != ' ') {
                builder.append(c);
            }
            ++i;
        }
        for (Point p : maskRanges) {
            try {
                int i2 = p.x;
                while (i2 < p.y && i2 < builder.length()) {
                    builder.replace(i2, i2 + 1, mask);
                    ++i2;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return builder.toString();
    }

    public static int getSequenceCount(File inputFile) throws IOException {
        int sequenceCount = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.charAt(0) != '>') continue;
                ++sequenceCount;
            }
        }
        return sequenceCount;
    }
}

