/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csvUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CsvBufferedReader {
    private File fileInput;
    public static final char SEPARATOR_TAB = '\t';
    public static final char SEPARATOR_SPACE = ' ';
    public static final char SEPARATOR_COLON = ':';
    public static final char SEPARATOR_SEMICOLON = ';';
    public static final char QUOTES_NONE = 'N';
    public static final char QUOTES_SINGLE = '\'';
    public static final char QUOTES_DOUBLE = '\"';
    private char separator = (char)59;
    private char quotes = (char)34;
    public static final char ESCAPE = '\\';
    private BufferedReader reader;

    public CsvBufferedReader(File fileInput, char separator, char quotes) {
        this.fileInput = fileInput;
        this.separator = separator;
        this.quotes = quotes;
    }

    public void open() throws FileNotFoundException {
        this.reader = new BufferedReader(new FileReader(this.fileInput));
    }

    public int getLineCount() throws FileNotFoundException {
        int counter = 0;
        if (this.reader == null) {
            this.open();
        }
        return counter;
    }

    public static int getLineCount(File fileInput) throws IOException {
        int counter = 0;
        try (BufferedReader readerCounter = new BufferedReader(new FileReader(fileInput));){
            while (readerCounter.readLine() != null) {
                ++counter;
            }
        }
        return counter;
    }

    public List<String> readLine() throws IOException {
        if (this.reader == null) {
            this.open();
        }
        String line = this.reader.readLine();
        while (line != null) {
            if (!(line = line.trim()).isEmpty()) {
                return this.parseLine(line);
            }
            line = this.reader.readLine();
        }
        return null;
    }

    private List<String> parseLine(String line) {
        ArrayList<String> listColumns = new ArrayList<String>();
        boolean quoteOpen = false;
        StringBuilder currentColumn = new StringBuilder();
        int len = line.length();
        int i = 0;
        while (i < len) {
            char c = line.charAt(i);
            if (c == this.quotes) {
                if (i > 0 && line.charAt(i - 1) == '\\') {
                    currentColumn.append(c);
                } else {
                    quoteOpen = !quoteOpen;
                }
            } else if (c == this.separator) {
                if (i > 0 && line.charAt(i - 1) == '\\') {
                    currentColumn.append(c);
                } else if (quoteOpen) {
                    currentColumn.append(c);
                } else {
                    listColumns.add(currentColumn.toString());
                    currentColumn = new StringBuilder();
                }
            } else if (c == '\\') {
                if (i > 0 && line.charAt(i - 1) == '\\') {
                    currentColumn.append(c);
                }
            } else {
                currentColumn.append(c);
            }
            ++i;
        }
        listColumns.add(currentColumn.toString());
        return listColumns;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

