/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csvUtils;

import com.biotechvana.csvUtils.GFFUtils;
import com.biotechvana.csvUtils.SequencePosition;
import com.biotechvana.csvUtils.WorksheetUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CSVUtils2 {
    public static final char NULL_DELIMITER = 'N';
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char ESCAPE_CHAR = '\\';
    public static final char NEW_LINE_N = '\n';
    public static final char NEW_LINE_R = '\r';
    public static final char COMMENT_CHAR = '#';
    public static final int COLUMN_PADDING = 2;
    public static final char DEFAULT_SEPARATOR = ';';
    public static final char DEFAULT_DELIMITER = '\"';
    public static final char COMMENT_SEPARATOR = '=';
    private static final String MULTIHIT_LABEL = "#multihit=";
    private String comments;
    protected final int BUFFER_SIZE = 524288;
    private final int MAX_ROWS_FOR_PARSING = 100;
    protected StringBuilder modelRowBuilder;
    protected int columnCount = 0;
    private int lineCount = 0;
    protected File csvFile;
    private boolean parseCommentsDone = false;
    private boolean parseColumnCountDone = false;
    private boolean parseLineCountDone = false;
    protected boolean parseSeparatorDone = false;
    protected boolean parseDelimiterDone = false;
    protected boolean parseHeadersDone = false;
    protected boolean parseModelDone = false;
    private boolean parseRepeatedQueriesDone = false;
    protected boolean hasHeader = false;
    private boolean hasRepeatedQueries = false;
    protected List<String> headerList;
    protected List<List<String>> model;
    protected char delimiter = (char)34;
    protected char separator = Separators.SEMICOLON.getSeparator();
    private boolean debug = false;
    protected boolean perserveDelimiter = false;

    public static void main(String[] args) {
        long startMillis = System.currentTimeMillis();
        CSVUtils2 csvutils = new CSVUtils2("/home/rfutami/Escritorio/material_gpro/ap_transcriptome_annotated_isoforms.csv", true);
        try {
            csvutils.parse();
            System.out.println("Colcount: " + csvutils.getColumnCount());
            List<List<String>> model = csvutils.getModel(false, false);
            System.out.println("Linecount: " + model.size());
            System.out.println("Last row:");
            List<String> lastRow = model.get(model.size() - 1);
            System.out.println(Arrays.toString(lastRow.toArray(new String[lastRow.size()])));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (LineCountNotDoneException e) {
            e.printStackTrace();
        }
        catch (ColumnCountNotDoneException e) {
            e.printStackTrace();
        }
        catch (SeparatorNotParsedException e) {
            e.printStackTrace();
        }
        catch (DelimiterNotParsedException e) {
            e.printStackTrace();
        }
        catch (CannotOpenFileException e) {
            e.printStackTrace();
        }
        catch (HeadersNotParsedException e) {
            e.printStackTrace();
        }
        catch (CommentsNotParsedException e) {
            e.printStackTrace();
        }
        catch (ModelNotParsedException e) {
            e.printStackTrace();
        }
        long endMillis = System.currentTimeMillis();
        long diffMillis = endMillis - startMillis;
        System.out.println(String.valueOf(diffMillis) + "ms");
    }

    public static CSVUtils2 createNewUtils(String csvFileName, boolean hasHeader) {
        return CSVUtils2.createNewUtils(csvFileName, hasHeader, false);
    }

    public static CSVUtils2 createNewUtils(File csvFile, boolean hasHeader) {
        return CSVUtils2.createNewUtils(csvFile, hasHeader, false);
    }

    public static CSVUtils2 createNewUtils(String csvFileName, boolean hasHeader, boolean isGFFFile) {
        if (isGFFFile) {
            return new GFFUtils(csvFileName, hasHeader);
        }
        return new CSVUtils2(csvFileName, hasHeader);
    }

    public static CSVUtils2 createNewUtils(File csvFile, boolean hasHeader, boolean isGFFFile) {
        if (isGFFFile) {
            return new GFFUtils(csvFile, hasHeader);
        }
        return new CSVUtils2(csvFile, hasHeader);
    }

    protected CSVUtils2(String csvFile, boolean hasHeader) {
        this.csvFile = new File(csvFile);
        this.hasHeader = hasHeader;
    }

    protected CSVUtils2(File csvFile, boolean hasHeader) {
        this.csvFile = csvFile;
        this.hasHeader = hasHeader;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void parse() throws IOException, InterruptedException, LineCountNotDoneException, ColumnCountNotDoneException, SeparatorNotParsedException, DelimiterNotParsedException, CannotOpenFileException, HeadersNotParsedException, CommentsNotParsedException {
        if (this.csvFile == null || !this.csvFile.exists()) {
            throw new CannotOpenFileException();
        }
        this.parseComments();
        if (!this.parseCommentsDone) {
            throw new CommentsNotParsedException();
        }
        this.parseSeparator();
        if (!this.parseSeparatorDone) {
            throw new SeparatorNotParsedException();
        }
        this.parseDelimiter();
        if (!this.parseDelimiterDone) {
            throw new DelimiterNotParsedException();
        }
        this.parseFileLineCount();
        if (!this.parseLineCountDone) {
            throw new LineCountNotDoneException();
        }
        this.lineCount = this.getLineCount();
        if (this.delimiter == 'N') {
            this.parseColumnCountWithoutDelimiter();
            this.columnCount = this.getColumnCount();
        } else {
            this.parseColumnCount();
            this.columnCount = this.getColumnCount();
        }
        if (this.hasHeader) {
            if (this.delimiter == 'N') {
                this.parseHeadersWithoutDelimiter();
            } else {
                this.parseHeaders();
            }
            if (!this.parseHeadersDone) {
                throw new HeadersNotParsedException();
            }
        }
    }

    public void parse(char separator, char delimiter) throws IOException, InterruptedException, LineCountNotDoneException, ColumnCountNotDoneException, SeparatorNotParsedException, DelimiterNotParsedException, CannotOpenFileException, HeadersNotParsedException, CommentsNotParsedException {
        if (this.csvFile == null || !this.csvFile.exists()) {
            throw new CannotOpenFileException();
        }
        this.setSeparator(separator);
        this.parseSeparatorDone = true;
        this.setDelimiter(delimiter);
        this.parseDelimiterDone = true;
        this.parseComments();
        if (!this.parseCommentsDone) {
            throw new CommentsNotParsedException();
        }
        this.parseFileLineCount();
        if (!this.parseLineCountDone) {
            throw new LineCountNotDoneException();
        }
        this.lineCount = this.getLineCount();
        if (delimiter == 'N') {
            this.parseColumnCountWithoutDelimiter();
            this.columnCount = this.getColumnCount();
        } else {
            this.parseColumnCount();
            this.columnCount = this.getColumnCount();
        }
        if (this.hasHeader) {
            if (delimiter == 'N') {
                this.parseHeadersWithoutDelimiter();
            } else {
                this.parseHeaders();
            }
            if (!this.parseHeadersDone) {
                throw new HeadersNotParsedException();
            }
        }
    }

    protected void parseDelimiter() throws IOException {
        int countDoubleQuote = 0;
        int countSingleQuote = 0;
        int countSeparators = 0;
        int lineCount = 0;
        String firstLine = null;
        try (BufferedReader br = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            boolean delimiterOpen = false;
            while ((line = br.readLine()) != null && lineCount < 100) {
                if (lineCount == 0) {
                    firstLine = line;
                }
                delimiterOpen = false;
                int i = 0;
                while (i < line.length()) {
                    if (i > 0) {
                        if ((line.charAt(i) == '\"' || line.charAt(i) == '\'') && line.charAt(i - 1) != '\\') {
                            delimiterOpen = !delimiterOpen;
                        }
                        if (line.charAt(i) == '\"' && line.charAt(i - 1) != '\\') {
                            ++countDoubleQuote;
                        } else if (line.charAt(i) == '\'' && line.charAt(i - 1) != '\\') {
                            ++countSingleQuote;
                        } else if (line.charAt(i) == this.separator && line.charAt(i - 1) != '\\' && !delimiterOpen) {
                            ++countSeparators;
                        }
                    } else {
                        if (line.charAt(i) == '\"' || line.charAt(i) == '\'') {
                            delimiterOpen = !delimiterOpen;
                        }
                        if (line.charAt(i) == '\"') {
                            ++countDoubleQuote;
                        } else if (line.charAt(i) == '\'') {
                            ++countSingleQuote;
                        } else if (line.charAt(i) == this.separator && !delimiterOpen) {
                            ++countSeparators;
                        }
                    }
                    ++i;
                }
                ++lineCount;
            }
            this.parseDelimiterDone = true;
            if (!firstLine.endsWith(String.valueOf(this.separator))) {
                ++countSeparators;
            }
            if (countDoubleQuote == 0 && countSingleQuote == 0) {
                this.delimiter = (char)78;
                return;
            }
            if (countDoubleQuote >= countSeparators) {
                this.delimiter = (char)34;
                return;
            }
            if (countSingleQuote >= countSeparators) {
                this.delimiter = (char)39;
                return;
            }
            this.delimiter = (char)78;
        }
    }

    protected void parseSeparator() throws IOException {
        int[] separators = new int[5];
        try (BufferedReader br = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            int lineCount = 0;
            boolean delimiterOpen = false;
            while ((line = br.readLine()) != null && lineCount < 100) {
                delimiterOpen = false;
                int i = 0;
                while (i < line.length()) {
                    char currentChar = line.charAt(i);
                    if (i > 0) {
                        if ((currentChar == '\"' || currentChar == '\'') && line.charAt(i - 1) != '\\') {
                            delimiterOpen = !delimiterOpen;
                        }
                    } else if (currentChar == '\"' || currentChar == '\'') {
                        delimiterOpen = !delimiterOpen;
                    }
                    if (!delimiterOpen) {
                        switch (currentChar) {
                            case ';': {
                                int n = Separators.SEMICOLON.getIndex();
                                separators[n] = separators[n] + 1;
                                break;
                            }
                            case ':': {
                                int n = Separators.COLON.getIndex();
                                separators[n] = separators[n] + 1;
                                break;
                            }
                            case ' ': {
                                int n = Separators.SPACE.getIndex();
                                separators[n] = separators[n] + 1;
                                break;
                            }
                            case '\t': {
                                int n = Separators.TAB.getIndex();
                                separators[n] = separators[n] + 1;
                                break;
                            }
                            case ',': {
                                int n = Separators.COMMA.getIndex();
                                separators[n] = separators[n] + 1;
                            }
                        }
                    }
                    ++i;
                }
                ++lineCount;
            }
            int maxIndex = 0;
            int maxCount = 0;
            int i = 0;
            while (i < separators.length) {
                if (separators[i] > maxCount) {
                    maxCount = separators[i];
                    maxIndex = i;
                }
                ++i;
            }
            this.parseSeparatorDone = true;
            this.separator = separators[Separators.SEMICOLON.getIndex()] >= separators[Separators.COLON.getIndex()] && (separators[Separators.SEMICOLON.getIndex()] > 0 || separators[Separators.COLON.getIndex()] > 0) ? Separators.SEMICOLON.getSeparator() : Separators.values()[maxIndex].getSeparator();
        }
    }

    private void parseColumnCount() throws IOException, InterruptedException {
        char[] buffer = new char[524288];
        char lastChar = '1';
        int bytesRead = 0;
        int currentColumnCount = 0;
        boolean delimiterOpen = false;
        try (BufferedReader bReader = new BufferedReader(new FileReader(this.csvFile));){
            while ((bytesRead = bReader.read(buffer)) != -1) {
                int i = 0;
                while (i < bytesRead) {
                    char currentChar = buffer[i];
                    if (currentChar == '\n') {
                        if (i > 0 && buffer[i - 1] != this.separator) {
                            ++currentColumnCount;
                        }
                        if (i < bytesRead - 1 && buffer[i + 1] == '\r') {
                            ++i;
                        }
                        if (currentColumnCount > this.columnCount) {
                            this.columnCount = currentColumnCount;
                        }
                        currentColumnCount = 0;
                        delimiterOpen = false;
                    } else if (currentChar == '\r') {
                        if (i > 0 && buffer[i - 1] != this.separator) {
                            ++currentColumnCount;
                        }
                        if (i < bytesRead - 1 && buffer[i + 1] == '\n') {
                            ++i;
                        }
                        if (currentColumnCount > this.columnCount) {
                            this.columnCount = currentColumnCount;
                        }
                        currentColumnCount = 0;
                        delimiterOpen = false;
                    } else if (currentChar == this.delimiter) {
                        if (lastChar != '\\') {
                            delimiterOpen = !delimiterOpen;
                        }
                    } else if (currentChar == this.separator && !delimiterOpen) {
                        ++currentColumnCount;
                    }
                    lastChar = currentChar;
                    ++i;
                }
            }
            this.parseColumnCountDone = true;
        }
    }

    private void parseColumnCountWithoutDelimiter() throws IOException {
        try (BufferedReader bReader = new BufferedReader(new FileReader(this.csvFile));){
            char[] buffer = new char[524288];
            int bytesRead = 0;
            int currentColumnCount = 0;
            boolean delimiterOpen = false;
            this.columnCount = 0;
            while ((bytesRead = bReader.read(buffer)) != -1) {
                int i = 0;
                while (i < bytesRead) {
                    char currentChar = buffer[i];
                    if (currentChar == '\n') {
                        if (i > 0 && buffer[i - 1] != this.separator) {
                            ++currentColumnCount;
                        }
                        if (i < bytesRead - 1 && buffer[i + 1] == '\r') {
                            ++i;
                        }
                        if (currentColumnCount > this.columnCount) {
                            this.columnCount = currentColumnCount;
                        }
                        currentColumnCount = 0;
                        delimiterOpen = false;
                    } else if (currentChar == '\r') {
                        if (i > 0 && buffer[i - 1] != this.separator) {
                            ++currentColumnCount;
                        }
                        if (i < bytesRead - 1 && buffer[i + 1] == '\n') {
                            ++i;
                        }
                        if (currentColumnCount > this.columnCount) {
                            this.columnCount = currentColumnCount;
                        }
                        currentColumnCount = 0;
                        delimiterOpen = false;
                    } else if (currentChar == '\"') {
                        if (i == 0) {
                            delimiterOpen = !delimiterOpen;
                        } else if (buffer[i - 1] != '\\') {
                            delimiterOpen = !delimiterOpen;
                        }
                    } else if (currentChar == this.separator && !delimiterOpen) {
                        ++currentColumnCount;
                    }
                    ++i;
                }
            }
            this.parseColumnCountDone = true;
        }
    }

    public List<String> getHeaders() throws IOException, ColumnCountNotDoneException, SeparatorNotParsedException, DelimiterNotParsedException {
        if (!this.parseColumnCountDone) {
            throw new ColumnCountNotDoneException();
        }
        if (!this.parseSeparatorDone) {
            throw new SeparatorNotParsedException();
        }
        if (!this.parseDelimiterDone) {
            throw new DelimiterNotParsedException();
        }
        if (!this.parseHeadersDone) {
            this.headerList = new ArrayList<String>();
            if (this.delimiter == 'N') {
                this.parseHeadersWithoutDelimiter();
            } else {
                this.parseHeaders();
            }
        }
        return this.headerList;
    }

    protected void parseHeaders() throws IOException {
        int counter = 0;
        if (this.headerList == null) {
            this.headerList = new ArrayList<String>();
        }
        try (BufferedReader bReader = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            while ((line = bReader.readLine()) != null) {
                if (!line.isEmpty() && line.charAt(0) != '#') break;
            }
            if (line != null && line.length() > 0) {
                line = line.trim();
                StringBuilder sbuilder = new StringBuilder();
                int i = 0;
                while (i < line.length() && counter < this.columnCount) {
                    if (line.charAt(i) == this.separator) {
                        this.headerList.add(sbuilder.toString());
                        ++counter;
                        sbuilder = new StringBuilder();
                    } else if (line.charAt(i) != this.delimiter) {
                        sbuilder.append(line.charAt(i));
                    }
                    ++i;
                }
                if (counter < this.columnCount) {
                    this.headerList.add(sbuilder.toString());
                }
                i = 0;
                while (i < this.headerList.size()) {
                    if (this.headerList.get(i).isEmpty()) {
                        this.headerList.set(i, "Col #" + (i + 1));
                    }
                    ++i;
                }
            }
            this.parseHeadersDone = true;
        }
    }

    protected void parseHeadersWithoutDelimiter() throws IOException {
        int counter = 0;
        if (this.headerList == null) {
            this.headerList = new ArrayList<String>();
        }
        try (BufferedReader bReader = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            while ((line = bReader.readLine()) != null) {
                if (!line.isEmpty() && line.charAt(0) != '#') break;
            }
            if (line != null && line.length() > 0) {
                line = line.trim();
                StringBuilder sbuilder = new StringBuilder();
                int i = 0;
                while (i < line.length() && counter < this.columnCount) {
                    if (line.charAt(i) == this.separator) {
                        this.headerList.add(sbuilder.toString().replaceAll("\"", ""));
                        ++counter;
                        sbuilder = new StringBuilder();
                    } else {
                        sbuilder.append(line.charAt(i));
                    }
                    ++i;
                }
                if (counter < this.columnCount) {
                    this.headerList.add(sbuilder.toString().replaceAll("\"", ""));
                }
                i = 0;
                while (i < this.headerList.size()) {
                    if (this.headerList.get(i).isEmpty()) {
                        this.headerList.set(i, "Col #" + (i + 1));
                    }
                    ++i;
                }
                String[] headerArray = new String[this.headerList.size()];
                int i2 = 0;
                while (i2 < this.headerList.size()) {
                    headerArray[i2] = this.headerList.get(i2).trim().replaceAll("\"", "");
                    ++i2;
                }
            }
            this.parseHeadersDone = true;
        }
    }

    private void parseModelBuffered(boolean appendIndex) throws IOException, InterruptedException {
        char[] charBuffer = new char[524288];
        int linesRead = 0;
        int readBytes = 0;
        ArrayList<String> row = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile), 524288);){
            List<String> listFields;
            this.modelRowBuilder = new StringBuilder();
            if (appendIndex) {
                row.add("0");
                row.add(String.valueOf(linesRead + 1));
            }
            while ((readBytes = reader.read(charBuffer)) != -1) {
                int i = 0;
                while (i < readBytes) {
                    List<String> listFields2;
                    if (charBuffer[i] == '\n') {
                        if (i < readBytes - 1 && charBuffer[i + 1] == '\r') {
                            ++i;
                        }
                        if (!(this.hasHeader && linesRead <= 0 || (listFields2 = this.readCsvLine(this.modelRowBuilder.toString())) == null || listFields2.size() <= 0)) {
                            row.addAll(listFields2);
                            if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                                this.model.add(row);
                            }
                        }
                        if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                            ++linesRead;
                        }
                        this.modelRowBuilder.delete(0, this.modelRowBuilder.length());
                        row = new ArrayList();
                        if (appendIndex) {
                            row.add("0");
                            row.add(String.valueOf(this.model.size() + 1));
                        }
                    } else if (charBuffer[i] == '\r') {
                        if (i < readBytes - 1 && charBuffer[i + 1] == '\n') {
                            ++i;
                        }
                        if (!(this.hasHeader && linesRead <= 0 || (listFields2 = this.readCsvLine(this.modelRowBuilder.toString())) == null || listFields2.size() <= 0)) {
                            row.addAll(listFields2);
                            if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                                this.model.add(row);
                            }
                        }
                        if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                            ++linesRead;
                        }
                        this.modelRowBuilder.delete(0, this.modelRowBuilder.length());
                        row = new ArrayList();
                        if (appendIndex) {
                            row.add("0");
                            row.add(String.valueOf(this.model.size() + 1));
                        }
                    } else {
                        this.modelRowBuilder.append(charBuffer[i]);
                    }
                    ++i;
                }
            }
            if (this.modelRowBuilder.length() > 0 && (listFields = this.readCsvLineWithoutDelimiter(this.modelRowBuilder.toString())) != null && listFields.size() > 0) {
                row.addAll(listFields);
                if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                    this.model.add(row);
                }
            }
            this.parseModelDone = true;
        }
    }

    protected void parseModelBufferedWithoutDelimiter(boolean appendIndex) throws IOException, InterruptedException {
        int linesRead = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile), 524288);){
            List<String> listFields;
            char[] charBuffer = new char[524288];
            int readBytes = 0;
            this.modelRowBuilder = new StringBuilder();
            ArrayList<String> row = new ArrayList<String>();
            if (appendIndex) {
                row.add("0");
                row.add(String.valueOf(linesRead + 1));
            }
            while ((readBytes = reader.read(charBuffer)) != -1) {
                int i = 0;
                while (i < readBytes) {
                    List<String> listFields2;
                    if (charBuffer[i] == '\n') {
                        if (i < readBytes - 1 && charBuffer[i + 1] == '\r') {
                            ++i;
                        }
                        if (!(this.hasHeader && linesRead <= 0 || (listFields2 = this.readCsvLineWithoutDelimiter(this.modelRowBuilder.toString())) == null || listFields2.size() <= 0)) {
                            row.addAll(listFields2);
                            if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                                this.model.add(row);
                            }
                        }
                        if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                            ++linesRead;
                        }
                        this.modelRowBuilder.replace(0, this.modelRowBuilder.length(), "");
                        row = new ArrayList();
                        if (appendIndex) {
                            row.add("0");
                            row.add(String.valueOf(this.model.size() + 1));
                        }
                    } else if (charBuffer[i] == '\r') {
                        if (i < readBytes - 1 && charBuffer[i + 1] == '\n') {
                            ++i;
                        }
                        if (!(this.hasHeader && linesRead <= 0 || (listFields2 = this.readCsvLineWithoutDelimiter(this.modelRowBuilder.toString())) == null || listFields2.size() <= 0)) {
                            row.addAll(listFields2);
                            if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                                this.model.add(row);
                            }
                        }
                        if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                            ++linesRead;
                        }
                        this.modelRowBuilder.replace(0, this.modelRowBuilder.length(), "");
                        row = new ArrayList();
                        if (appendIndex) {
                            row.add("0");
                            row.add(String.valueOf(this.model.size() + 1));
                        }
                    } else {
                        this.modelRowBuilder.append(charBuffer[i]);
                    }
                    ++i;
                }
            }
            if (this.modelRowBuilder.length() > 0 && (listFields = this.readCsvLineWithoutDelimiter(this.modelRowBuilder.toString())) != null && listFields.size() > 0) {
                row.addAll(listFields);
                if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                    this.model.add(row);
                }
            }
            this.parseModelDone = true;
        }
    }

    private List<String> readCsvLine(String csvLine) {
        int countCurrent;
        ArrayList<String> listFields = new ArrayList<String>();
        csvLine = csvLine.trim();
        int lineLength = csvLine.length();
        boolean delimiterOpen = false;
        StringBuilder sBuilder = new StringBuilder();
        int i = 0;
        while (i < lineLength) {
            if (csvLine.charAt(i) == this.delimiter) {
                if (i == 0) {
                    delimiterOpen = true;
                } else if (csvLine.charAt(i - 1) == '\\') {
                    sBuilder.append(csvLine.charAt(i));
                } else {
                    delimiterOpen = !delimiterOpen;
                }
            } else if (csvLine.charAt(i) == this.separator && !delimiterOpen) {
                listFields.add(sBuilder.toString());
                sBuilder = new StringBuilder();
            } else {
                sBuilder.append(csvLine.charAt(i));
            }
            ++i;
        }
        if (lineLength - 1 >= 0 && csvLine.charAt(lineLength - 1) != this.separator) {
            listFields.add(sBuilder.toString());
        }
        int i2 = countCurrent = listFields.size();
        while (i2 < this.columnCount) {
            listFields.add("");
            ++i2;
        }
        return listFields;
    }

    protected List<String> readCsvLineWithoutDelimiter(String csvLine) {
        int countCurrent;
        ArrayList<String> listFields = new ArrayList<String>();
        int lineLength = csvLine.length();
        StringBuilder sBuilder = new StringBuilder();
        boolean delimiterOpen = false;
        if (csvLine == null || csvLine.trim().length() == 0) {
            return null;
        }
        int i = 0;
        while (i < lineLength) {
            if (csvLine.charAt(i) == '\"') {
                if (i > 0) {
                    if (csvLine.charAt(i - 1) != '\\') {
                        delimiterOpen = !delimiterOpen;
                    }
                } else {
                    delimiterOpen = !delimiterOpen;
                }
                if (this.perserveDelimiter) {
                    sBuilder.append(csvLine.charAt(i));
                }
            }
            if (csvLine.charAt(i) == this.separator) {
                if (!delimiterOpen) {
                    listFields.add(sBuilder.toString());
                    sBuilder = new StringBuilder();
                } else {
                    sBuilder.append(csvLine.charAt(i));
                }
            } else if (csvLine.charAt(i) == '\"') {
                if (delimiterOpen && i > 0 && csvLine.charAt(i - 1) == '\\') {
                    sBuilder.append(csvLine.charAt(i));
                }
            } else {
                sBuilder.append(csvLine.charAt(i));
            }
            ++i;
        }
        if (csvLine.charAt(lineLength - 1) != this.separator) {
            listFields.add(sBuilder.toString());
        }
        boolean lineIsEmpty = true;
        int i2 = 0;
        while (i2 < listFields.size() && lineIsEmpty) {
            if (((String)listFields.get(i2)).trim().length() > 0) {
                lineIsEmpty = false;
            }
            ++i2;
        }
        if (lineIsEmpty) {
            return null;
        }
        int i3 = countCurrent = listFields.size();
        while (i3 < this.columnCount) {
            listFields.add("");
            ++i3;
        }
        return listFields;
    }

    public int saveModel(List<List<String>> model, String outputFile, char fieldSeparator, char fieldDelimiter, String[] headers, boolean ignoreFirst) throws IOException {
        int columnPadding = 0;
        if (ignoreFirst) {
            columnPadding = 2;
        }
        if (model == null) {
            System.err.println("CSVUtils->saveTable(): table is null");
            return -1;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile, false));
        String delimiter = "";
        if (fieldDelimiter != 'N') {
            delimiter = String.valueOf(fieldDelimiter);
        }
        try {
            if (headers != null && headers.length > 0) {
                int i = 0;
                while (i < headers.length - 1) {
                    String h = headers[i].replace("\"", "");
                    bw.append(String.valueOf(delimiter) + h + delimiter + fieldSeparator);
                    ++i;
                }
                bw.append(String.valueOf(delimiter) + headers[headers.length - 1] + delimiter);
                bw.newLine();
            }
            for (List<String> row : model) {
                int i = columnPadding;
                while (i < row.size() - 1) {
                    bw.append(String.valueOf(delimiter) + row.get(i).replace("\n", "<br>") + delimiter + fieldSeparator);
                    ++i;
                }
                bw.append(String.valueOf(delimiter) + row.get(row.size() - 1).replace("\n", "<br>") + delimiter);
                bw.newLine();
            }
            return 1;
        }
        finally {
            bw.close();
        }
    }

    private void parseRepeatedQueries(int sequenceColumnIndex) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));
        try {
            String line;
            String lastValue = null;
            while ((line = reader.readLine()) != null) {
                List<String> row = this.delimiter == 'N' ? this.readCsvLineWithoutDelimiter(line) : this.readCsvLine(line);
                if (row == null || sequenceColumnIndex >= row.size()) continue;
                String value = row.get(sequenceColumnIndex);
                if (lastValue == null) {
                    lastValue = value;
                    continue;
                }
                if (lastValue.equals(value)) {
                    this.hasRepeatedQueries = true;
                    return;
                }
                lastValue = value;
            }
            this.hasRepeatedQueries = false;
        }
        finally {
            this.parseRepeatedQueriesDone = true;
            reader.close();
        }
    }

    public boolean hasRepeatedQueries(int sequenceColumnIndex) throws IOException {
        if (!this.parseRepeatedQueriesDone) {
            this.parseRepeatedQueries(sequenceColumnIndex);
        }
        return this.hasRepeatedQueries;
    }

    private void parseComments() throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            boolean isCommentLine = true;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null && isCommentLine) {
                if (line.length() == 0) {
                    builder.append(line);
                    builder.append("\n");
                    continue;
                }
                if (line.charAt(0) == '#') {
                    builder.append(line);
                    builder.append("\n");
                    continue;
                }
                isCommentLine = false;
            }
            this.comments = builder.toString();
            this.parseCommentsDone = true;
        }
    }

    public String getComments(boolean force) throws IOException {
        if (!this.parseCommentsDone || force) {
            this.parseComments();
        }
        return this.comments;
    }

    public Map<String, String> getCommentsAsMap(boolean force) throws IOException {
        if (!this.parseCommentsDone || force) {
            this.parseComments();
        }
        String[] lines = this.comments.split("\n");
        HashMap<String, String> mapComments = new HashMap<String, String>();
        if (lines.length > 0) {
            int i = 0;
            while (i < lines.length) {
                String currentLine;
                if (lines[i].length() > 0 && (currentLine = lines[i].trim()).indexOf("=") >= 0) {
                    String[] cols = currentLine.split("=");
                    mapComments.put(cols[0].replace("#", ""), cols[1]);
                }
                ++i;
            }
        }
        return mapComments;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMultiHitComment() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            do {
                if ((line = reader.readLine()) == null) {
                    return null;
                }
                if (line.charAt(0) == '#') continue;
                return null;
            } while (line.indexOf(MULTIHIT_LABEL) != 0);
            String string = line.substring(MULTIHIT_LABEL.length()).trim();
            return string;
        }
        catch (Exception e) {
            if (!this.debug) return null;
            e.printStackTrace();
            return null;
        }
    }

    public List<List<String>> getModel(boolean appendIndex, boolean force) throws IOException, InterruptedException, ModelNotParsedException {
        if (this.model == null) {
            this.model = new ArrayList<List<String>>();
        }
        if (!this.parseModelDone || force) {
            if (this.delimiter == 'N') {
                this.parseModelBufferedWithoutDelimiter(appendIndex);
            } else {
                this.parseModelBuffered(appendIndex);
            }
        }
        if (!this.parseModelDone) {
            throw new ModelNotParsedException();
        }
        return this.model;
    }

    public void filterMultiHitBufferedBestDescription(int nameColumn, int descriptionColumn, int scoreColumn, int evalueColumn, String newFileName) throws IOException, InterruptedException, ModelNotParsedException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(newFileName));){
            writer.append(MULTIHIT_LABEL + this.csvFile.getAbsolutePath());
            writer.newLine();
            writer.append(this.rowToString(this.headerList));
            writer.newLine();
            ArrayList<SequencePosition> listPositions = new ArrayList<SequencePosition>();
            List<List<String>> modelFull = this.getModel(false, true);
            int i = 0;
            while (i < modelFull.size()) {
                List<String> row = modelFull.get(i);
                String name = row.get(nameColumn);
                int res = Collections.binarySearch(listPositions, name, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return ((SequencePosition)o1).getHash().compareTo((String)o2);
                    }
                });
                if (res < 0) {
                    listPositions.add(-res - 1, new SequencePosition(name, i));
                } else {
                    ((SequencePosition)listPositions.get(res)).addPosition(i);
                }
                ++i;
            }
            for (SequencePosition sp : listPositions) {
                ArrayList<List<String>> listGroup = new ArrayList<List<String>>();
                for (int i2 : sp.getPositions()) {
                    listGroup.add(modelFull.get(i2));
                }
                double wordValue = this.getWordValue(listGroup, scoreColumn);
                int[] values = new int[listGroup.size()];
                String sEvalue = WorksheetUtils.parseEvalueColValue((String)((List)listGroup.get(0)).get(evalueColumn));
                int maxEvalue = 0;
                try {
                    double dEvalue = Double.parseDouble(sEvalue);
                    maxEvalue = dEvalue == 0.0 ? 180 : (int)Math.abs(Math.round(Math.log10(dEvalue)));
                }
                catch (Exception ex) {
                    maxEvalue = 0;
                }
                if (this.debug) {
                    System.out.println("max exp: " + maxEvalue);
                }
                int i3 = 0;
                while (i3 < listGroup.size()) {
                    String name = (String)((List)listGroup.get(i3)).get(nameColumn);
                    String description = ((String)((List)listGroup.get(i3)).get(descriptionColumn)).toUpperCase();
                    String score = WorksheetUtils.parseScoreColValue((String)((List)listGroup.get(i3)).get(scoreColumn));
                    String evalue = WorksheetUtils.parseEvalueColValue((String)((List)listGroup.get(i3)).get(evalueColumn));
                    int evalueExp = 0;
                    if (description.indexOf(">") > 0) {
                        description = description.substring(0, description.indexOf(">"));
                    }
                    if (description.indexOf(";") > 0) {
                        description = description.substring(0, description.indexOf(";"));
                    }
                    try {
                        double dEvalue = Double.parseDouble(evalue);
                        evalueExp = dEvalue == 0.0 ? 180 : (int)Math.abs(Math.round(Math.log10(dEvalue)));
                    }
                    catch (Exception ex) {
                        evalueExp = 0;
                    }
                    try {
                        values[i3] = Integer.parseInt(score);
                    }
                    catch (Exception ex) {
                        values[i3] = 0;
                    }
                    double eValueDiff = (100.0 - ((double)maxEvalue - (double)evalueExp)) / 100.0;
                    if (description.toUpperCase().contains("HYPOTHETICAL PROTEIN") || description.toUpperCase().contains("PUTATIVE PROTEIN") || description.toUpperCase().contains("UNKNOWN FUNCTION") || description.toUpperCase().contains("UNNAMED PROTEIN") || description.toUpperCase().contains("UNNAMED PROTEIN PRODUCT") || description.toUpperCase().contains("PREDICTED PROTEIN") || description.toUpperCase().contains("PREDICTED") || description.toUpperCase().contains("LOW QUALITY PROTEIN") || description.toUpperCase().contains("UNCHARACTERIZED")) {
                        int n = i3;
                        values[n] = (int)((double)values[n] - wordValue * 100.0);
                    } else if (description.toUpperCase().contains("NO SIGNIFICANT")) {
                        int n = i3;
                        values[n] = (int)((double)values[n] - wordValue * 1000.0);
                    } else {
                        String[] tokens = description.split("\\s+");
                        if (tokens.length > 1) {
                            int n = i3;
                            values[n] = (int)((double)values[n] + (double)(tokens.length - 1) * (wordValue * eValueDiff));
                        }
                    }
                    if (this.debug) {
                        System.out.println("[" + i3 + "]Name: " + name);
                        System.out.println("\tDescription: " + description);
                        System.out.println("\tE-value: " + evalue);
                        System.out.println("\tEvalue diff: " + eValueDiff);
                        System.out.println("\tScore: " + score);
                        System.out.println("\tNew score: " + values[i3]);
                    }
                    ++i3;
                }
                int higherScoreIndex = 0;
                if (values.length > 1) {
                    int i4 = 1;
                    while (i4 < values.length) {
                        if (values[i4] > values[higherScoreIndex]) {
                            higherScoreIndex = i4;
                        }
                        ++i4;
                    }
                }
                if (this.debug) {
                    System.out.println("Word value: " + wordValue);
                    System.out.println("Best value: " + values[higherScoreIndex]);
                    System.out.println("Desc[" + higherScoreIndex + "]: " + (String)((List)listGroup.get(higherScoreIndex)).get(descriptionColumn));
                }
                writer.append(this.rowToString((List)listGroup.get(higherScoreIndex)));
                writer.newLine();
            }
        }
    }

    private String rowToString(List<String> row) {
        StringBuilder builder = new StringBuilder();
        String finalDelimiter = "";
        if (this.delimiter != 'N') {
            finalDelimiter = String.valueOf(this.delimiter);
        }
        if (row != null && row.size() > 0) {
            int i = 0;
            while (i < row.size() - 1) {
                builder.append(String.valueOf(finalDelimiter) + row.get(i) + finalDelimiter + this.separator);
                ++i;
            }
            builder.append(String.valueOf(finalDelimiter) + row.get(row.size() - 1) + finalDelimiter);
        }
        return builder.toString();
    }

    private double getWordValue(List<List<String>> listGroup, int scoreColumn) {
        ArrayList<Double> listScores = new ArrayList<Double>();
        double sumScores = 0.0;
        for (List<String> row : listGroup) {
            try {
                String sScore = WorksheetUtils.parseScoreColValue(row.get(scoreColumn));
                listScores.add(Double.parseDouble(sScore));
                sumScores += Double.parseDouble(sScore);
            }
            catch (Exception sScore) {
                // empty catch block
            }
        }
        double mean = sumScores / (double)listScores.size();
        double error = 0.0;
        Iterator iterator = listScores.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            error += Math.abs(d - mean);
        }
        double errorMean = error / (double)listScores.size();
        if (errorMean == 0.0) {
            errorMean = 10.0;
        }
        return errorMean;
    }

    public void filterMultiHitBuffered(int column, String newFileName) throws InterruptedException, IOException {
        char[] charBuffer = new char[524288];
        int readBytes = -1;
        BufferedReader reader = new BufferedReader(new FileReader(this.csvFile), 524288);
        BufferedWriter writer = new BufferedWriter(new FileWriter(newFileName));
        ArrayList<String> row = new ArrayList<String>();
        ArrayList<String> listReadNames = new ArrayList<String>();
        try {
            this.modelRowBuilder = new StringBuilder();
            writer.append(MULTIHIT_LABEL + this.csvFile.getAbsolutePath());
            writer.newLine();
            while ((readBytes = reader.read(charBuffer)) != -1) {
                int i = 0;
                while (i < readBytes) {
                    String currentName;
                    int res;
                    List<String> listFields;
                    if (charBuffer[i] == '\n') {
                        if (i < readBytes - 1 && charBuffer[i + 1] == '\r') {
                            ++i;
                        }
                        if ((listFields = this.delimiter == 'N' ? this.readCsvLineWithoutDelimiter(this.modelRowBuilder.toString()) : this.readCsvLine(this.modelRowBuilder.toString())) != null && listFields.size() > 0 && this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#' && (res = Collections.binarySearch(listReadNames, currentName = listFields.get(column))) < 0) {
                            listReadNames.add(-res - 1, currentName);
                            writer.append(this.modelRowBuilder.toString());
                            writer.newLine();
                        }
                        this.modelRowBuilder.delete(0, this.modelRowBuilder.length());
                        row = new ArrayList();
                    } else if (charBuffer[i] == '\r') {
                        if (i < readBytes - 1 && charBuffer[i + 1] == '\n') {
                            ++i;
                        }
                        if ((listFields = this.delimiter == 'N' ? this.readCsvLineWithoutDelimiter(this.modelRowBuilder.toString()) : this.readCsvLine(this.modelRowBuilder.toString())) != null && listFields.size() > 0) {
                            row.addAll(listFields);
                            if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#' && (res = Collections.binarySearch(listReadNames, currentName = listFields.get(column))) < 0) {
                                listReadNames.add(-res - 1, currentName);
                                writer.append(this.modelRowBuilder.toString());
                                writer.newLine();
                            }
                        }
                        this.modelRowBuilder.delete(0, this.modelRowBuilder.length());
                        row = new ArrayList();
                    } else {
                        this.modelRowBuilder.append(charBuffer[i]);
                    }
                    ++i;
                }
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    public void filterMutiHit(int column, char fieldSeparator, char fieldDelimiter, String newFileName, int columnCount) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(newFileName));
        try {
            String line;
            String lastSequence = null;
            writer.append(MULTIHIT_LABEL + this.csvFile.getAbsolutePath());
            writer.newLine();
            while ((line = reader.readLine()) != null) {
                List<String> row = this.readCsvLine(line);
                if (lastSequence != null && row.get(column).equals(lastSequence)) continue;
                for (String s : row) {
                    writer.append(String.valueOf(fieldDelimiter) + s + fieldDelimiter + fieldSeparator);
                }
                writer.newLine();
                lastSequence = row.get(column);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<List<String>> extractMatchingRows(File csvFile, String subject, int columnIndex, char separator, char delimiter, int columnCount) {
        ArrayList<List<String>> matchingRows = new ArrayList<List<String>>();
        boolean subjectFound = false;
        int lineCount = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(csvFile));){
            String line = null;
            while (true) {
                if ((line = reader.readLine()) == null) {
                    if (!subjectFound) return null;
                    ArrayList<List<String>> arrayList = matchingRows;
                    return arrayList;
                }
                List<String> row = this.readCsvLine(line);
                String rowSubject = row.get(columnIndex);
                if (rowSubject.equals(subject)) {
                    if (!subjectFound) {
                        subjectFound = true;
                    }
                    row.add(0, String.valueOf(lineCount));
                    matchingRows.add(row);
                } else if (subjectFound) {
                    ArrayList<List<String>> arrayList = matchingRows;
                    return arrayList;
                }
                ++lineCount;
            }
        }
        catch (Exception e) {
            if (!this.debug) return null;
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean switchRows(int index1, int index2, boolean hasHeader) {
        StringBuilder buffer = new StringBuilder();
        if (hasHeader) {
            ++index1;
            ++index2;
        }
        if (index1 == index2) {
            return false;
        }
        if (index1 > index2) {
            int tmp = index1;
            index1 = index2;
            index2 = tmp;
        }
        try {
            File tempFile = new File(String.valueOf(this.csvFile.getAbsolutePath()) + ".tmp");
            BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
            try {
                String finalName;
                String firstLine = null;
                int i = 0;
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        buffer = null;
                        finalName = this.csvFile.getAbsolutePath();
                        if (this.csvFile.delete()) break;
                        return false;
                    }
                    if (i < index1) {
                        writer.append(line);
                        writer.newLine();
                    } else if (i == index1) {
                        firstLine = line;
                    } else if (i < index2) {
                        buffer.append(String.valueOf(line) + "\n");
                    } else if (i == index2) {
                        writer.append(line);
                        writer.newLine();
                        writer.append(buffer.toString());
                        writer.append(firstLine);
                        writer.newLine();
                    } else {
                        writer.append(line);
                        writer.newLine();
                    }
                    ++i;
                }
                tempFile.renameTo(new File(finalName));
                return true;
            }
            finally {
                reader.close();
                writer.close();
            }
        }
        catch (IOException e) {
            if (!this.debug) return false;
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateMultihitFromSinglehit(File multihitCsv, int queryColIndex, char fieldSeparator, char fieldDelimiter, char innerSeparator, int columnCountmonitor) {
        File tempFile = new File(String.valueOf(multihitCsv.getAbsolutePath()) + "_reloaded.csv");
        BufferedWriter writer = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));
            try {
                writer = new BufferedWriter(new FileWriter(tempFile));
                String line = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    List<String> row = this.readCsvLine(line);
                    String query = row.get(queryColIndex);
                    List<List<String>> matchingRows = this.extractMatchingRows(multihitCsv, query, queryColIndex, fieldSeparator, fieldDelimiter, this.columnCount);
                    if (matchingRows == null) continue;
                    for (List<String> mr : matchingRows) {
                        for (String s : mr) {
                            writer.append(String.valueOf(fieldDelimiter) + s + fieldDelimiter + fieldSeparator);
                        }
                        writer.newLine();
                    }
                }
            }
            finally {
                reader.close();
                writer.close();
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private void parseFileLineCount() throws IOException {
        this.lineCount = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));){
            char[] buffer = new char[524288];
            int charsRead = 0;
            while ((charsRead = reader.read(buffer)) != -1) {
                int i = 0;
                while (i < charsRead) {
                    char currentChar = buffer[i];
                    if (currentChar == '\n') {
                        if (i < charsRead - 1 && buffer[i + 1] == '\r') {
                            ++i;
                        }
                        ++this.lineCount;
                    } else if (currentChar == '\r') {
                        if (i < charsRead - 1 && buffer[i + 1] == '\n') {
                            ++i;
                        }
                        ++this.lineCount;
                    }
                    ++i;
                }
            }
            this.parseLineCountDone = true;
        }
    }

    public int getColumnCount() throws ColumnCountNotDoneException {
        if (!this.parseColumnCountDone) {
            throw new ColumnCountNotDoneException();
        }
        return this.columnCount;
    }

    public int getLineCount() throws LineCountNotDoneException {
        if (!this.parseLineCountDone) {
            throw new LineCountNotDoneException();
        }
        return this.lineCount;
    }

    public static String rowToString(List<String> dataRow, char separator, char delimiter, boolean removeFirstFileds) {
        StringBuilder builder = new StringBuilder();
        int startIndex = 0;
        if (removeFirstFileds) {
            startIndex = 2;
        }
        String finalDelimiter = "";
        if (delimiter != 'N') {
            finalDelimiter = String.valueOf(delimiter);
        }
        int i = startIndex;
        while (i < dataRow.size() - 1) {
            builder.append(String.valueOf(finalDelimiter) + dataRow.get(i) + finalDelimiter + separator);
            ++i;
        }
        builder.append(String.valueOf(finalDelimiter) + dataRow.get(dataRow.size() - 1) + finalDelimiter);
        return builder.toString();
    }

    public char getSeparator() throws SeparatorNotParsedException {
        if (!this.parseSeparatorDone) {
            throw new SeparatorNotParsedException();
        }
        return this.separator;
    }

    public char getDelimiter() throws DelimiterNotParsedException {
        if (!this.parseDelimiterDone) {
            throw new DelimiterNotParsedException();
        }
        return this.delimiter;
    }

    public boolean columnIsOrdered(int columnIndex) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            String previousRow = null;
            int lineCounter = 0;
            int previousComparation = 0;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.length() == 0) continue;
                if (lineCounter == 0) {
                    lineCounter = 1;
                    continue;
                }
                List<String> row = this.readCsvLine(line);
                String currentRow = row.get(columnIndex);
                if (previousRow == null) {
                    previousRow = currentRow;
                } else {
                    int resComp = currentRow.compareTo(previousRow);
                    System.out.println("Res: " + resComp);
                    if (resComp != 0) {
                        if (resComp > 0) {
                            if (previousComparation < 0) {
                                return false;
                            }
                            previousComparation = resComp;
                        } else {
                            if (previousComparation > 0) {
                                return false;
                            }
                            previousComparation = resComp;
                        }
                    }
                }
                previousRow = currentRow;
                ++lineCounter;
            }
        }
        return true;
    }

    public void setSeparator(char fieldSeparator) {
        this.separator = fieldSeparator == '\t' ? Separators.TAB.getSeparator() : (fieldSeparator == ',' ? Separators.COMMA.getSeparator() : (fieldSeparator == ';' ? Separators.SEMICOLON.getSeparator() : (fieldSeparator == ' ' ? Separators.SPACE.getSeparator() : (fieldSeparator == ':' ? Separators.COLON.getSeparator() : fieldSeparator))));
    }

    public void setDelimiter(char fieldDelimiter) {
        this.delimiter = fieldDelimiter;
    }

    public class CannotOpenFileException
    extends Exception {
        private static final long serialVersionUID = -8984010975041837763L;
    }

    public class ColumnCountNotDoneException
    extends Exception {
        private static final long serialVersionUID = -9171821831477919307L;
    }

    public class CommentsNotParsedException
    extends Exception {
        private static final long serialVersionUID = 3340943208323178444L;
    }

    public class DelimiterNotParsedException
    extends Exception {
        private static final long serialVersionUID = -9006341369939089826L;
    }

    public class HeadersNotParsedException
    extends Exception {
        private static final long serialVersionUID = -5430935669190895655L;
    }

    public class LineCountNotDoneException
    extends Exception {
        private static final long serialVersionUID = -5651142957330127449L;
    }

    public class ModelNotParsedException
    extends Exception {
        private static final long serialVersionUID = 6911353102546552644L;
    }

    public class SeparatorNotParsedException
    extends Exception {
        private static final long serialVersionUID = 9002374952764451449L;
    }

    public static enum Separators {
        SEMICOLON(0, ';'),
        COLON(1, ':'),
        SPACE(2, ' '),
        TAB(3, '\t'),
        COMMA(4, ',');

        private int index;
        private char separator;

        private Separators(int index, char separator) {
            this.index = index;
            this.separator = separator;
        }

        public int getIndex() {
            return this.index;
        }

        public char getSeparator() {
            return this.separator;
        }
    }
}

