/*
 * @author		Alfonso Muñoz-Pomer Fuentes, 
 * 				<a href="mailto:alfonso.munozpomer@biotechvana.com">
 * 				alfonso.munozpomer@biotechvana.com</a>,  
 * 				<a href="http://www.biotechvana.com">Biotechvana</a>
 *
 * @date		2010-11-01
 * 
 * @copyright	Copyright Biotech Vana, S.L. 2006-2011
 */

package com.biotechvana.javabiotoolkit;

/**
 * An enumeration of the two directionalities for a peptide sequence. Namely, N to C directionality (direct) and C to 
 * N directionality (reverse).
 * 
 * @version	1.5, 2011-07-19
 * 
 * @author	<a href="mailto:alfonso.munozpomer@biotechvana.com">Alfonso Muñoz-Pomer Fuentes</a>,
 * 			<a href="http://www.biotechvana.com">Biotechvana</a>.
 * 
 * @see		ProteinSequence
 */
public enum PeptideSequenceDirectionality implements BioSequenceDirectionality
{
	/**
	 * N-terminal to C-terminal
	 */
	N_C("N-C", "N-terminus to C-terminus"),
	/**
	 * C-terminal to N-terminal
	 */
	C_N("C-N", "C-terminus to N-terminus");
	private String name;
	private String fullName;

	/*
	 * Default private constructor.
	 */
	private PeptideSequenceDirectionality(String name, String fullName)
	{
		this.name = name;
		this.fullName = fullName;
	}
	
	/**
	 * Returns the full name of this direction.
	 * 
	 * @return	full name of the receiver.
	 * 
	 * @since	0.1
	 */
	@Override
	public String getFullName()
	{
		return fullName;
	}
	
	/**
	 * Returns the reverse of this direction.
	 * 
	 * @return	reverse direction of the receiver.
	 * 
	 * @since	1.1
	 */
	@Override
	public PeptideSequenceDirectionality reverse()
	{
		if (this == N_C)
		{
			return C_N;
		}
		else
		{
			return N_C;
		}
	}
	
	/*
	 * (non-Javadoc) @see java.lang.Enum#toString()
	 */
	@Override
	public String toString()
	{
		return name;
	}
}