/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.utils;

import com.biotechvana.javabiotoolkit.io.FASTAFileRecord;
import com.biotechvana.utils.SequenceItem;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Table;

public class TermMatcher {
    private static final String TITLE = "Find term";

    public static int replaceAllInSequenceList(String term, String replacement, List<SequenceItem> listSequenceItems, boolean regexp, boolean caseSensitive, boolean exact, IProgressMonitor monitor) {
        int countReplacements = 0;
        int totalWork = listSequenceItems.size();
        int stepSize = listSequenceItems.size() / totalWork;
        if (stepSize < 1) {
            stepSize = 0;
        }
        monitor.beginTask("Replace", totalWork);
        term = TermMatcher.escapeTermForReplace(term, exact, caseSensitive, regexp);
        int i = 0;
        while (i < listSequenceItems.size()) {
            String finalText;
            SequenceItem item = listSequenceItems.get(i);
            String initialText = item.getName();
            if (!initialText.equals(finalText = initialText.replaceAll(term, replacement))) {
                item.setName(finalText);
                ++countReplacements;
            }
            if (i % stepSize == 0) {
                monitor.worked(1);
            }
            ++i;
        }
        monitor.done();
        return countReplacements;
    }

    public static int replaceAllInTable(String term, String replacement, Table tableSequences, boolean regexp, boolean caseSensitive, boolean exact, IProgressMonitor monitor) {
        int countReplacements = 0;
        term = TermMatcher.escapeTermForReplace(term, exact, caseSensitive, regexp);
        int i = 0;
        while (i < tableSequences.getItemCount()) {
            String finalText;
            String initialText = tableSequences.getItem(i).getText(1);
            if (!initialText.equals(finalText = initialText.replaceAll(term, replacement))) {
                tableSequences.getItem(i).setText(1, finalText);
                ++countReplacements;
            }
            ++i;
        }
        return countReplacements;
    }

    public static boolean replaceCurrentInTable(String term, String replacement, Table tableSequences, int currentIndex, boolean regexp, boolean caseSensitive, boolean exact, IProgressMonitor monitor) {
        String finalText;
        term = TermMatcher.escapeTermForReplace(term, exact, caseSensitive, regexp);
        String initialText = tableSequences.getItem(currentIndex).getText(1);
        if (!initialText.equals(finalText = initialText.replaceAll(term, replacement))) {
            tableSequences.getItem(currentIndex).setText(1, finalText);
            return true;
        }
        return false;
    }

    public static int[] selectByTermAsArray(String[] termList, String[] arrayNames, boolean regexp, boolean caseSensitive, boolean exact, IProgressMonitor monitor) throws Exception {
        List<Integer> listMatches = TermMatcher.selectByTermAsList(termList, arrayNames, regexp, caseSensitive, exact, monitor);
        int[] arrayMatches = new int[listMatches.size()];
        int i = 0;
        while (i < listMatches.size()) {
            arrayMatches[i] = listMatches.get(i);
            ++i;
        }
        return arrayMatches;
    }

    public static List<Integer> selectByTermAsList(String[] termList, String[] arrayNames, boolean regexp, boolean caseSensitive, boolean exact, IProgressMonitor monitor) throws Exception {
        try {
            monitor.beginTask(TITLE, termList.length);
            TreeSet<Integer> matchingIndices = new TreeSet<Integer>();
            String[] stringArray = termList;
            int n = termList.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                matchingIndices.addAll(TermMatcher.selectByTerm(t, arrayNames, regexp, caseSensitive, exact, monitor));
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++n2;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>(matchingIndices);
            return arrayList;
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            monitor.done();
        }
    }

    public static List<Integer> selectByTerm(String term, String[] arrayNames, boolean regexp, boolean caseSensitive, boolean exact, IProgressMonitor monitor) throws Exception {
        try {
            monitor.beginTask(TITLE, arrayNames.length);
            ArrayList<Integer> listIndices = new ArrayList<Integer>();
            term = TermMatcher.escapeTerm(term.trim(), exact, caseSensitive, regexp);
            int i = 0;
            while (i < arrayNames.length) {
                if (arrayNames[i].matches(term)) {
                    listIndices.add(i);
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
            ArrayList<Integer> arrayList = listIndices;
            return arrayList;
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            monitor.done();
        }
    }

    public static int[] selectByTermAsArray(String[] terms, List<FASTAFileRecord> listRecords, boolean regexp, boolean caseSensitive, boolean exact, IProgressMonitor monitor) throws Exception {
        try {
            monitor.beginTask(TITLE, terms.length);
            List<Integer> matchingIndices = TermMatcher.selectByTermAsList(terms, listRecords, regexp, caseSensitive, exact, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            int[] arrayIndices = new int[matchingIndices.size()];
            int i = 0;
            while (i < matchingIndices.size()) {
                monitor.subTask(terms[i]);
                arrayIndices[i] = matchingIndices.get(i);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
            int[] nArray = arrayIndices;
            return nArray;
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            monitor.done();
        }
    }

    public static List<Integer> selectByTermAsList(String[] terms, List<FASTAFileRecord> listRecords, boolean regexp, boolean caseSensitive, boolean exact, IProgressMonitor monitor) throws Exception {
        try {
            monitor.beginTask(TITLE, terms.length);
            TreeSet<Integer> matchingIndices = new TreeSet<Integer>();
            String[] stringArray = terms;
            int n = terms.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                monitor.subTask(t);
                matchingIndices.addAll(TermMatcher.selectByTermAsList(t, listRecords, regexp, caseSensitive, exact, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++n2;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>(matchingIndices);
            return arrayList;
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            monitor.done();
        }
    }

    public static List<Integer> selectByTermAsList2(String[] terms, List<FASTAFileRecord> listRecord, boolean regexp, boolean caseSensitive, boolean exact, IProgressMonitor monitor) {
        ArrayList<Integer> listIndices = new ArrayList<Integer>();
        String[] preparedTerms = new String[terms.length];
        int i = 0;
        while (i < terms.length) {
            preparedTerms[i] = TermMatcher.escapeTerm(terms[i], exact, caseSensitive, regexp).trim();
            ++i;
        }
        i = 0;
        while (i < preparedTerms.length) {
            System.out.println("pt: " + preparedTerms[i]);
            ++i;
        }
        monitor.beginTask("Find terms", listRecord.size());
        try {
            i = 0;
            while (i < listRecord.size()) {
                String fname = listRecord.get(i).getDescriptionSB().toString();
                String[] stringArray = preparedTerms;
                int n = preparedTerms.length;
                int n2 = 0;
                while (n2 < n) {
                    String pt = stringArray[n2];
                    if (fname.matches(pt)) {
                        listIndices.add(i);
                    }
                    ++n2;
                }
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return listIndices;
    }

    public static List<Integer> selectByTermAsList(String term, List<FASTAFileRecord> listRecords, boolean regexp, boolean caseSensitive, boolean exact, IProgressMonitor monitor) throws Exception {
        ArrayList<Integer> listIndices = new ArrayList<Integer>();
        term = TermMatcher.escapeTerm(term, exact, caseSensitive, regexp);
        try {
            monitor.beginTask(term, listRecords.size());
            int i = 0;
            while (i < listRecords.size()) {
                String name = listRecords.get(i).getDescriptionSB().toString();
                if (name.matches(term)) {
                    listIndices.add(i);
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
            ArrayList<Integer> arrayList = listIndices;
            return arrayList;
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            monitor.done();
        }
    }

    public static String escapeTerm(String term, boolean exact, boolean caseSensitive, boolean regexp) {
        StringBuilder pattern = new StringBuilder();
        if (!regexp) {
            term = term.replace("\\", "\\\\");
            term = term.replace(".", "\\.");
            term = term.replace("?", "\\?");
            term = term.replace("*", "\\*");
            term = term.replace("[", "\\[");
            term = term.replace("]", "\\]");
            term = term.replace("(", "\\(");
            term = term.replace(")", "\\(");
            term = term.replace("|", "\\|");
        } else {
            term = term.replace("\\\\", "\\");
        }
        if (!caseSensitive) {
            pattern.append("(?i)");
        }
        if (!exact) {
            pattern.append(".*" + term + ".*");
        } else {
            pattern.append(term);
        }
        return pattern.toString();
    }

    public static String escapeTerm(String term) {
        term = term.replace("\\", "\\\\");
        term = term.replace(".", "\\.");
        term = term.replace("?", "\\?");
        term = term.replace("*", "\\*");
        term = term.replace("[", "\\[");
        term = term.replace("]", "\\]");
        term = term.replace("(", "\\(");
        term = term.replace(")", "\\(");
        term = term.replace("|", "\\|");
        return term;
    }

    public static String escapeTermForReplace(String term, boolean exact, boolean caseSensitive, boolean regexp) {
        StringBuilder pattern = new StringBuilder();
        if (!regexp) {
            term = term.replace("\\", "\\\\");
            term = term.replace(".", "\\.");
            term = term.replace("?", "\\?");
            term = term.replace("*", "\\*");
            term = term.replace("[", "\\[");
            term = term.replace("]", "\\]");
            term = term.replace("(", "\\(");
            term = term.replace(")", "\\(");
            term = term.replace("|", "\\|");
        } else {
            term = term.replace("\\\\", "\\");
        }
        if (!caseSensitive) {
            pattern.append("(?i)");
        }
        pattern.append("(" + term + ")");
        return pattern.toString();
    }

    public static boolean sequenceNameMatchesPattern() {
        boolean matches = false;
        return matches;
    }
}

