/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class AlphanumComparator2
implements Comparator<String> {
    private final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private List<String> getChunks(String s) {
        ArrayList<String> chunks = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (s.length() == 0) {
            return chunks;
        }
        boolean readingDigit = false;
        if (this.isDigit(s.charAt(0))) {
            readingDigit = true;
        }
        builder.append(s.charAt(0));
        int i = 1;
        while (i < s.length()) {
            if (this.isDigit(s.charAt(i))) {
                if (!readingDigit) {
                    chunks.add(builder.toString());
                    builder = new StringBuilder();
                    readingDigit = true;
                }
            } else if (readingDigit) {
                chunks.add(builder.toString());
                builder = new StringBuilder();
                readingDigit = false;
            }
            builder.append(s.charAt(i));
            ++i;
        }
        chunks.add(builder.toString());
        return chunks;
    }

    @Override
    public int compare(String s1, String s2) {
        List<String> chunks1 = this.getChunks(s1);
        List<String> chunks2 = this.getChunks(s2);
        int chunkCount1 = 0;
        int chunkCount2 = 0;
        try {
            chunkCount1 = chunks1.size();
            try {
                chunkCount2 = chunks2.size();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            return 0;
        }
        int i = 0;
        while (i < chunkCount1 && i < chunkCount2) {
            String currentChunk1 = chunks1.get(i);
            String currentChunk2 = chunks2.get(i);
            boolean chunk1isDigit = false;
            boolean chunk2isDigit = false;
            if (this.isDigit(currentChunk1.charAt(0))) {
                chunk1isDigit = true;
            }
            if (this.isDigit(currentChunk2.charAt(0))) {
                chunk2isDigit = true;
            }
            if (chunk1isDigit && chunk2isDigit) {
                if (currentChunk1.compareTo(currentChunk2) != 0) {
                    try {
                        return Integer.parseInt(currentChunk1) - Integer.parseInt(currentChunk2);
                    }
                    catch (Exception ex) {
                        return 0;
                    }
                }
            } else {
                if (chunk1isDigit) {
                    return Integer.MIN_VALUE;
                }
                if (chunk2isDigit) {
                    return Integer.MAX_VALUE;
                }
                if (currentChunk1.compareToIgnoreCase(currentChunk2) != 0) {
                    return currentChunk1.compareToIgnoreCase(currentChunk2);
                }
            }
            ++i;
        }
        if (chunkCount1 == chunkCount2) {
            return 0;
        }
        if (chunkCount1 > chunkCount2) {
            return Integer.MAX_VALUE;
        }
        return Integer.MIN_VALUE;
    }
}

